/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.belt;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.equipment.armor.DivingBootsItem;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltShapes;
import com.zurrtum.create.content.kinetics.belt.BeltSlicer;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.BeltMovementHandler;
import com.zurrtum.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlock;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.items.ItemInventoryProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2891;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class BeltBlock
extends HorizontalKineticBlock
implements IBE<BeltBlockEntity>,
SpecialBlockItemRequirement,
TransformableBlock,
ProperWaterloggedBlock,
ItemInventoryProvider<BeltBlockEntity> {
    public static final class_2754<BeltSlope> SLOPE = class_2754.method_11850((String)"slope", BeltSlope.class);
    public static final class_2754<BeltPart> PART = class_2754.method_11850((String)"part", BeltPart.class);
    public static final class_2746 CASING = class_2746.method_11825((String)"casing");

    public BeltBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(SLOPE, (Comparable)((Object)BeltSlope.HORIZONTAL))).method_11657(PART, (Comparable)((Object)BeltPart.START))).method_11657((class_2769)CASING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public class_1263 getInventory(class_1936 world, class_2338 pos, class_2680 state, BeltBlockEntity blockEntity, class_2350 context) {
        if (!BeltBlock.canTransportObjects(blockEntity.method_11010())) {
            return null;
        }
        if (!blockEntity.method_11015() && blockEntity.itemHandler == null) {
            blockEntity.initializeItemHandler();
        }
        return blockEntity.itemHandler;
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(class_2680 oldState, class_2680 newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.method_11654(PART) == newState.method_11654(PART);
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        if (face.method_10166() != this.getRotationAxis(state)) {
            return false;
        }
        return this.getBlockEntityOptional((class_1922)world, pos).map(BeltBlockEntity::hasPulley).orElse(false);
    }

    @Override
    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        if (state.method_11654(SLOPE) == BeltSlope.SIDEWAYS) {
            return class_2350.class_2351.field_11052;
        }
        return ((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)).method_10170().method_10166();
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.BELT_CONNECTOR.method_7854();
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof BeltBlockEntity && ((BeltBlockEntity)blockEntity).hasPulley()) {
            drops.addAll(AllBlocks.SHAFT.method_9564().method_26189(builder));
        }
        return drops;
    }

    public void method_9565(class_2680 state, class_3218 worldIn, class_2338 pos, class_1799 p_220062_4_, boolean b) {
        BeltBlockEntity controllerBE = BeltHelper.getControllerBE((class_1936)worldIn, pos);
        if (controllerBE != null) {
            controllerBE.getInventory().ejectAll();
        }
    }

    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        class_2338 entityPosition = entityIn.method_24515();
        class_2338 beltPos = null;
        if (worldIn.method_8320(entityPosition).method_27852((class_2248)AllBlocks.BELT)) {
            beltPos = entityPosition;
        } else if (worldIn.method_8320(entityPosition.method_10074()).method_27852((class_2248)AllBlocks.BELT)) {
            beltPos = entityPosition.method_10074();
        }
        if (beltPos == null) {
            return;
        }
        if (!(worldIn instanceof class_1937)) {
            return;
        }
        class_1937 world = (class_1937)worldIn;
        this.method_9548(worldIn.method_8320(beltPos), world, beltPos, entityIn, class_10774.field_56634, false);
    }

    public void method_9548(class_2680 state, class_1937 worldIn, class_2338 pos, class_1297 entityIn, class_10774 handler, boolean bl) {
        if (!BeltBlock.canTransportObjects(state)) {
            return;
        }
        if (entityIn instanceof class_1657) {
            class_1657 player = (class_1657)entityIn;
            if (player.method_5715() && !player.method_6118(class_1304.field_6166).method_31574((class_1792)AllItems.CARDBOARD_BOOTS)) {
                return;
            }
            if (player.method_31549().field_7479) {
                return;
            }
        }
        if (DivingBootsItem.isWornBy(entityIn)) {
            return;
        }
        BeltBlockEntity belt = BeltHelper.getSegmentBE((class_1936)worldIn, pos);
        if (belt == null) {
            return;
        }
        class_1799 asItem = ItemHelper.fromItemEntity(entityIn);
        if (!asItem.method_7960()) {
            if (worldIn.method_8608()) {
                return;
            }
            if (entityIn.method_18798().field_1351 > 0.0) {
                return;
            }
            class_243 targetLocation = VecHelper.getCenterOf((class_2382)pos).method_1031(0.0, 0.3125, 0.0);
            if (!PackageEntity.centerPackage(entityIn, targetLocation)) {
                return;
            }
            if (BeltTunnelInteractionHandler.getTunnelOnPosition(worldIn, pos) != null) {
                return;
            }
            this.withBlockEntityDo((class_1922)worldIn, pos, be -> {
                class_1263 inventory = ItemHelper.getInventory(worldIn, pos, state, be, null);
                if (inventory == null) {
                    return;
                }
                int insert = inventory.insert(asItem);
                if (asItem.method_7947() == insert) {
                    entityIn.method_31472();
                } else if (entityIn instanceof class_1542) {
                    class_1542 itemEntity = (class_1542)entityIn;
                    if (insert != 0) {
                        asItem.method_7934(insert);
                        itemEntity.method_6979(asItem);
                    }
                }
            });
            return;
        }
        BeltBlockEntity controller = BeltHelper.getControllerBE((class_1936)worldIn, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entityIn)) {
            BeltMovementHandler.TransportedEntityInfo info = controller.passengers.get(entityIn);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entityIn.method_24515())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entityIn, new BeltMovementHandler.TransportedEntityInfo(pos, state));
            entityIn.method_24830(true);
        }
    }

    public static boolean canTransportObjects(class_2680 state) {
        if (!state.method_27852((class_2248)AllBlocks.BELT)) {
            return false;
        }
        BeltSlope slope = (BeltSlope)((Object)state.method_11654(SLOPE));
        return slope != BeltSlope.VERTICAL && slope != BeltSlope.SIDEWAYS;
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_2498 soundType;
        boolean isHand;
        if (player.method_5715() || !player.method_7294()) {
            return class_1269.field_52423;
        }
        boolean isWrench = stack.method_31574((class_1792)AllItems.WRENCH);
        boolean isConnector = stack.method_31574((class_1792)AllItems.BELT_CONNECTOR);
        boolean isShaft = stack.method_31574((class_1792)AllItems.SHAFT);
        boolean isDye = stack.method_31573(AllItemTags.DYES);
        boolean hasWater = !stack.method_7960() && GenericItemEmptying.emptyItem(level, stack, true).getFirst().getFluid().method_15780((class_3611)class_3612.field_15910);
        boolean bl = isHand = stack.method_7960() && hand == class_1268.field_5808;
        if (isDye || hasWater) {
            return this.onBlockEntityUseItemOn((class_1922)level, pos, be -> be.applyColor(AllItemTags.getDyeColor(stack)) ? class_1269.field_5812 : class_1269.field_52423);
        }
        if (isConnector) {
            return BeltSlicer.useConnector(state, level, pos, player, hand, hitResult, new BeltSlicer.Feedback());
        }
        if (isWrench) {
            return BeltSlicer.useWrench(state, level, pos, player, hand, hitResult, new BeltSlicer.Feedback());
        }
        BeltBlockEntity belt = BeltHelper.getSegmentBE((class_1936)level, pos);
        if (belt == null) {
            return class_1269.field_52423;
        }
        if (PackageItem.isPackage(stack)) {
            class_1799 toInsert = stack.method_7972();
            class_1263 handler = ItemHelper.getInventory(level, belt.method_11016(), null);
            if (handler == null) {
                return class_1269.field_52423;
            }
            int insert = handler.insert(toInsert);
            if (insert != 0) {
                stack.method_7934(insert);
                return class_1269.field_5812;
            }
        }
        if (isHand) {
            BeltBlockEntity controllerBelt = belt.getControllerBE();
            if (controllerBelt == null) {
                return class_1269.field_52423;
            }
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            MutableBoolean success = new MutableBoolean(false);
            controllerBelt.getInventory().applyToEachWithin((float)belt.index + 0.5f, 0.55f, transportedItemStack -> {
                player.method_31548().method_7398(transportedItemStack.stack);
                success.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
            });
            if (success.isTrue()) {
                level.method_8396(null, pos, class_3417.field_15197, class_3419.field_15248, 0.2f, 1.0f + level.field_9229.method_43057());
            }
        }
        if (isShaft) {
            if (state.method_11654(PART) != BeltPart.MIDDLE) {
                return class_1269.field_52423;
            }
            if (level.method_8608()) {
                return class_1269.field_5812;
            }
            if (!player.method_68878()) {
                stack.method_7934(1);
            }
            KineticBlockEntity.switchToBlockState(level, pos, (class_2680)state.method_11657(PART, (Comparable)((Object)BeltPart.PULLEY)));
            return class_1269.field_5812;
        }
        if (stack.method_31574((class_1792)AllItems.BRASS_CASING)) {
            this.withBlockEntityDo((class_1922)level, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.BRASS));
            this.updateCoverProperty((class_4538)level, pos, level.method_8320(pos));
            soundType = AllBlocks.BRASS_CASING.method_9564().method_26231();
            level.method_8396(null, pos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            return class_1269.field_5812;
        }
        if (stack.method_31574((class_1792)AllItems.ANDESITE_CASING)) {
            this.withBlockEntityDo((class_1922)level, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.ANDESITE));
            this.updateCoverProperty((class_4538)level, pos, level.method_8320(pos));
            soundType = AllBlocks.ANDESITE_CASING.method_9564().method_26231();
            level.method_8396(null, pos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        if (((Boolean)state.method_11654((class_2769)CASING)).booleanValue()) {
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            this.withBlockEntityDo((class_1922)world, pos, be -> be.setCasingType(BeltBlockEntity.CasingType.NONE));
            return class_1269.field_5812;
        }
        if (state.method_11654(PART) == BeltPart.PULLEY) {
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            KineticBlockEntity.switchToBlockState(world, pos, (class_2680)state.method_11657(PART, (Comparable)((Object)BeltPart.MIDDLE)));
            if (player != null && !player.method_68878()) {
                player.method_31548().method_7398(AllItems.SHAFT.method_7854());
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{SLOPE, PART, CASING, WATERLOGGED});
        super.method_9515(builder);
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return BeltShapes.getShape(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        if (state.method_26204() != this) {
            return class_259.method_1073();
        }
        class_265 shape = this.method_9530(state, worldIn, pos, context);
        if (!(context instanceof class_3727)) {
            return shape;
        }
        return this.getBlockEntityOptional(worldIn, pos).map(be -> {
            class_1297 entity = ((class_3727)context).method_32480();
            if (entity == null) {
                return shape;
            }
            BeltBlockEntity controller = be.getControllerBE();
            if (controller == null) {
                return shape;
            }
            if (controller.passengers == null || !controller.passengers.containsKey(entity)) {
                return BeltShapes.getCollisionShape(state);
            }
            return shape;
        }).orElse(shape);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void initBelt(class_1937 world, class_2338 pos) {
        class_3218 serverWorld;
        if (world.method_8608()) {
            return;
        }
        if (world instanceof class_3218 && (serverWorld = (class_3218)world).method_14178().method_12129() instanceof class_2891) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (!state.method_27852((class_2248)AllBlocks.BELT)) {
            return;
        }
        int limit = 1000;
        class_2338 currentPos = pos;
        while (limit-- > 0) {
            class_2680 currentState = world.method_8320(currentPos);
            if (!currentState.method_27852((class_2248)AllBlocks.BELT)) {
                world.method_22352(pos, true);
                return;
            }
            class_2338 nextSegmentPosition = BeltBlock.nextSegmentPosition(currentState, currentPos, false);
            if (nextSegmentPosition == null) break;
            if (!world.method_8477(nextSegmentPosition)) {
                return;
            }
            currentPos = nextSegmentPosition;
        }
        int index = 0;
        List<class_2338> beltChain = BeltBlock.getBeltChain((class_4538)world, currentPos);
        if (beltChain.size() < 2) {
            world.method_22352(currentPos, true);
            return;
        }
        Iterator<class_2338> iterator = beltChain.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return;
            }
            class_2338 beltPos = iterator.next();
            class_2586 blockEntity = world.method_8321(beltPos);
            class_2680 currentState = world.method_8320(beltPos);
            if (!(blockEntity instanceof BeltBlockEntity)) break;
            BeltBlockEntity be = (BeltBlockEntity)blockEntity;
            if (!currentState.method_27852((class_2248)AllBlocks.BELT)) break;
            be.setController(currentPos);
            be.beltLength = beltChain.size();
            be.index = index;
            be.attachKinetics();
            be.method_5431();
            be.sendData();
            if (be.isController() && !BeltBlock.canTransportObjects(currentState)) {
                be.getInventory().ejectAll();
            }
            ++index;
        }
        world.method_22352(currentPos, true);
    }

    public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean isMoving) {
        super.method_66388(state, world, pos, isMoving);
        if (world.method_8608()) {
            return;
        }
        if (isMoving) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            class_2680 currentState;
            class_2338 currentPos = BeltBlock.nextSegmentPosition(state, pos, forward);
            if (currentPos == null || !(currentState = world.method_8320(currentPos)).method_27852((class_2248)AllBlocks.BELT)) continue;
            boolean hasPulley = false;
            class_2586 blockEntity = world.method_8321(currentPos);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                if (belt.isController()) {
                    belt.getInventory().ejectAll();
                }
                hasPulley = belt.hasPulley();
            }
            world.method_8544(currentPos);
            class_2680 shaftState = (class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)this.getRotationAxis(currentState));
            world.method_8652(currentPos, ProperWaterloggedBlock.withWater((class_4538)world, hasPulley ? shaftState : class_2246.field_10124.method_9564(), currentPos), 3);
            world.method_20290(2001, currentPos, class_2248.method_9507((class_2680)currentState));
        }
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 side, class_2338 p_196271_6_, class_2680 p_196271_3_, class_5819 random) {
        this.updateWater(world, tickView, state, pos);
        if (side.method_10166().method_10179()) {
            this.updateTunnelConnections((class_1936)world, pos.method_10084());
        }
        if (side == class_2350.field_11036) {
            this.updateCoverProperty(world, pos, state);
        }
        return state;
    }

    public void updateCoverProperty(class_4538 world, class_2338 pos, class_2680 state) {
        if (world.method_8608()) {
            return;
        }
        if (((Boolean)state.method_11654((class_2769)CASING)).booleanValue() && state.method_11654(SLOPE) == BeltSlope.HORIZONTAL) {
            this.withBlockEntityDo((class_1922)world, pos, bbe -> bbe.setCovered(BeltBlock.isBlockCoveringBelt(world, pos.method_10084())));
        }
    }

    public static boolean isBlockCoveringBelt(class_4538 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        class_265 collisionShape = blockState.method_26220((class_1922)world, pos);
        if (collisionShape.method_1110()) {
            return false;
        }
        class_238 bounds = collisionShape.method_1107();
        if (bounds.method_17939() < 0.5 || bounds.method_17941() < 0.5) {
            return false;
        }
        if (bounds.field_1322 > 0.0) {
            return false;
        }
        if (blockState.method_27852((class_2248)AllBlocks.CRUSHING_WHEEL_CONTROLLER)) {
            return false;
        }
        if (FunnelBlock.isFunnel(blockState) && FunnelBlock.getFunnelFacing(blockState) != class_2350.field_11036) {
            return false;
        }
        return !(blockState.method_26204() instanceof BeltTunnelBlock);
    }

    private void updateTunnelConnections(class_1936 world, class_2338 pos) {
        class_2248 tunnelBlock = world.method_8320(pos).method_26204();
        if (tunnelBlock instanceof BeltTunnelBlock) {
            ((BeltTunnelBlock)tunnelBlock).updateTunnel(world, pos);
        }
    }

    public static List<class_2338> getBeltChain(class_4538 world, class_2338 controllerPos) {
        class_2680 state;
        LinkedList<class_2338> positions = new LinkedList<class_2338>();
        class_2680 blockState = world.method_8320(controllerPos);
        if (!blockState.method_27852((class_2248)AllBlocks.BELT)) {
            return positions;
        }
        int limit = 1000;
        class_2338 current = controllerPos;
        while (limit-- > 0 && current != null && (state = world.method_8320(current)).method_27852((class_2248)AllBlocks.BELT)) {
            positions.add(current);
            current = BeltBlock.nextSegmentPosition(state, current, true);
        }
        return positions;
    }

    public static class_2338 nextSegmentPosition(class_2680 state, class_2338 pos, boolean forward) {
        int offset;
        class_2350 direction = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)state.method_11654(SLOPE));
        BeltPart part = (BeltPart)((Object)state.method_11654(PART));
        int n = offset = forward ? 1 : -1;
        if (part == BeltPart.END && forward || part == BeltPart.START && !forward) {
            return null;
        }
        if (slope == BeltSlope.VERTICAL) {
            return pos.method_10086(direction.method_10171() == class_2350.class_2352.field_11056 ? offset : -offset);
        }
        pos = pos.method_10079(direction, offset);
        if (slope != BeltSlope.HORIZONTAL && slope != BeltSlope.SIDEWAYS) {
            return pos.method_10086(slope == BeltSlope.UPWARD ? offset : -offset);
        }
        return pos;
    }

    @Override
    public Class<BeltBlockEntity> getBlockEntityClass() {
        return BeltBlockEntity.class;
    }

    @Override
    public class_2591<? extends BeltBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.BELT;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        ArrayList<class_1799> required = new ArrayList<class_1799>();
        if (state.method_11654(PART) != BeltPart.MIDDLE) {
            required.add(AllItems.SHAFT.method_7854());
        }
        if (state.method_11654(PART) == BeltPart.START) {
            required.add(AllItems.BELT_CONNECTOR.method_7854());
        }
        if (required.isEmpty()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, required);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        class_2680 rotate = super.method_9598(state, rot);
        if (state.method_11654(SLOPE) != BeltSlope.VERTICAL) {
            return rotate;
        }
        if (((class_2350)state.method_11654((class_2769)HORIZONTAL_FACING)).method_10171() != ((class_2350)rotate.method_11654((class_2769)HORIZONTAL_FACING)).method_10171()) {
            if (state.method_11654(PART) == BeltPart.START) {
                return (class_2680)rotate.method_11657(PART, (Comparable)((Object)BeltPart.END));
            }
            if (state.method_11654(PART) == BeltPart.END) {
                return (class_2680)rotate.method_11657(PART, (Comparable)((Object)BeltPart.START));
            }
        }
        return rotate;
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.method_9569(state, transform.mirror);
        }
        if (transform.rotationAxis == class_2350.class_2351.field_11052) {
            return this.method_9598(state, transform.rotation);
        }
        return this.transformInner(state, transform);
    }

    protected class_2680 transformInner(class_2680 state, StructureTransform transform) {
        boolean diagonal;
        boolean halfTurn = transform.rotation == class_2470.field_11464;
        class_2350 initialDirection = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
        boolean bl = diagonal = state.method_11654(SLOPE) == BeltSlope.DOWNWARD || state.method_11654(SLOPE) == BeltSlope.UPWARD;
        if (!diagonal) {
            for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                class_2350 direction = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
                BeltSlope slope = (BeltSlope)((Object)state.method_11654(SLOPE));
                boolean vertical = slope == BeltSlope.VERTICAL;
                boolean horizontal = slope == BeltSlope.HORIZONTAL;
                boolean sideways = slope == BeltSlope.SIDEWAYS;
                class_2350 newDirection = direction.method_10153();
                BeltSlope newSlope = BeltSlope.VERTICAL;
                if (vertical) {
                    if (direction.method_10166() == transform.rotationAxis) {
                        newDirection = direction.method_10160();
                        newSlope = BeltSlope.SIDEWAYS;
                    } else {
                        newSlope = BeltSlope.HORIZONTAL;
                        newDirection = direction;
                        if (direction.method_10166() == class_2350.class_2351.field_11051) {
                            newDirection = direction.method_10153();
                        }
                    }
                }
                if (sideways) {
                    newDirection = direction;
                    if (direction.method_10166() == transform.rotationAxis) {
                        newSlope = BeltSlope.HORIZONTAL;
                    } else {
                        newDirection = direction.method_10160();
                    }
                }
                if (horizontal) {
                    newDirection = direction;
                    if (direction.method_10166() == transform.rotationAxis) {
                        newSlope = BeltSlope.SIDEWAYS;
                    } else if (direction.method_10166() != class_2350.class_2351.field_11051) {
                        newDirection = direction.method_10153();
                    }
                }
                state = (class_2680)state.method_11657((class_2769)HORIZONTAL_FACING, (Comparable)newDirection);
                state = (class_2680)state.method_11657(SLOPE, (Comparable)((Object)newSlope));
            }
        } else if (initialDirection.method_10166() != transform.rotationAxis) {
            for (int i = 0; i < transform.rotation.ordinal(); ++i) {
                class_2350 direction = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
                class_2350 newDirection = direction.method_10153();
                BeltSlope slope = (BeltSlope)((Object)state.method_11654(SLOPE));
                boolean upward = slope == BeltSlope.UPWARD;
                boolean downward = slope == BeltSlope.DOWNWARD;
                state = direction.method_10171() == class_2350.class_2352.field_11056 ^ downward ^ direction.method_10166() == class_2350.class_2351.field_11051 ? (class_2680)state.method_11657(SLOPE, (Comparable)((Object)(upward ? BeltSlope.DOWNWARD : BeltSlope.UPWARD))) : (class_2680)state.method_11657((class_2769)HORIZONTAL_FACING, (Comparable)newDirection);
            }
        } else if (halfTurn) {
            boolean vertical;
            class_2350 direction = (class_2350)state.method_11654((class_2769)HORIZONTAL_FACING);
            class_2350 newDirection = direction.method_10153();
            BeltSlope slope = (BeltSlope)((Object)state.method_11654(SLOPE));
            boolean bl2 = vertical = slope == BeltSlope.VERTICAL;
            if (diagonal) {
                state = (class_2680)state.method_11657(SLOPE, (Comparable)((Object)(slope == BeltSlope.UPWARD ? BeltSlope.DOWNWARD : (slope == BeltSlope.DOWNWARD ? BeltSlope.UPWARD : slope))));
            } else if (vertical) {
                state = (class_2680)state.method_11657((class_2769)HORIZONTAL_FACING, (Comparable)newDirection);
            }
        }
        return state;
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public class_3610 method_9545(class_2680 pState) {
        return this.fluidState(pState);
    }
}

