/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.item;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5250;

public class CountedItemStackList {
    Map<class_1792, Set<ItemStackEntry>> items = new HashMap<class_1792, Set<ItemStackEntry>>();

    public CountedItemStackList(class_1263 inventory, ServerFilteringBehaviour filteringBehaviour) {
        int size = inventory.method_5439();
        for (int slot = 0; slot < size; ++slot) {
            class_1799 extractItem = inventory.method_5438(slot);
            if (!filteringBehaviour.test(extractItem)) continue;
            this.add(extractItem);
        }
    }

    public Stream<IntAttached<class_5250>> getTopNames(int limit) {
        return this.items.values().stream().flatMap(Collection::stream).sorted(IntAttached.comparator()).limit(limit).map(entry -> IntAttached.with(entry.count(), entry.stack().method_7964().method_27661()));
    }

    public void add(class_1799 stack) {
        this.add(stack, stack.method_7947());
    }

    public void add(class_1799 stack, int amount) {
        if (stack.method_7960()) {
            return;
        }
        Set<ItemStackEntry> stackSet = this.getOrCreateItemSet(stack);
        for (ItemStackEntry entry : stackSet) {
            if (!entry.matches(stack)) continue;
            entry.grow(amount);
            return;
        }
        stackSet.add(new ItemStackEntry(stack, amount));
    }

    private Set<ItemStackEntry> getOrCreateItemSet(class_1799 stack) {
        if (!this.items.containsKey(stack.method_7909())) {
            this.items.put(stack.method_7909(), new HashSet());
        }
        return this.getItemSet(stack);
    }

    private Set<ItemStackEntry> getItemSet(class_1799 stack) {
        return this.items.get(stack.method_7909());
    }

    public static class ItemStackEntry
    extends IntAttached<class_1799> {
        public ItemStackEntry(class_1799 stack) {
            this(stack, stack.method_7947());
        }

        public ItemStackEntry(class_1799 stack, int amount) {
            super(amount, stack);
        }

        public boolean matches(class_1799 other) {
            return class_1799.method_31577((class_1799)other, (class_1799)this.stack());
        }

        public class_1799 stack() {
            return (class_1799)this.getSecond();
        }

        public void grow(int amount) {
            this.setFirst((Integer)this.getFirst() + amount);
        }

        public int count() {
            return (Integer)this.getFirst();
        }
    }
}

