/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public abstract class SymmetryMirror {
    public static final String EMPTY = "empty";
    public static final String PLANE = "plane";
    public static final String CROSS_PLANE = "cross_plane";
    public static final String TRIPLE_PLANE = "triple_plane";
    public static final Codec<SymmetryMirror> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("orientation_index").forGetter(SymmetryMirror::getOrientationIndex), (App)class_243.field_38277.fieldOf("position").forGetter(SymmetryMirror::getPosition), (App)Codec.STRING.fieldOf("type").forGetter(SymmetryMirror::typeName), (App)Codec.BOOL.fieldOf("enable").forGetter(m -> m.enable)).apply((Applicative)i, SymmetryMirror::create));
    public static final class_9139<class_2540, SymmetryMirror> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_49675, SymmetryMirror::getOrientationIndex, (class_9139)class_243.field_52694, SymmetryMirror::getPosition, (class_9139)class_9135.field_48554, SymmetryMirror::typeName, (class_9139)class_9135.field_48547, m -> m.enable, SymmetryMirror::create);
    protected class_243 position;
    public class_3542 orientation;
    protected int orientationIndex;
    public boolean enable;

    public SymmetryMirror(class_243 pos) {
        this.position = pos;
        this.enable = true;
        this.orientationIndex = 0;
    }

    private static SymmetryMirror create(Integer orientationIndex, class_243 position, String type, Boolean enable) {
        SymmetryMirror element = switch (type) {
            case PLANE -> new PlaneMirror(position);
            case CROSS_PLANE -> new CrossPlaneMirror(position);
            case TRIPLE_PLANE -> new TriplePlaneMirror(position);
            default -> new EmptyMirror(position);
        };
        element.setOrientation(orientationIndex);
        element.enable = enable;
        return element;
    }

    public class_3542 getOrientation() {
        return this.orientation;
    }

    public class_243 getPosition() {
        return this.position;
    }

    public int getOrientationIndex() {
        return this.orientationIndex;
    }

    public void rotate(boolean forward) {
        this.orientationIndex += forward ? 1 : -1;
        this.setOrientation();
    }

    public void process(Map<class_2338, Pair<class_2350, class_2680>> blocks) {
        HashMap<class_2338, Pair<class_2350, class_2680>> result = new HashMap<class_2338, Pair<class_2350, class_2680>>();
        for (class_2338 pos : blocks.keySet()) {
            result.putAll(this.process(pos, blocks.get(pos)));
        }
        blocks.putAll(result);
    }

    public void process(Set<class_2338> positions) {
        HashSet<class_2338> result = new HashSet<class_2338>();
        for (class_2338 pos : positions) {
            result.addAll(this.process(pos));
        }
        positions.addAll(result);
    }

    public abstract Map<class_2338, Pair<class_2350, class_2680>> process(class_2338 var1, Pair<class_2350, class_2680> var2);

    public abstract Set<class_2338> process(class_2338 var1);

    protected abstract void setOrientation();

    public abstract void setOrientation(int var1);

    public abstract String typeName();

    protected class_243 getDiff(class_2338 position) {
        return this.position.method_1021(-1.0).method_1031((double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260());
    }

    protected class_2338 getIDiff(class_2338 position) {
        class_243 diff = this.getDiff(position);
        return new class_2338((int)diff.field_1352, (int)diff.field_1351, (int)diff.field_1350);
    }

    protected class_2680 flipX(class_2680 in) {
        return in.method_26185(class_2415.field_11301);
    }

    protected class_2680 flipZ(class_2680 in) {
        return in.method_26185(class_2415.field_11300);
    }

    protected class_2680 flipD1(class_2680 in) {
        return in.method_26186(class_2470.field_11465).method_26185(class_2415.field_11301);
    }

    protected class_2680 flipD2(class_2680 in) {
        return in.method_26186(class_2470.field_11465).method_26185(class_2415.field_11300);
    }

    protected class_2338 flipX(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263() - 2 * diff.method_10263(), position.method_10264(), position.method_10260());
    }

    protected class_2338 flipY(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263(), position.method_10264() - 2 * diff.method_10264(), position.method_10260());
    }

    protected class_2338 flipZ(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263(), position.method_10264(), position.method_10260() - 2 * diff.method_10260());
    }

    protected class_2338 flipD2(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263() - diff.method_10263() + diff.method_10260(), position.method_10264(), position.method_10260() - diff.method_10260() + diff.method_10263());
    }

    protected class_2338 flipD1(class_2338 position) {
        class_2338 diff = this.getIDiff(position);
        return new class_2338(position.method_10263() - diff.method_10263() - diff.method_10260(), position.method_10264(), position.method_10260() - diff.method_10260() - diff.method_10263());
    }

    protected class_2350 flipZ(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11039 -> side;
            case class_2350.field_11043 -> class_2350.field_11035;
            case class_2350.field_11035 -> class_2350.field_11043;
        };
    }

    protected class_2350 flipX(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035 -> side;
            case class_2350.field_11034 -> class_2350.field_11039;
            case class_2350.field_11039 -> class_2350.field_11034;
        };
    }

    protected class_2350 flipXZ(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> side;
            case class_2350.field_11043 -> class_2350.field_11035;
            case class_2350.field_11035 -> class_2350.field_11043;
            case class_2350.field_11034 -> class_2350.field_11039;
            case class_2350.field_11039 -> class_2350.field_11034;
        };
    }

    protected class_2350 flipD1(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> side;
            case class_2350.field_11043 -> class_2350.field_11034;
            case class_2350.field_11034 -> class_2350.field_11043;
            case class_2350.field_11035 -> class_2350.field_11039;
            case class_2350.field_11039 -> class_2350.field_11035;
        };
    }

    protected class_2350 flipD2(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> side;
            case class_2350.field_11043 -> class_2350.field_11039;
            case class_2350.field_11039 -> class_2350.field_11043;
            case class_2350.field_11035 -> class_2350.field_11034;
            case class_2350.field_11034 -> class_2350.field_11035;
        };
    }

    protected class_2350 flipD1D2(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> side;
            case class_2350.field_11043 -> class_2350.field_11035;
            case class_2350.field_11035 -> class_2350.field_11043;
            case class_2350.field_11034 -> class_2350.field_11039;
            case class_2350.field_11039 -> class_2350.field_11034;
        };
    }

    protected class_2350 flipD1X(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> side;
            case class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035 -> side.method_10170();
        };
    }

    protected class_2350 flipD1Z(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> side;
            case class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035 -> side.method_10160();
        };
    }

    protected class_2350 flipD1XZ(class_2350 side) {
        return switch (side) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033 -> side;
            case class_2350.field_11043 -> class_2350.field_11039;
            case class_2350.field_11034 -> class_2350.field_11035;
            case class_2350.field_11035 -> class_2350.field_11034;
            case class_2350.field_11039 -> class_2350.field_11043;
        };
    }

    public void setPosition(class_243 pos3d) {
        this.position = pos3d;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymmetryMirror)) {
            return false;
        }
        SymmetryMirror that = (SymmetryMirror)o;
        return this.getOrientationIndex() == that.getOrientationIndex() && this.enable == that.enable && Objects.equals(this.getPosition(), that.getPosition()) && Objects.equals(this.getOrientation(), that.getOrientation());
    }

    public int hashCode() {
        int result = Objects.hashCode(this.getPosition());
        result = 31 * result + Objects.hashCode(this.getOrientation());
        result = 31 * result + this.getOrientationIndex();
        result = 31 * result + Boolean.hashCode(this.enable);
        return result;
    }
}

