/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.Create;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.infrastructure.component.BottleType;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1844;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;

public class FluidStack
implements class_9322 {
    public static final FluidStack EMPTY = new FluidStack(null);
    public static final Codec<class_6880<class_3611>> FLUID_ENTRY_CODEC = class_7923.field_41173.method_40294().validate(entry -> entry.method_55838((class_6880)class_3612.field_15906.method_40178()) ? DataResult.error(() -> "Fluid must not be minecraft:empty") : DataResult.success((Object)entry));
    public static final class_9139<class_9129, class_6880<class_3611>> FLUID_ENTRY_PACKET_CODEC = class_9135.method_56383((class_5321)class_7924.field_41270);
    public static final MapCodec<FluidStack> MAP_CODEC = MapCodec.recursive((String)"FluidStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)FLUID_ENTRY_CODEC.fieldOf("id").forGetter(FluidStack::getRegistryEntry), (App)class_5699.field_33442.fieldOf("amount").orElse((Object)1).forGetter(FluidStack::getAmount), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(stack -> stack.components.method_57940())).apply((Applicative)instance, FluidStack::new)));
    public static final Codec<FluidStack> CODEC = Codec.lazyInitialized(() -> MAP_CODEC.codec());
    public static final Codec<FluidStack> OPTIONAL_CODEC = class_5699.method_57155(CODEC).xmap(optional -> optional.orElse(EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final class_9139<class_9129, FluidStack> OPTIONAL_PACKET_CODEC = new class_9139<class_9129, FluidStack>(){

        public FluidStack decode(class_9129 registryByteBuf) {
            int i = registryByteBuf.method_10816();
            if (i <= 0) {
                return EMPTY;
            }
            class_6880 registryEntry = (class_6880)FLUID_ENTRY_PACKET_CODEC.decode((Object)registryByteBuf);
            class_9326 componentChanges = (class_9326)class_9326.field_49590.decode((Object)registryByteBuf);
            return new FluidStack((class_6880<class_3611>)registryEntry, i, componentChanges);
        }

        public void encode(class_9129 registryByteBuf, FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                registryByteBuf.method_10804(0);
            } else {
                registryByteBuf.method_10804(fluidStack.getAmount());
                FLUID_ENTRY_PACKET_CODEC.encode((Object)registryByteBuf, fluidStack.getRegistryEntry());
                class_9326.field_49590.encode((Object)registryByteBuf, (Object)fluidStack.components.method_57940());
            }
        }
    };
    public static final class_9139<class_9129, FluidStack> PACKET_CODEC = new class_9139<class_9129, FluidStack>(){

        public FluidStack decode(class_9129 registryByteBuf) {
            FluidStack fluidStack = (FluidStack)OPTIONAL_PACKET_CODEC.decode((Object)registryByteBuf);
            if (fluidStack.isEmpty()) {
                throw new DecoderException("Empty FluidStack not allowed");
            }
            return fluidStack;
        }

        public void encode(class_9129 registryByteBuf, FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                throw new EncoderException("Empty FluidStack not allowed");
            }
            OPTIONAL_PACKET_CODEC.encode((Object)registryByteBuf, (Object)fluidStack);
        }
    };
    private final class_9335 components;
    private final class_3611 fluid;
    private int amount;

    public FluidStack(class_3611 fluid, int amount) {
        this(fluid, amount, new class_9335(class_9323.field_49584));
    }

    public FluidStack(class_3611 fluid, int amount, class_9335 components) {
        this.fluid = fluid;
        this.amount = amount;
        this.components = components;
    }

    private FluidStack(@Nullable Void v) {
        this.fluid = null;
        this.components = new class_9335(class_9323.field_49584);
    }

    public FluidStack(class_6880<class_3611> fluid, int amount, class_9326 changes) {
        this((class_3611)fluid.comp_349(), amount, class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)changes));
    }

    public FluidStack(class_3611 fluid, int amount, class_9326 changes) {
        this(fluid, amount, class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)changes));
    }

    public FluidStack(class_3611 fluid, long amount, class_9326 changes) {
        this(fluid, (int)amount, class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)changes));
    }

    public static boolean areFluidsAndComponentsEqual(FluidStack stack, FluidStack otherStack) {
        if (!stack.isOf(otherStack.getFluid())) {
            return false;
        }
        return stack.isEmpty() && otherStack.isEmpty() || Objects.equals(stack.components, otherStack.components);
    }

    public static boolean areFluidsAndComponentsEqualIgnoreCapacity(FluidStack stack, FluidStack otherStack) {
        if (stack.isOf(otherStack.getFluid())) {
            class_9335 otherStackComponents;
            class_9335 stackComponents = stack.directComponents();
            if (stackComponents == (otherStackComponents = otherStack.directComponents())) {
                return true;
            }
            Reference2ObjectMap stackComponentMap = stackComponents.field_49655;
            Reference2ObjectMap otherStackComponentMap = otherStackComponents.field_49655;
            if (stackComponentMap == otherStackComponentMap) {
                return true;
            }
            int stackComponentCount = stackComponentMap.size();
            if (stackComponentMap.containsKey(AllDataComponents.FLUID_MAX_CAPACITY)) {
                --stackComponentCount;
            }
            int otherStackComponentCount = otherStackComponentMap.size();
            boolean hasMaxCapacityComponent = false;
            if (otherStackComponentMap.containsKey(AllDataComponents.FLUID_MAX_CAPACITY)) {
                --otherStackComponentCount;
                hasMaxCapacityComponent = true;
            }
            if (stackComponentCount != otherStackComponentCount) {
                return false;
            }
            if (hasMaxCapacityComponent) {
                ObjectSet stackComponentSet = stackComponentMap.reference2ObjectEntrySet();
                for (Reference2ObjectMap.Entry componentEntry : otherStackComponentMap.reference2ObjectEntrySet()) {
                    if (stackComponentSet.contains((Object)componentEntry) || componentEntry.getKey() == AllDataComponents.FLUID_MAX_CAPACITY) continue;
                    return false;
                }
                return true;
            }
            return stackComponentMap.reference2ObjectEntrySet().containsAll((Collection)otherStackComponentMap.reference2ObjectEntrySet());
        }
        return false;
    }

    public static Optional<FluidStack> fromNbt(class_7225.class_7874 registries, class_2520 nbt) {
        return CODEC.parse((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial(error -> Create.LOGGER.error("Tried to load invalid fluid: '{}'", error));
    }

    public static FluidStack fromNbt(class_7225.class_7874 registries, Optional<class_2487> nbt) {
        return nbt.flatMap(n -> FluidStack.fromNbt(registries, (class_2520)n)).orElse(EMPTY);
    }

    public static int hashCode(@Nullable FluidStack stack) {
        if (stack != null) {
            int i = 31 + stack.getFluid().hashCode();
            return 31 * i + stack.method_57353().hashCode();
        }
        return 0;
    }

    public void applyComponentsFrom(class_9323 map) {
        this.components.method_57933(map);
    }

    public void capAmount(int maxCount) {
        if (!this.isEmpty() && this.getAmount() > maxCount) {
            this.setAmount(maxCount);
        }
    }

    public FluidStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new FluidStack(this.fluid, this.amount, this.components.method_57941());
    }

    public FluidStack copyWithAmount(int amount) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new FluidStack(this.fluid, amount, this.components.method_57941());
    }

    public void decrement(int amount) {
        this.increment(-amount);
    }

    public class_9335 directComponents() {
        return this.components;
    }

    public FluidStack directCopy(int amount) {
        return new FluidStack(this.fluid, amount, this.components.method_57941());
    }

    public int getAmount() {
        return this.isEmpty() ? 0 : this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public class_9326 getComponentChanges() {
        return !this.isEmpty() ? this.components.method_57940() : class_9326.field_49588;
    }

    public class_9323 method_57353() {
        return !this.isEmpty() ? this.components : class_9323.field_49584;
    }

    public class_3611 getFluid() {
        return this.isEmpty() ? class_3612.field_15906 : this.fluid;
    }

    public int getMaxAmount() {
        return (Integer)this.method_58695(AllDataComponents.FLUID_MAX_CAPACITY, Integer.MAX_VALUE);
    }

    public class_2561 getName() {
        if (this.fluid == AllFluids.POTION) {
            class_1844 contents = (class_1844)this.method_58695(class_9334.field_49651, class_1844.field_49274);
            class_1792 itemFromBottleType = PotionFluidHandler.itemFromBottleType((BottleType)((Object)this.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR)));
            return contents.method_64195(itemFromBottleType.method_8389().method_7876() + ".effect.");
        }
        class_2248 block = this.fluid.method_15785().method_15759().method_26204();
        if (this.fluid != class_3612.field_15906 && block == class_2246.field_10124) {
            return class_2561.method_43471((String)class_156.method_646((String)"block", (class_2960)class_7923.field_41173.method_10221((Object)this.fluid)));
        }
        return block.method_9518();
    }

    public class_6880<class_3611> getRegistryEntry() {
        return this.getFluid().method_40178();
    }

    public void increment(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.fluid == class_3612.field_15906 || this.amount <= 0;
    }

    public boolean isIn(class_6862<class_3611> tag) {
        return this.getFluid().method_40178().method_40220(tag);
    }

    public boolean isOf(class_3611 fluid) {
        return this.getFluid() == fluid;
    }

    @Nullable
    public <T> T remove(class_9331<? extends T> type) {
        return (T)this.components.method_57939(type);
    }

    @Nullable
    public <T> T set(class_9331<T> type, @Nullable T value) {
        return (T)this.components.method_57938(type, value);
    }

    public FluidStack split(int amount) {
        int i = Math.min(amount, this.getAmount());
        FluidStack stack = this.copyWithAmount(i);
        this.decrement(i);
        return stack;
    }

    public class_2520 toNbt(class_7225.class_7874 registries) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty FluidStack");
        }
        return (class_2520)CODEC.encodeStart((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)this).getOrThrow();
    }

    public String toString() {
        return this.getAmount() + " " + class_7923.field_41173.method_47983((Object)this.getFluid()).method_55840();
    }
}

