/*
 * Decompiled with CFR 0.152.
 */
package space.essem.image2map.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;
import space.essem.image2map.Image2Map;

public class Image2MapConfig {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().setPrettyPrinting().create();
    public boolean allowLocalFiles = false;
    public int minPermLevel = 2;

    public static Image2MapConfig loadOrCreateConfig() {
        try {
            Image2MapConfig config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "image2map.json");
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
                config = (Image2MapConfig)GSON.fromJson(json, Image2MapConfig.class);
            } else {
                config = new Image2MapConfig();
            }
            Image2MapConfig.saveConfig(config);
            return config;
        }
        catch (IOException exception) {
            Image2Map.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
            return new Image2MapConfig();
        }
    }

    public static void saveConfig(Image2MapConfig config) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "image2map.json");
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)config));
            writer.close();
        }
        catch (Exception e) {
            Image2Map.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }
}

