/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.fabric.client.cloth;

import com.google.common.collect.Lists;
import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.AdjacentStopMode;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.config.enums.BreakOrder;
import fr.rakambda.fallingtree.common.config.enums.DamageRounding;
import fr.rakambda.fallingtree.common.config.enums.DetectionMode;
import fr.rakambda.fallingtree.common.config.enums.DurabilityMode;
import fr.rakambda.fallingtree.common.config.enums.MaxSizeAction;
import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.config.enums.SneakMode;
import fr.rakambda.fallingtree.common.config.real.Configuration;
import fr.rakambda.fallingtree.common.config.real.EnchantmentConfiguration;
import fr.rakambda.fallingtree.common.config.real.PlayerConfiguration;
import fr.rakambda.fallingtree.common.config.real.ToolConfiguration;
import fr.rakambda.fallingtree.common.config.real.TreeConfiguration;
import fr.rakambda.fallingtree.common.config.real.cloth.ClothHookBase;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IWrapper;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.FloatListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClothConfigHook
extends ClothHookBase {
    public ClothConfigHook(@NonNull FallingTreeCommon<?> mod) {
        super(mod);
    }

    public @NonNull Function<class_437, class_437> load() {
        return screen -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle((class_2561)class_2561.method_43470((String)"FallingTree"));
            Configuration configuration = this.getMod().getOwnConfiguration();
            builder.setSavingRunnable(() -> {
                configuration.onUpdate();
                this.getMod().onConfigUpdate();
            });
            this.fillConfigScreen(builder, configuration);
            return builder.build();
        };
    }

    @Environment(value=EnvType.CLIENT)
    public void fillConfigScreen(@NonNull ConfigBuilder builder, @NonNull Configuration config) {
        EnumListEntry reverseSneakingEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName(null, "sneakMode")), SneakMode.class, (Enum)config.getSneakMode()).setDefaultValue((Enum)SneakMode.SNEAK_DISABLE).setTooltip(this.getTooltips(null, "sneakMode")).setSaveConsumer(config::setSneakMode).build();
        BooleanListEntry breakInCreativeEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName(null, "breakInCreative")), config.isBreakInCreative()).setDefaultValue(false).setTooltip(this.getTooltips(null, "breakInCreative")).setSaveConsumer(config::setBreakInCreative).build();
        BooleanListEntry lootInCreativeEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName(null, "lootInCreative")), config.isLootInCreative()).setDefaultValue(true).setTooltip(this.getTooltips(null, "lootInCreative")).setSaveConsumer(config::setLootInCreative).build();
        EnumListEntry notificationModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName(null, "notificationMode")), NotificationMode.class, (Enum)config.getNotificationMode()).setDefaultValue((Enum)NotificationMode.ACTION_BAR).setTooltip(this.getTooltips(null, "notificationMode")).setSaveConsumer(config::setNotificationMode).build();
        ConfigCategory general = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.default"));
        general.addEntry((AbstractConfigListEntry)reverseSneakingEntry);
        general.addEntry((AbstractConfigListEntry)breakInCreativeEntry);
        general.addEntry((AbstractConfigListEntry)lootInCreativeEntry);
        general.addEntry((AbstractConfigListEntry)notificationModeEntry);
        this.fillTreesConfigScreen(builder, config.getTrees());
        this.fillToolsConfigScreen(builder, config.getTools());
        this.fillPlayerConfigScreen(builder, config.getPlayer());
        this.fillEnchantmentConfigScreen(builder, config.getEnchantment());
    }

    @Environment(value=EnvType.CLIENT)
    private void fillTreesConfigScreen(@NonNull ConfigBuilder builder, @NonNull TreeConfiguration config) {
        EnumListEntry breakModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "breakMode")), BreakMode.class, (Enum)config.getBreakMode()).setDefaultValue((Enum)BreakMode.INSTANTANEOUS).setTooltip(this.getTooltips("trees", "breakMode")).setSaveConsumer(config::setBreakMode).build();
        EnumListEntry detectionModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "detectionMode")), DetectionMode.class, (Enum)config.getDetectionMode()).setDefaultValue((Enum)DetectionMode.WHOLE_TREE).setTooltip(this.getTooltips("trees", "detectionMode")).setSaveConsumer(config::setDetectionMode).build();
        StringListListEntry allowedLogsEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedLogs")), config.getAllowedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedLogs")).setSaveConsumer(config::setAllowedLogs).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry deniedLogsEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "deniedLogs")), config.getDeniedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "deniedLogs")).setSaveConsumer(config::setDeniedLogs).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry allowedLeavesEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedLeaves")), config.getAllowedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedLeaves")).setSaveConsumer(config::setAllowedLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry allowedNonDecayLeavesEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedNonDecayLeaves")), config.getAllowedNonDecayLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedNonDecayLeaves")).setSaveConsumer(config::setAllowedNonDecayLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry deniedLeavesEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "deniedLeaves")), config.getDeniedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "deniedLeaves")).setSaveConsumer(config::setDeniedLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        IntegerListEntry maxScanSizeEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "maxScanSize")), config.getMaxScanSize()).setDefaultValue(500).setMin(1).setTooltip(this.getTooltips("trees", "maxScanSize")).setSaveConsumer(config::setMaxScanSize).build();
        IntegerListEntry minSizeEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "minSize")), config.getMinSize()).setDefaultValue(0).setMin(0).setTooltip(this.getTooltips("trees", "minSize")).setSaveConsumer(config::setMinSize).build();
        IntegerListEntry maxSizeEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "maxSize")), config.getMaxSize()).setDefaultValue(100).setMin(1).setTooltip(this.getTooltips("trees", "maxSize")).setSaveConsumer(config::setMaxSize).build();
        EnumListEntry maxSizeActionEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "maxSizeAction")), MaxSizeAction.class, (Enum)config.getMaxSizeAction()).setDefaultValue((Enum)MaxSizeAction.ABORT).setTooltip(this.getTooltips("trees", "maxSizeAction")).setSaveConsumer(config::setMaxSizeAction).build();
        IntegerListEntry maxLeafDistanceFromLogEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "maxLeafDistanceFromLog")), config.getMaxLeafDistanceFromLog()).setDefaultValue(15).setTooltip(this.getTooltips("trees", "maxLeafDistanceFromLog")).setSaveConsumer(config::setMaxLeafDistanceFromLog).build();
        EnumListEntry breakOrderEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "breakOrder")), BreakOrder.class, (Enum)config.getBreakOrder()).setDefaultValue((Enum)BreakOrder.FURTHEST_FIRST).setTooltip(this.getTooltips("trees", "breakOrder")).setSaveConsumer(config::setBreakOrder).build();
        BooleanListEntry treeBreakingEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "treeBreaking")), config.isTreeBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "treeBreaking")).setSaveConsumer(config::setTreeBreaking).build();
        BooleanListEntry leavesBreakingEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "leavesBreaking")), config.isLeavesBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "leavesBreaking")).setSaveConsumer(config::setLeavesBreaking).build();
        IntegerListEntry leavesBreakingForceRadiusEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "leavesBreakingForceRadius")), config.getLeavesBreakingForceRadius()).setDefaultValue(0).setMin(0).setMax(10).setTooltip(this.getTooltips("trees", "leavesBreakingForceRadius")).setSaveConsumer(config::setLeavesBreakingForceRadius).build();
        IntegerListEntry minimumLeavesAroundRequiredEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "minimumLeavesAroundRequired")), config.getMinimumLeavesAroundRequired()).setDefaultValue(1).setMin(0).setMax(5).setTooltip(this.getTooltips("trees", "minimumLeavesAroundRequired")).setSaveConsumer(config::setMinimumLeavesAroundRequired).build();
        BooleanListEntry includePersistentLeavesInRequiredCountEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "includePersistentLeavesInRequiredCount")), config.isIncludePersistentLeavesInRequiredCount()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "includePersistentLeavesInRequiredCount")).setSaveConsumer(config::setIncludePersistentLeavesInRequiredCount).build();
        BooleanListEntry allowMixedLogsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "allowMixedLogs")), config.isAllowMixedLogs()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "allowMixedLogs")).setSaveConsumer(config::setAllowMixedLogs).build();
        BooleanListEntry breakNetherTreeWartsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "breakNetherTreeWarts")), config.isBreakNetherTreeWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "breakNetherTreeWarts")).setSaveConsumer(config::setBreakNetherTreeWarts).build();
        BooleanListEntry breakMangroveRootsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "breakMangroveRoots")), config.isBreakMangroveRoots()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "breakMangroveRoots")).setSaveConsumer(config::setBreakMangroveRoots).build();
        IntegerListEntry searchAreaRadiusEntry = builder.entryBuilder().startIntField(this.translatable(this.getFieldName("trees", "searchAreaRadius")), config.getSearchAreaRadius()).setDefaultValue(-1).setTooltip(this.getTooltips("trees", "searchAreaRadius")).setSaveConsumer(config::setSearchAreaRadius).build();
        StringListListEntry allowedAdjacentBlocks = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("trees", "allowedAdjacentBlocks")), config.getAllowedAdjacentBlocks()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedAdjacentBlocks")).setSaveConsumer(config::setAllowedAdjacentBlocks).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        EnumListEntry adjacentStopModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("trees", "adjacentStopMode")), AdjacentStopMode.class, (Enum)config.getAdjacentStopMode()).setDefaultValue((Enum)AdjacentStopMode.STOP_ALL).setTooltip(this.getTooltips("trees", "adjacentStopMode")).setSaveConsumer(config::setAdjacentStopMode).build();
        BooleanListEntry spawnItemsAtBreakPointEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("trees", "spawnItemsAtBreakPoint")), config.isSpawnItemsAtBreakPoint()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "spawnItemsAtBreakPoint")).setSaveConsumer(config::setSpawnItemsAtBreakPoint).build();
        FloatListEntry trunkLootPercentageEntry = builder.entryBuilder().startFloatField(this.translatable(this.getFieldName("trees", "trunkLootPercentage")), config.getTrunkLootPercentage()).setDefaultValue(1.0f).setMin(0.0f).setMax(1.0f).setTooltip(this.getTooltips("trees", "trunkLootPercentage")).setSaveConsumer(config::setTrunkLootPercentage).build();
        ConfigCategory trees = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.trees"));
        trees.addEntry((AbstractConfigListEntry)breakModeEntry);
        trees.addEntry((AbstractConfigListEntry)detectionModeEntry);
        trees.addEntry((AbstractConfigListEntry)allowedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)deniedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)allowedLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)allowedNonDecayLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)deniedLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)maxScanSizeEntry);
        trees.addEntry((AbstractConfigListEntry)minSizeEntry);
        trees.addEntry((AbstractConfigListEntry)maxSizeEntry);
        trees.addEntry((AbstractConfigListEntry)maxSizeActionEntry);
        trees.addEntry((AbstractConfigListEntry)maxLeafDistanceFromLogEntry);
        trees.addEntry((AbstractConfigListEntry)breakOrderEntry);
        trees.addEntry((AbstractConfigListEntry)treeBreakingEntry);
        trees.addEntry((AbstractConfigListEntry)leavesBreakingEntry);
        trees.addEntry((AbstractConfigListEntry)leavesBreakingForceRadiusEntry);
        trees.addEntry((AbstractConfigListEntry)minimumLeavesAroundRequiredEntry);
        trees.addEntry((AbstractConfigListEntry)includePersistentLeavesInRequiredCountEntry);
        trees.addEntry((AbstractConfigListEntry)allowMixedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)breakNetherTreeWartsEntry);
        trees.addEntry((AbstractConfigListEntry)breakMangroveRootsEntry);
        trees.addEntry((AbstractConfigListEntry)searchAreaRadiusEntry);
        trees.addEntry((AbstractConfigListEntry)allowedAdjacentBlocks);
        trees.addEntry((AbstractConfigListEntry)adjacentStopModeEntry);
        trees.addEntry((AbstractConfigListEntry)spawnItemsAtBreakPointEntry);
        trees.addEntry((AbstractConfigListEntry)trunkLootPercentageEntry);
    }

    @Environment(value=EnvType.CLIENT)
    private void fillToolsConfigScreen(@NonNull ConfigBuilder builder, @NonNull ToolConfiguration config) {
        BooleanListEntry ignoreToolsEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("tools", "ignoreTools")), config.isIgnoreTools()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "ignoreTools")).setSaveConsumer(config::setIgnoreTools).build();
        StringListListEntry allowedEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("tools", "allowed")), config.getAllowed()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "allowed")).setSaveConsumer(config::setAllowed).setCellErrorSupplier(this.map(this.getMinecraftItemIdCellError())).build();
        StringListListEntry deniedEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("tools", "denied")), config.getDenied()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "denied")).setSaveConsumer(config::setDenied).setCellErrorSupplier(this.map(this.getMinecraftItemIdCellError())).build();
        DoubleListEntry damageMultiplicandEntry = builder.entryBuilder().startDoubleField(this.translatable(this.getFieldName("tools", "damageMultiplicand")), config.getDamageMultiplicand()).setDefaultValue(1.0).setMin(0.0).setMax(100.0).setTooltip(this.getTooltips("tools", "damageMultiplicand")).setSaveConsumer(config::setDamageMultiplicand).build();
        EnumListEntry damageRoundingEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("tools", "damageRounding")), DamageRounding.class, (Enum)config.getDamageRounding()).setDefaultValue((Enum)DamageRounding.ROUND_DOWN).setTooltip(this.getTooltips("tools", "damageRounding")).setSaveConsumer(config::setDamageRounding).build();
        DoubleListEntry speedMultiplicandEntry = builder.entryBuilder().startDoubleField(this.translatable(this.getFieldName("tools", "speedMultiplicand")), config.getSpeedMultiplicand()).setDefaultValue(0.0).setMin(0.0).setMax(50.0).setTooltip(this.getTooltips("tools", "speedMultiplicand")).setSaveConsumer(config::setSpeedMultiplicand).build();
        EnumListEntry durabilityModeEntry = builder.entryBuilder().startEnumSelector(this.translatable(this.getFieldName("tools", "durabilityMode")), DurabilityMode.class, (Enum)config.getDurabilityMode()).setDefaultValue((Enum)DurabilityMode.NORMAL).setTooltip(this.getTooltips("tools", "durabilityMode")).setSaveConsumer(config::setDurabilityMode).build();
        BooleanListEntry forceToolUsageEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("tools", "forceToolUsage")), config.isForceToolUsage()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "forceToolUsage")).setSaveConsumer(config::setForceToolUsage).build();
        ConfigCategory tools = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.tools"));
        tools.addEntry((AbstractConfigListEntry)ignoreToolsEntry);
        tools.addEntry((AbstractConfigListEntry)allowedEntry);
        tools.addEntry((AbstractConfigListEntry)deniedEntry);
        tools.addEntry((AbstractConfigListEntry)damageMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)damageRoundingEntry);
        tools.addEntry((AbstractConfigListEntry)speedMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)durabilityModeEntry);
        tools.addEntry((AbstractConfigListEntry)forceToolUsageEntry);
    }

    @Environment(value=EnvType.CLIENT)
    private void fillPlayerConfigScreen(@NonNull ConfigBuilder builder, @NonNull PlayerConfiguration config) {
        StringListListEntry allowedTagsEntry = builder.entryBuilder().startStrList(this.translatable(this.getFieldName("player", "allowedTags")), config.getAllowedTags()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("player", "allowedTags")).setSaveConsumer(config::setAllowedTags).build();
        ConfigCategory tools = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.player"));
        tools.addEntry((AbstractConfigListEntry)allowedTagsEntry);
    }

    @Environment(value=EnvType.CLIENT)
    private void fillEnchantmentConfigScreen(@NonNull ConfigBuilder builder, @NonNull EnchantmentConfiguration config) {
        BooleanListEntry requireEnchantmentEntry = builder.entryBuilder().startBooleanToggle(this.translatable(this.getFieldName("enchantment", "requireEnchantment")), config.isRequireEnchantment()).setDefaultValue(false).setTooltip(this.getTooltips("enchantment", "requireEnchantment")).setSaveConsumer(config::setRequireEnchantment).build();
        ConfigCategory enchantment = builder.getOrCreateCategory(this.translatable("text.autoconfig.fallingtree.category.enchantment"));
        enchantment.addEntry((AbstractConfigListEntry)requireEnchantmentEntry);
    }

    private @NonNull class_2561 translatable(@NonNull String key) {
        return (class_2561)this.getMod().translate(key, new Object[0]).getRaw();
    }

    private @NonNull Function<String, Optional<class_2561>> map(@NonNull Function<String, Optional<IComponent>> fct) {
        return str -> ((Optional)fct.apply((String)str)).map(IWrapper::getRaw).map(class_2561.class::cast);
    }

    protected @NonNull class_2561[] getTooltips(@Nullable String category, @NonNull String fieldName) {
        return (class_2561[])this.getTooltipsInternal(category, fieldName, 1).map(IWrapper::getRaw).map(class_2561.class::cast).toArray(class_2561[]::new);
    }
}

