/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.compat;

import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.NonNull;

public class TetraCompat {
    private static Map<Class<?>, Optional<Method>> honingProgressMethod = new ConcurrentHashMap();

    public static void tickHoningProgression(@NonNull IItemStack itemStack, @NonNull IPlayer player) {
        try {
            ItemStack rawItemStack = (ItemStack)itemStack.getRaw();
            Item rawItem = (Item)itemStack.getItem().getRaw();
            Player rawPlayer = (Player)player.getRaw();
            Class<?> itemClass = rawItem.getClass();
            Optional method = honingProgressMethod.computeIfAbsent(itemClass, TetraCompat::getHoningMethod);
            if (method.isPresent()) {
                ((Method)method.get()).invoke((Object)rawItem, rawPlayer, rawItemStack, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Optional<Method> getHoningMethod(Class<?> klass) {
        try {
            return Optional.of(klass.getMethod("tickHoningProgression", LivingEntity.class, ItemStack.class, Integer.TYPE));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

