/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.config;

import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.SettingNamingConvention;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.config.Config;
import me.drex.villagerconfig.common.platform.PlatformHooks;

public class ConfigManager {
    public static final Path CONFIG_PATH = PlatformHooks.PLATFORM_HELPER.getModConfigDir().resolve("villagerconfig.json5");
    private static final AnnotatedSettings ANNOTATED_SETTINGS = AnnotatedSettings.builder().useNamingConvention(SettingNamingConvention.SNAKE_CASE).build();
    public static final Config CONFIG = new Config();
    public static final ConfigTree TREE = ConfigTree.builder().applyFromPojo((Object)CONFIG, ANNOTATED_SETTINGS).build();
    private static final JanksonValueSerializer serializer = new JanksonValueSerializer(false);

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                ANNOTATED_SETTINGS.applyToNode(TREE, (Object)CONFIG);
                FiberSerialization.deserialize((ConfigTree)TREE, (InputStream)Files.newInputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
            }
            catch (FiberException | IOException e) {
                VillagerConfig.LOGGER.error("Failed to load config file!", e);
            }
        } else {
            ConfigManager.saveModConfig();
        }
    }

    public static void saveModConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            ANNOTATED_SETTINGS.applyToNode(TREE, (Object)CONFIG);
            FiberSerialization.serialize((ConfigTree)TREE, (OutputStream)Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)serializer);
        }
        catch (FiberException | IOException e) {
            VillagerConfig.LOGGER.error("Failed to save config file!", e);
        }
    }
}

