/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util;

import me.drex.villagerconfig.common.VillagerConfig;
import me.drex.villagerconfig.common.data.TradeTable;
import me.drex.villagerconfig.common.mixin.VillagerDataAccessor;
import net.minecraft.class_1646;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_7923;

public class CustomVillagerData {
    public static TradeTable getTradeTable(class_1646 villager) {
        if (villager.method_73183() instanceof class_3218) {
            class_2960 identifier = class_7923.field_41195.method_10221((Object)((class_3852)villager.method_7231().comp_3521().comp_349()));
            return VillagerConfig.TRADE_MANAGER.getTrade(identifier);
        }
        return null;
    }

    public static int getMaxLevel(class_1646 villager) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            return tradeTable.maxLevel();
        }
        return 5;
    }

    public static int[] getNextLevelXpThresholds(class_1646 villager) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            int[] nextLevelXpThresholds = new int[tradeTable.maxLevel()];
            for (int i = 0; i < tradeTable.maxLevel(); ++i) {
                nextLevelXpThresholds[i] = tradeTable.requiredExperience(i + 1);
            }
            return nextLevelXpThresholds;
        }
        return VillagerDataAccessor.getNextLevelXpThresholds();
    }

    public static int getMinXpPerLevel(class_1646 villager, int level) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            return tradeTable.requiredExperience(level);
        }
        return class_3850.method_19194((int)level);
    }

    public static int getMaxXpPerLevel(class_1646 villager, int level) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            return tradeTable.requiredExperience(level + 1);
        }
        return class_3850.method_19195((int)level);
    }

    public static boolean canLevelUp(class_1646 villager, int level) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable(villager);
        if (tradeTable != null) {
            int maxLevel = tradeTable.maxLevel();
            return level >= 1 && level < maxLevel;
        }
        return class_3850.method_19196((int)level);
    }
}

