/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.drex.villagerconfig.common.util.loot.LootItemFunctionTypes;
import me.drex.villagerconfig.common.util.loot.VCLootContextParams;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EnchantRandomlyLootFunction
extends class_120 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<EnchantRandomlyLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> EnchantRandomlyLootFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41265).optionalFieldOf("include").forGetter(enchantRandomlyFunction -> enchantRandomlyFunction.include), (App)class_6895.method_40340((class_5321)class_7924.field_41265).optionalFieldOf("exclude").forGetter(enchantRandomlyFunction -> enchantRandomlyFunction.exclude), (App)Codec.INT.optionalFieldOf("min_level", (Object)0).forGetter(enchantRandomlyLootFunction -> enchantRandomlyLootFunction.minLevel), (App)Codec.INT.optionalFieldOf("max_level", (Object)Integer.MAX_VALUE).forGetter(enchantRandomlyLootFunction -> enchantRandomlyLootFunction.maxLevel))).apply((Applicative)instance, EnchantRandomlyLootFunction::new));
    private final Optional<class_6885<class_1887>> include;
    private final Optional<class_6885<class_1887>> exclude;
    private final int minLevel;
    private final int maxLevel;

    EnchantRandomlyLootFunction(List<class_5341> conditions, Optional<class_6885<class_1887>> include, Optional<class_6885<class_1887>> exclude, int minLevel, int maxLevel) {
        super(conditions);
        this.include = include;
        this.exclude = exclude;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @NotNull
    protected class_1799 method_522(@NotNull class_1799 stack, class_47 context) {
        class_5819 randomSource = context.method_294();
        Optional optional = this.include.flatMap(holders -> holders.method_40243(randomSource)).or(() -> {
            boolean isBook = stack.method_31574(class_1802.field_8529);
            class_6885<class_1887> excluded = this.exclude.orElse((class_6885<class_1887>)class_6885.method_40246((class_6880[])new class_6880[0]));
            List<class_6880.class_6883> list = context.method_299().method_30349().method_30530(class_7924.field_41265).method_42017().filter(reference -> isBook || ((class_1887)reference.comp_349()).method_8192(stack)).filter(reference -> !excluded.method_40241((class_6880)reference)).toList();
            return class_156.method_40083(list, (class_5819)randomSource);
        });
        if (optional.isEmpty()) {
            LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)stack);
            return stack;
        }
        return this.enchantItem(stack, (class_6880<class_1887>)((class_6880)optional.get()), randomSource, context);
    }

    private class_1799 enchantItem(class_1799 itemStack, class_6880<class_1887> holder, class_5819 randomSource, class_47 context) {
        class_1887 enchantment = (class_1887)holder.comp_349();
        int level = class_3532.method_15395((class_5819)randomSource, (int)enchantment.method_8187(), (int)enchantment.method_8183());
        level = class_3532.method_15340((int)level, (int)this.minLevel, (int)this.maxLevel);
        if (itemStack.method_31574(class_1802.field_8529)) {
            itemStack = new class_1799((class_1935)class_1802.field_8598);
        }
        itemStack.method_7978(holder, level);
        if (context.method_300(VCLootContextParams.NUMBER_REFERENCE)) {
            Map referenceProviders = (Map)context.method_35508(VCLootContextParams.NUMBER_REFERENCE);
            referenceProviders.put("enchantmentLevel", Float.valueOf(level));
            referenceProviders.put("treasureMultiplier", Float.valueOf(holder.method_40220(class_9636.field_51546) ? 2.0f : 1.0f));
        }
        return itemStack;
    }

    @NotNull
    public class_5339 method_29321() {
        return LootItemFunctionTypes.ENCHANT_RANDOMLY;
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private Optional<class_6885<class_1887>> include = Optional.empty();
        private Optional<class_6885<class_1887>> exclude = Optional.empty();
        private int minLevel = 0;
        private int maxLevel = Integer.MAX_VALUE;

        public Builder include(class_6885<class_1887> enchantments) {
            this.include = Optional.of(enchantments);
            return this;
        }

        public Builder exclude(class_6885<class_1887> enchantments) {
            this.exclude = Optional.of(enchantments);
            return this;
        }

        public Builder minLevel(int minLevel) {
            this.minLevel = minLevel;
            return this;
        }

        public Builder maxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        @NotNull
        public class_117 method_515() {
            return new EnchantRandomlyLootFunction(this.method_526(), this.include, this.exclude, this.minLevel, this.maxLevel);
        }

        @NotNull
        protected Builder getThis() {
            return this;
        }
    }
}

