/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.common.db.PlayerRecord;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR#\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR#\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\t8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\f\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lme/jfenn/coordshud/common/cache/PlayerCache;", "", "<init>", "()V", "Ljava/util/UUID;", "playerId", "", "remove", "(Ljava/util/UUID;)V", "Lcom/google/common/cache/Cache;", "Lme/jfenn/coordshud/common/db/PlayerRecord;", "players", "Lcom/google/common/cache/Cache;", "getPlayers", "()Lcom/google/common/cache/Cache;", "Lnet/minecraft/class_2561;", "playerFormats", "getPlayerFormats", "coordshud-common"})
public final class PlayerCache {
    @NotNull
    private final Cache<UUID, PlayerRecord> players;
    @NotNull
    private final Cache<UUID, class_2561> playerFormats;

    public PlayerCache() {
        Cache cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.players = cache;
        Cache cache2 = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.playerFormats = cache2;
    }

    @NotNull
    public final Cache<UUID, PlayerRecord> getPlayers() {
        return this.players;
    }

    @NotNull
    public final Cache<UUID, class_2561> getPlayerFormats() {
        return this.playerFormats;
    }

    public final void remove(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        this.players.invalidate((Object)playerId);
        this.playerFormats.invalidate((Object)playerId);
    }
}

