/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.statements;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Table;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Transaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.Statement;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.ResultApi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u000f\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f0\u000b0\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00018\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/ReturningStatement;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/Statement;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/ResultApi;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;", "table", "", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "returningExpressions", "mainStatement", "<init>", "(Lorg/jetbrains/exposed/v1/core/Table;Ljava/util/List;Lorg/jetbrains/exposed/v1/core/statements/Statement;)V", "", "Lkotlin/Pair;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/IColumnType;", "", "arguments", "()Ljava/lang/Iterable;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;", "transaction", "", "prepared", "", "prepareSQL", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;Z)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;", "getTable", "()Lorg/jetbrains/exposed/v1/core/Table;", "Ljava/util/List;", "getReturningExpressions", "()Ljava/util/List;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/Statement;", "getMainStatement", "()Lorg/jetbrains/exposed/v1/core/statements/Statement;", "exposed-core"})
public class ReturningStatement
extends Statement<ResultApi> {
    @NotNull
    private final Table table;
    @NotNull
    private final List<Expression<?>> returningExpressions;
    @NotNull
    private final Statement<?> mainStatement;

    public ReturningStatement(@NotNull Table table, @NotNull List<? extends Expression<?>> returningExpressions, @NotNull Statement<?> mainStatement) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(returningExpressions, (String)"returningExpressions");
        Intrinsics.checkNotNullParameter(mainStatement, (String)"mainStatement");
        super(mainStatement.getType(), CollectionsKt.listOf((Object)table));
        this.table = table;
        this.returningExpressions = returningExpressions;
        this.mainStatement = mainStatement;
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final List<Expression<?>> getReturningExpressions() {
        return this.returningExpressions;
    }

    @NotNull
    public final Statement<?> getMainStatement() {
        return this.mainStatement;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.mainStatement.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared2) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String mainSql = this.mainStatement.prepareSQL(transaction, prepared2);
        return transaction.getDb().getDialect().getFunctionProvider().returning(mainSql, this.returningExpressions, transaction);
    }
}

