/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Case;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.LiteralOpKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.OpBuilderKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.QueryBuilder;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SortOrder;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006J\u000f\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u000f\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\u0006J\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u0006J\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0006J\u000f\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0006J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0006J\u0017\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0006J\u000f\u0010\u001b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0006J\u000f\u0010\u001c\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0006J\u000f\u0010\u001d\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0006J+\u0010%\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u001e2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/SQLServerDataTypeProvider;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DataTypeProvider;", "<init>", "()V", "", "byteType", "()Ljava/lang/String;", "ubyteType", "integerAutoincType", "longAutoincType", "ulongAutoincType", "binaryType", "blobType", "uuidType", "Ljava/util/UUID;", "value", "", "uuidToDB", "(Ljava/util/UUID;)Ljava/lang/Object;", "dateTimeType", "timestampWithTimeZoneType", "booleanType", "", "bool", "booleanToStatementString", "(Z)Ljava/lang/String;", "textType", "mediumTextType", "largeTextType", "jsonType", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/QueryBuilder;", "queryBuilder", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "expression", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/SortOrder;", "sortOrder", "", "precessOrderByClause", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/QueryBuilder;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/SortOrder;)V", "hexString", "hexToDb", "(Ljava/lang/String;)Ljava/lang/String;", "exposed-core"})
public final class SQLServerDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final SQLServerDataTypeProvider INSTANCE = new SQLServerDataTypeProvider();

    private SQLServerDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.SQLServer ? "TINYINT" : "SMALLINT";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.SQLServer ? "SMALLINT" : "TINYINT";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "INT IDENTITY(1,1)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "BIGINT IDENTITY(1,1)";
    }

    @Override
    @NotNull
    public String ulongAutoincType() {
        return "NUMERIC(20) IDENTITY(1,1)";
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    @NotNull
    public String blobType() {
        return "VARBINARY(MAX)";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "uniqueidentifier";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "DATETIME2";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.SQLServer ? "TIMESTAMP(9) WITH TIME ZONE" : "DATETIMEOFFSET";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "BIT";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    @NotNull
    public String textType() {
        return "VARCHAR(MAX)";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String largeTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String jsonType() {
        return "NVARCHAR(MAX)";
    }

    @Override
    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, sortOrder);
                break;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                break;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                break;
            }
            default: {
                Pair sortOrderClause = sortOrder == SortOrder.ASC_NULLS_LAST ? TuplesKt.to(new Case().When((Expression)OpBuilderKt.isNull(expression), LiteralOpKt.intLiteral(1)).Else(LiteralOpKt.intLiteral(0)), (Object)((Object)SortOrder.ASC)) : TuplesKt.to(new Case().When((Expression)OpBuilderKt.isNull(expression), LiteralOpKt.intLiteral(0)).Else(LiteralOpKt.intLiteral(1)), (Object)((Object)SortOrder.DESC));
                Object[] objectArray = new Object[]{sortOrderClause.getFirst(), ", "};
                ExpressionKt.append(queryBuilder, objectArray);
                super.precessOrderByClause(queryBuilder, expression, (SortOrder)((Object)sortOrderClause.getSecond()));
            }
        }
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        return "0x" + hexString;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

