/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.AutoIncColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnDiff;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnTypeKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Expression;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Index;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ReferenceOption;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Schema;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SchemaKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Transaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLServerDataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLServerFunctionProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.VendorDialect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0006\b\u0016\u0018\u0000 H2\u00020\u0001:\u0001HB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0017\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J7\u0010'\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b'\u0010(J/\u0010-\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0014\u00106\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u001a\u00107\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b7\u00100\u001a\u0004\b8\u00102R\u001a\u00109\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b9\u00100\u001a\u0004\b:\u00102R\u001a\u0010;\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b;\u00100\u001a\u0004\b<\u00102R\u001a\u0010=\u001a\u00020\u00068\u0016X\u0096D\u00a2\u0006\f\n\u0004\b=\u00100\u001a\u0004\b>\u00102R\u001a\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000e0?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR(\u0010D\u001a\u0010\u0012\u0004\u0012\u00020C\u0012\u0006\u0012\u0004\u0018\u00010C0B8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\u00a8\u0006I"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/SQLServerDialect;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect;", "<init>", "()V", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Expression;)Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;", "column", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnDiff;", "columnDiff", "", "", "modifyColumn", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnDiff;)Ljava/util/List;", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "listDatabases", "()Ljava/lang/String;", "dropDatabase", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;", "schema", "setSchema", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;)Ljava/lang/String;", "createSchema", "cascade", "dropSchema", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;Z)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;", "index", "createIndex", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;)Ljava/lang/String;", "table", "columns", "type", "filterCondition", "createIndexWithType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropIndex", "(Ljava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", "supportsIfNotExists", "Z", "getSupportsIfNotExists", "()Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/v1/core/ReferenceOption;", "defaultReferenceOption", "needsQuotesWhenSymbolsInNames", "getNeedsQuotesWhenSymbolsInNames", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "", "nonAcceptableDefaults", "[Ljava/lang/String;", "", "", "likePatternSpecialChars", "Ljava/util/Map;", "getLikePatternSpecialChars", "()Ljava/util/Map;", "Companion", "exposed-core"})
public class SQLServerDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsSequenceAsGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsRestrictReferenceOption;
    @NotNull
    private final String[] nonAcceptableDefaults;
    @NotNull
    private final Map<Character, Character> likePatternSpecialChars;
    @NotNull
    private static final Map<Character, Character> sqlServerLikePatternSpecialChars;

    public SQLServerDialect() {
        super(Companion.getDialectName(), SQLServerDataTypeProvider.INSTANCE, SQLServerFunctionProvider.INSTANCE);
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        String[] stringArray = new String[]{"DEFAULT"};
        this.nonAcceptableDefaults = stringArray;
        this.likePatternSpecialChars = sqlServerLikePatternSpecialChars;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        String string = e.toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String columnDefault = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return !ArraysKt.contains((Object[])this.nonAcceptableDefaults, (Object)columnDefault);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        boolean replaceWithNewColumn;
        List statements;
        String alterTablePart;
        Transaction transaction;
        block8: {
            StringBuilder stringBuilder;
            List list;
            block10: {
                void $this$modifyColumn_u24lambda_u242;
                Expression<?> expression;
                String dropConstraint;
                block9: {
                    void $this$modifyColumn_u24lambda_u240;
                    StringBuilder stringBuilder2;
                    Intrinsics.checkNotNullParameter(column, (String)"column");
                    Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
                    transaction = CoreTransactionManager.INSTANCE.currentTransaction();
                    alterTablePart = "ALTER TABLE " + transaction.identity(column.getTable()) + ' ';
                    statements = new ArrayList();
                    AutoIncColumnType<?> autoIncColumnType = ColumnTypeKt.getAutoIncColumnType(column);
                    replaceWithNewColumn = columnDiff.getAutoInc() && autoIncColumnType != null && autoIncColumnType.getSequence() == null;
                    StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
                    list = statements;
                    boolean bl = false;
                    StringBuilder stringBuilder4 = replaceWithNewColumn ? $this$modifyColumn_u24lambda_u240.append(alterTablePart + "ADD NEW_" + transaction.identity(column) + ' ' + column.getColumnType().sqlType()) : $this$modifyColumn_u24lambda_u240.append(alterTablePart + "ALTER COLUMN " + transaction.identity(column) + ' ' + column.getColumnType().sqlType());
                    if (columnDiff.getNullability()) {
                        boolean isPKColumn;
                        Expression<?> defaultValue = column.getDbDefaultValue$exposed_core();
                        Object[] objectArray = column.getTable().getPrimaryKey();
                        boolean bl2 = objectArray != null && (objectArray = objectArray.getColumns()) != null ? ArraysKt.contains((Object[])objectArray, column) : (isPKColumn = false);
                        if (column.getColumnType().getNullable() || defaultValue != null && column.getDefaultValueFun() == null && !DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
                            $this$modifyColumn_u24lambda_u240.append(" NULL");
                        } else if (!isPKColumn) {
                            $this$modifyColumn_u24lambda_u240.append(" NOT NULL");
                        }
                    }
                    list.add(stringBuilder2.toString());
                    if (!columnDiff.getDefaults()) break block8;
                    String tableName = column.getTable().getTableName();
                    String columnName = column.getName();
                    String constraintName = "DF_" + tableName + '_' + columnName;
                    dropConstraint = "DROP CONSTRAINT IF EXISTS " + constraintName;
                    StringBuilder stringBuilder5 = stringBuilder = new StringBuilder();
                    list = statements;
                    boolean bl3 = false;
                    expression = column.getDbDefaultValue$exposed_core();
                    if (expression == null) break block9;
                    Expression<?> it = expression;
                    boolean bl4 = false;
                    $this$modifyColumn_u24lambda_u242.append(alterTablePart + dropConstraint);
                    $this$modifyColumn_u24lambda_u242.append("; ");
                    StringBuilder stringBuilder6 = $this$modifyColumn_u24lambda_u242.append(alterTablePart + "ADD CONSTRAINT " + constraintName + " DEFAULT " + SQLServerDataTypeProvider.INSTANCE.processForDefaultValue(it) + " for " + transaction.identity(column));
                    expression = stringBuilder6;
                    if (stringBuilder6 != null) break block10;
                }
                expression = $this$modifyColumn_u24lambda_u242.append(alterTablePart + dropConstraint);
            }
            list.add(stringBuilder.toString());
        }
        if (replaceWithNewColumn) {
            List $this$modifyColumn_u24lambda_u243 = statements;
            boolean bl = false;
            $this$modifyColumn_u24lambda_u243.add(alterTablePart + "DROP COLUMN " + transaction.identity(column));
            $this$modifyColumn_u24lambda_u243.add("EXEC sp_rename '" + transaction.identity(column.getTable()) + ".NEW_" + transaction.identity(column) + "', '" + transaction.identity(column) + "', 'COLUMN'");
        }
        return statements;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT name FROM sys.databases";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DROP DATABASE " + DatabaseDialectKt.inProperCase(name);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "ALTER USER " + schema.getAuthorization() + " WITH DEFAULT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u244, (String[])stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u244, " AUTHORIZATION ", schema.getAuthorization());
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "DROP SCHEMA " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, SQLServerDialect::createIndex$lambda$5, (int)31, null) + " can't be created in SQLServer");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns, @NotNull String type, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)filterCondition, (String)"filterCondition");
        return "CREATE " + type + " INDEX " + name + " ON " + table + ' ' + columns + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return isUnique && !isPartialOrFunctional ? "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName) : "DROP INDEX IF EXISTS " + this.getIdentifierManager().cutIfNecessaryAndQuote(indexName) + " ON " + this.getIdentifierManager().quoteIfNecessary(tableName);
    }

    @Override
    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars() {
        return this.likePatternSpecialChars;
    }

    private static final CharSequence createIndex$lambda$5(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('%'), null), TuplesKt.to((Object)Character.valueOf('_'), null), TuplesKt.to((Object)Character.valueOf('['), (Object)Character.valueOf(']'))};
        sqlServerLikePatternSpecialChars = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/SQLServerDialect$Companion;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "", "", "sqlServerLikePatternSpecialChars", "Ljava/util/Map;", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLServer");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

