/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.DatabaseApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.DatabaseConfig;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Version;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.IdentifierManagerApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.transactions.TransactionManagerApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MariaDBDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.OracleDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PostgreSQLNGDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLServerDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SQLiteDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.DatabaseConnectionAutoRegistration;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.DatabaseKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.api.ExposedConnection;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.api.JdbcExposedDatabaseMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.transactions.TransactionManager;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.DatabaseDialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.H2DialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.MariaDBDialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.MysqlDialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.OracleDialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.PostgreSQLDialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.PostgreSQLNGDialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.SQLServerDialectMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors.SQLiteDialectMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\f\u0018\u0000 U2\u00020\u0001:\u0001UB/\b\u0002\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u0012\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\u000eH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011R!\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u001a\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001d\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u001c\u0010\u0019R\u001b\u0010\"\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0017\u001a\u0004\b \u0010!R\u001b\u0010'\u001a\u00020#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0017\u001a\u0004\b%\u0010&R\u001d\u0010*\u001a\u0004\u0018\u00010\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u0017\u001a\u0004\b)\u0010\u0019R\u001b\u0010/\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0017\u001a\u0004\b-\u0010.R\u001b\u00102\u001a\u00020\u00028VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0017\u001a\u0004\b1\u0010\u0019R\u001b\u00107\u001a\u0002038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0017\u001a\u0004\b5\u00106R\u001b\u0010:\u001a\u0002038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u0017\u001a\u0004\b9\u00106R\u001b\u0010=\u001a\u0002038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u0017\u001a\u0004\b<\u00106R\u001b\u0010@\u001a\u0002038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\u0017\u001a\u0004\b?\u00106R\u001b\u0010E\u001a\u00020A8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010\u0017\u001a\u0004\bC\u0010DR$\u0010G\u001a\u0002032\u0006\u0010F\u001a\u0002038\u0000@BX\u0080\u000e\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u00106R\"\u0010K\u001a\u00020J8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\"\u0010Q\u001a\u0002038\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010H\u001a\u0004\bR\u00106\"\u0004\bS\u0010T\u00a8\u0006V"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseApi;", "", "resolvedVendor", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseConfig;", "config", "Lkotlin/Function0;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "connector", "<init>", "(Ljava/lang/String;Lorg/jetbrains/exposed/v1/core/DatabaseConfig;Lkotlin/jvm/functions/Function0;)V", "T", "Lkotlin/Function1;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/api/JdbcExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "body", "metadata$exposed_jdbc", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "metadata", "Lkotlin/jvm/functions/Function0;", "getConnector", "()Lkotlin/jvm/functions/Function0;", "url$delegate", "Lkotlin/Lazy;", "getUrl", "()Ljava/lang/String;", "url", "vendor$delegate", "getVendor", "vendor", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/DatabaseDialect;", "dialect$delegate", "getDialect", "()Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect;", "dialect", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata;", "dialectMetadata$delegate", "getDialectMetadata", "()Lorg/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata;", "dialectMetadata", "dialectMode$delegate", "getDialectMode", "dialectMode", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Version;", "version$delegate", "getVersion", "()Lorg/jetbrains/exposed/v1/core/Version;", "version", "fullVersion$delegate", "getFullVersion", "fullVersion", "", "supportsAlterTableWithAddColumn$delegate", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn$delegate", "getSupportsAlterTableWithDropColumn", "supportsAlterTableWithDropColumn", "supportsMultipleResultSets$delegate", "getSupportsMultipleResultSets", "supportsMultipleResultSets", "supportsSelectForUpdate$delegate", "getSupportsSelectForUpdate", "supportsSelectForUpdate", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getIdentifierManager", "()Lorg/jetbrains/exposed/v1/core/statements/api/IdentifierManagerApi;", "identifierManager", "value", "connectsViaDataSource", "Z", "getConnectsViaDataSource$exposed_jdbc", "", "dataSourceIsolationLevel", "I", "getDataSourceIsolationLevel$exposed_jdbc", "()I", "setDataSourceIsolationLevel$exposed_jdbc", "(I)V", "dataSourceReadOnly", "getDataSourceReadOnly$exposed_jdbc", "setDataSourceReadOnly$exposed_jdbc", "(Z)V", "Companion", "exposed-jdbc"})
public final class Database
extends DatabaseApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<ExposedConnection<?>> connector;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy vendor$delegate;
    @NotNull
    private final Lazy dialect$delegate;
    @NotNull
    private final Lazy dialectMetadata$delegate;
    @NotNull
    private final Lazy dialectMode$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy fullVersion$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithDropColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    private boolean connectsViaDataSource;
    private int dataSourceIsolationLevel;
    private boolean dataSourceReadOnly;
    @NotNull
    private static final Lazy<DatabaseConnectionAutoRegistration> connectionInstanceImpl$delegate = LazyKt.lazy(Database::connectionInstanceImpl_delegate$lambda$23);
    @NotNull
    private static final Map<String, String> driverMapping;
    @NotNull
    private static final Map<String, String> dialectMapping;
    @NotNull
    private static final ConcurrentHashMap<String, Function0<DatabaseDialectMetadata>> dialectsMetadata;

    private Database(String resolvedVendor, DatabaseConfig config, Function0<? extends ExposedConnection<?>> connector) {
        super(resolvedVendor, config);
        this.connector = connector;
        this.url$delegate = LazyKt.lazy(() -> Database.url_delegate$lambda$1(this));
        this.vendor$delegate = LazyKt.lazy(() -> Database.vendor_delegate$lambda$3(resolvedVendor, this));
        this.dialect$delegate = LazyKt.lazy(() -> Database.dialect_delegate$lambda$5(config, this));
        this.dialectMetadata$delegate = LazyKt.lazy(() -> Database.dialectMetadata_delegate$lambda$6(this));
        this.dialectMode$delegate = LazyKt.lazy(() -> Database.dialectMode_delegate$lambda$8(this));
        this.version$delegate = LazyKt.lazy(() -> Database.version_delegate$lambda$10(this));
        this.fullVersion$delegate = LazyKt.lazy(() -> Database.fullVersion_delegate$lambda$12(this));
        this.supportsAlterTableWithAddColumn$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Database.supportsAlterTableWithAddColumn_delegate$lambda$14(this));
        this.supportsAlterTableWithDropColumn$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Database.supportsAlterTableWithDropColumn_delegate$lambda$16(this));
        this.supportsMultipleResultSets$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Database.supportsMultipleResultSets_delegate$lambda$18(this));
        this.supportsSelectForUpdate$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Database.supportsSelectForUpdate_delegate$lambda$20(this));
        this.identifierManager$delegate = LazyKt.lazy(() -> Database.identifierManager_delegate$lambda$22(this));
        this.dataSourceIsolationLevel = -1;
    }

    /* synthetic */ Database(String string, DatabaseConfig databaseConfig, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, databaseConfig, function0);
    }

    @NotNull
    public final Function0<ExposedConnection<?>> getConnector() {
        return this.connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T metadata$exposed_jdbc(@NotNull Function1<? super JdbcExposedDatabaseMetadata, ? extends T> body) {
        T t;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        JdbcTransaction transaction = TransactionManager.Companion.currentOrNull();
        if (transaction == null) {
            T t2;
            try (ExposedConnection connection = (ExposedConnection)this.connector.invoke();){
                t2 = connection.metadata(body);
            }
            t = t2;
        } else {
            t = transaction.getConnection().metadata(body);
        }
        return t;
    }

    @Override
    @NotNull
    public String getUrl() {
        Lazy lazy = this.url$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getVendor() {
        Lazy lazy = this.vendor$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public DatabaseDialect getDialect() {
        Lazy lazy = this.dialect$delegate;
        return (DatabaseDialect)lazy.getValue();
    }

    @NotNull
    public final DatabaseDialectMetadata getDialectMetadata() {
        Lazy lazy = this.dialectMetadata$delegate;
        return (DatabaseDialectMetadata)lazy.getValue();
    }

    @Override
    @Nullable
    public String getDialectMode() {
        Lazy lazy = this.dialectMode$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public Version getVersion() {
        Lazy lazy = this.version$delegate;
        return (Version)lazy.getValue();
    }

    @Override
    @NotNull
    public String getFullVersion() {
        Lazy lazy = this.fullVersion$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsAlterTableWithDropColumn() {
        Lazy lazy = this.supportsAlterTableWithDropColumn$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsMultipleResultSets() {
        Lazy lazy = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public IdentifierManagerApi getIdentifierManager() {
        Lazy lazy = this.identifierManager$delegate;
        return (IdentifierManagerApi)lazy.getValue();
    }

    public final boolean getConnectsViaDataSource$exposed_jdbc() {
        return this.connectsViaDataSource;
    }

    public final int getDataSourceIsolationLevel$exposed_jdbc() {
        return this.dataSourceIsolationLevel;
    }

    public final void setDataSourceIsolationLevel$exposed_jdbc(int n) {
        this.dataSourceIsolationLevel = n;
    }

    public final boolean getDataSourceReadOnly$exposed_jdbc() {
        return this.dataSourceReadOnly;
    }

    public final void setDataSourceReadOnly$exposed_jdbc(boolean bl) {
        this.dataSourceReadOnly = bl;
    }

    private static final String url_delegate$lambda$1$lambda$0(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getUrl();
    }

    private static final String url_delegate$lambda$1(Database this$0) {
        return (String)this$0.metadata$exposed_jdbc(Database::url_delegate$lambda$1$lambda$0);
    }

    private static final String vendor_delegate$lambda$3$lambda$2(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getDatabaseDialectName();
    }

    private static final String vendor_delegate$lambda$3(String $resolvedVendor, Database this$0) {
        String string = $resolvedVendor;
        if (string == null) {
            string = (String)this$0.metadata$exposed_jdbc(Database::vendor_delegate$lambda$3$lambda$2);
        }
        return string;
    }

    private static final DatabaseDialect dialect_delegate$lambda$5(DatabaseConfig $config, Database this$0) {
        DatabaseDialect databaseDialect = $config.getExplicitDialect();
        if (databaseDialect == null) {
            Database $this$dialect_delegate_u24lambda_u245_u24lambda_u244 = this$0;
            boolean bl = false;
            ConcurrentHashMap<String, Function0<DatabaseDialect>> concurrentHashMap = DatabaseApi.Companion.getDialects();
            String string = $this$dialect_delegate_u24lambda_u245_u24lambda_u244.getVendor().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Function0<DatabaseDialect> function0 = concurrentHashMap.get(string);
            DatabaseDialect databaseDialect2 = function0 != null ? (DatabaseDialect)function0.invoke() : null;
            databaseDialect = databaseDialect2;
            if (databaseDialect2 == null) {
                throw new IllegalStateException(("No dialect registered for " + DatabaseKt.getName(this$0) + ". URL=" + this$0.getUrl()).toString());
            }
        }
        return databaseDialect;
    }

    private static final DatabaseDialectMetadata dialectMetadata_delegate$lambda$6(Database this$0) {
        String string = this$0.getVendor().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Object object = dialectsMetadata.get(string);
        if (object == null || (object = (DatabaseDialectMetadata)object.invoke()) == null) {
            throw new IllegalStateException(("No dialect metadata registered for " + DatabaseKt.getName(this$0) + ". URL=" + this$0.getUrl()).toString());
        }
        return object;
    }

    private static final String dialectMode_delegate$lambda$8$lambda$7(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getDatabaseDialectMode();
    }

    private static final String dialectMode_delegate$lambda$8(Database this$0) {
        return (String)this$0.metadata$exposed_jdbc(Database::dialectMode_delegate$lambda$8$lambda$7);
    }

    private static final Version version_delegate$lambda$10$lambda$9(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return Version.Companion.from($this$metadata.getVersion());
    }

    private static final Version version_delegate$lambda$10(Database this$0) {
        return (Version)this$0.metadata$exposed_jdbc(Database::version_delegate$lambda$10$lambda$9);
    }

    private static final String fullVersion_delegate$lambda$12$lambda$11(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getDatabaseProductVersion();
    }

    private static final String fullVersion_delegate$lambda$12(Database this$0) {
        return (String)this$0.metadata$exposed_jdbc(Database::fullVersion_delegate$lambda$12$lambda$11);
    }

    private static final boolean supportsAlterTableWithAddColumn_delegate$lambda$14$lambda$13(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsAlterTableWithAddColumn();
    }

    private static final boolean supportsAlterTableWithAddColumn_delegate$lambda$14(Database this$0) {
        return (Boolean)this$0.metadata$exposed_jdbc(Database::supportsAlterTableWithAddColumn_delegate$lambda$14$lambda$13);
    }

    private static final boolean supportsAlterTableWithDropColumn_delegate$lambda$16$lambda$15(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsAlterTableWithDropColumn();
    }

    private static final boolean supportsAlterTableWithDropColumn_delegate$lambda$16(Database this$0) {
        return (Boolean)this$0.metadata$exposed_jdbc(Database::supportsAlterTableWithDropColumn_delegate$lambda$16$lambda$15);
    }

    private static final boolean supportsMultipleResultSets_delegate$lambda$18$lambda$17(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsMultipleResultSets();
    }

    private static final boolean supportsMultipleResultSets_delegate$lambda$18(Database this$0) {
        return (Boolean)this$0.metadata$exposed_jdbc(Database::supportsMultipleResultSets_delegate$lambda$18$lambda$17);
    }

    private static final boolean supportsSelectForUpdate_delegate$lambda$20$lambda$19(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSupportsSelectForUpdate();
    }

    private static final boolean supportsSelectForUpdate_delegate$lambda$20(Database this$0) {
        return (Boolean)this$0.metadata$exposed_jdbc(Database::supportsSelectForUpdate_delegate$lambda$20$lambda$19);
    }

    private static final IdentifierManagerApi identifierManager_delegate$lambda$22$lambda$21(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getIdentifierManager();
    }

    private static final IdentifierManagerApi identifierManager_delegate$lambda$22(Database this$0) {
        return (IdentifierManagerApi)this$0.metadata$exposed_jdbc(Database::identifierManager_delegate$lambda$22$lambda$21);
    }

    private static final DatabaseConnectionAutoRegistration connectionInstanceImpl_delegate$lambda$23() {
        ServiceLoader<DatabaseConnectionAutoRegistration> serviceLoader = ServiceLoader.load(DatabaseConnectionAutoRegistration.class, Database.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration = (DatabaseConnectionAutoRegistration)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (databaseConnectionAutoRegistration == null) {
            throw new IllegalStateException(("Can't load implementation for " + Reflection.getOrCreateKotlinClass(DatabaseConnectionAutoRegistration.class).getSimpleName()).toString());
        }
        return databaseConnectionAutoRegistration;
    }

    private static final DatabaseDialect _init_$lambda$24() {
        return new H2Dialect();
    }

    private static final DatabaseDialect _init_$lambda$25() {
        return new MysqlDialect();
    }

    private static final DatabaseDialect _init_$lambda$26() {
        return new PostgreSQLDialect(null, 1, null);
    }

    private static final DatabaseDialect _init_$lambda$27() {
        return new PostgreSQLNGDialect();
    }

    private static final DatabaseDialect _init_$lambda$28() {
        return new SQLiteDialect();
    }

    private static final DatabaseDialect _init_$lambda$29() {
        return new OracleDialect();
    }

    private static final DatabaseDialect _init_$lambda$30() {
        return new SQLServerDialect();
    }

    private static final DatabaseDialect _init_$lambda$31() {
        return new MariaDBDialect();
    }

    private static final DatabaseDialectMetadata _init_$lambda$32() {
        return new H2DialectMetadata();
    }

    private static final DatabaseDialectMetadata _init_$lambda$33() {
        return new MysqlDialectMetadata();
    }

    private static final DatabaseDialectMetadata _init_$lambda$34() {
        return new PostgreSQLDialectMetadata();
    }

    private static final DatabaseDialectMetadata _init_$lambda$35() {
        return new PostgreSQLNGDialectMetadata();
    }

    private static final DatabaseDialectMetadata _init_$lambda$36() {
        return new SQLiteDialectMetadata();
    }

    private static final DatabaseDialectMetadata _init_$lambda$37() {
        return new OracleDialectMetadata();
    }

    private static final DatabaseDialectMetadata _init_$lambda$38() {
        return new SQLServerDialectMetadata();
    }

    private static final DatabaseDialectMetadata _init_$lambda$39() {
        return new MariaDBDialectMetadata();
    }

    public /* synthetic */ Database(String resolvedVendor, DatabaseConfig config, Function0 connector, DefaultConstructorMarker $constructor_marker) {
        this(resolvedVendor, config, connector);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jdbc:h2", (Object)"org.h2.Driver"), TuplesKt.to((Object)"jdbc:postgresql", (Object)"org.postgresql.Driver"), TuplesKt.to((Object)"jdbc:pgsql", (Object)"com.impossibl.postgres.jdbc.PGDriver"), TuplesKt.to((Object)"jdbc:mysql", (Object)"com.mysql.cj.jdbc.Driver"), TuplesKt.to((Object)"jdbc:mariadb", (Object)"org.mariadb.jdbc.Driver"), TuplesKt.to((Object)"jdbc:oracle", (Object)"oracle.jdbc.OracleDriver"), TuplesKt.to((Object)"jdbc:sqlite", (Object)"org.sqlite.JDBC"), TuplesKt.to((Object)"jdbc:sqlserver", (Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver")};
        driverMapping = MapsKt.mutableMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"jdbc:h2", (Object)H2Dialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:postgresql", (Object)PostgreSQLDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:pgsql", (Object)PostgreSQLNGDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:mysql", (Object)MysqlDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:mariadb", (Object)MariaDBDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:oracle", (Object)OracleDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:sqlite", (Object)SQLiteDialect.Companion.getDialectName()), TuplesKt.to((Object)"jdbc:sqlserver", (Object)SQLServerDialect.Companion.getDialectName())};
        dialectMapping = MapsKt.mutableMapOf((Pair[])pairArray);
        dialectsMetadata = new ConcurrentHashMap();
        DatabaseApi.Companion.registerDialect(H2Dialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$24));
        DatabaseApi.Companion.registerDialect(MysqlDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$25));
        DatabaseApi.Companion.registerDialect(PostgreSQLDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$26));
        DatabaseApi.Companion.registerDialect(PostgreSQLNGDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$27));
        DatabaseApi.Companion.registerDialect(SQLiteDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$28));
        DatabaseApi.Companion.registerDialect(OracleDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$29));
        DatabaseApi.Companion.registerDialect(SQLServerDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$30));
        DatabaseApi.Companion.registerDialect(MariaDBDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialect>)((Function0)Database::_init_$lambda$31));
        Companion.registerDialectMetadata(H2Dialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$32));
        Companion.registerDialectMetadata(MysqlDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$33));
        Companion.registerDialectMetadata(PostgreSQLDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$34));
        Companion.registerDialectMetadata(PostgreSQLNGDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$35));
        Companion.registerDialectMetadata(SQLiteDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$36));
        Companion.registerDialectMetadata(OracleDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$37));
        Companion.registerDialectMetadata(SQLServerDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$38));
        Companion.registerDialectMetadata(MariaDBDialect.Companion.getDialectName(), (Function0<? extends DatabaseDialectMetadata>)((Function0)Database::_init_$lambda$39));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJe\u0010\u001c\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00062\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0\u00172\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0017H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJW\u0010!\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001e2\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0\u00172\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0017\u00a2\u0006\u0004\b!\u0010\"JG\u0010!\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00062\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0017\u00a2\u0006\u0004\b!\u0010#Ju\u0010!\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u00042\b\b\u0002\u0010'\u001a\u00020\u00042\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0\u00172\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0017\u00a2\u0006\u0004\b!\u0010(J\u0015\u0010+\u001a\u00020*2\u0006\u0010)\u001a\u00020\u0019\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010-\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u0004\u00a2\u0006\u0004\b/\u0010.R\u001b\u00104\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R \u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R \u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00107R&\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database$Companion;", "", "<init>", "()V", "", "prefix", "Lkotlin/Function0;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata;", "metadata", "", "registerDialectMetadata", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "driverClassName", "dialect", "registerJdbcDriver", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "explicitVendor", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseConfig;", "config", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/DatabaseConnectionAutoRegistration;", "connectionAutoRegistration", "Ljava/sql/Connection;", "getNewConnection", "Lkotlin/Function1;", "setupConnection", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "manager", "doConnect", "(Ljava/lang/String;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseConfig;Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "Ljavax/sql/DataSource;", "datasource", "databaseConfig", "connect", "(Ljavax/sql/DataSource;Lkotlin/jvm/functions/Function1;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseConfig;Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function1;)Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "(Lkotlin/jvm/functions/Function0;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseConfig;Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function1;)Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "url", "driver", "user", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DatabaseConfig;Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/DatabaseConnectionAutoRegistration;Lkotlin/jvm/functions/Function1;)Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "db", "", "getDefaultIsolationLevel", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;)I", "getDriver", "(Ljava/lang/String;)Ljava/lang/String;", "getDialectName", "connectionInstanceImpl$delegate", "Lkotlin/Lazy;", "getConnectionInstanceImpl", "()Lorg/jetbrains/exposed/v1/jdbc/DatabaseConnectionAutoRegistration;", "connectionInstanceImpl", "", "driverMapping", "Ljava/util/Map;", "dialectMapping", "Ljava/util/concurrent/ConcurrentHashMap;", "dialectsMetadata", "Ljava/util/concurrent/ConcurrentHashMap;", "exposed-jdbc"})
    @SourceDebugExtension(value={"SMAP\nDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Database.kt\norg/jetbrains/exposed/v1/jdbc/Database$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n295#2,2:309\n295#2,2:311\n1#3:313\n*S KotlinDebug\n*F\n+ 1 Database.kt\norg/jetbrains/exposed/v1/jdbc/Database$Companion\n*L\n291#1:309,2\n296#1:311,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final DatabaseConnectionAutoRegistration getConnectionInstanceImpl() {
            Lazy lazy = connectionInstanceImpl$delegate;
            return (DatabaseConnectionAutoRegistration)lazy.getValue();
        }

        public final void registerDialectMetadata(@NotNull String prefix, @NotNull Function0<? extends DatabaseDialectMetadata> metadata) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
            Map map = dialectsMetadata;
            String string = prefix.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map.put(string, metadata);
        }

        public final void registerJdbcDriver(@NotNull String prefix, @NotNull String driverClassName, @NotNull String dialect) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            driverMapping.put(prefix, driverClassName);
            dialectMapping.put(prefix, dialect);
        }

        private final Database doConnect(String explicitVendor, DatabaseConfig config, DatabaseConnectionAutoRegistration connectionAutoRegistration, Function0<? extends Connection> getNewConnection, Function1<? super Connection, Unit> setupConnection, Function1<? super Database, ? extends TransactionManagerApi> manager) {
            Database database;
            DatabaseConfig databaseConfig = config;
            if (databaseConfig == null) {
                databaseConfig = DatabaseConfig.Companion.invoke$default(DatabaseConfig.Companion, null, 1, null);
            }
            Database $this$doConnect_u24lambda_u244 = database = new Database(explicitVendor, databaseConfig, () -> Companion.doConnect$lambda$3(connectionAutoRegistration, getNewConnection, setupConnection), null);
            boolean bl = false;
            TransactionManager.Companion.registerManager($this$doConnect_u24lambda_u244, (TransactionManagerApi)manager.invoke((Object)$this$doConnect_u24lambda_u244));
            return database;
        }

        static /* synthetic */ Database doConnect$default(Companion companion, String string, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function0 function0, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 0x10) != 0) {
                function1 = Companion::doConnect$lambda$0;
            }
            if ((n & 0x20) != 0) {
                function12 = Companion::doConnect$lambda$1;
            }
            return companion.doConnect(string, databaseConfig, databaseConnectionAutoRegistration, (Function0<? extends Connection>)function0, (Function1<? super Connection, Unit>)function1, (Function1<? super Database, ? extends TransactionManagerApi>)function12);
        }

        @NotNull
        public final Database connect(@NotNull DataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull DatabaseConnectionAutoRegistration connectionAutoRegistration, @NotNull Function1<? super Database, ? extends TransactionManagerApi> manager) {
            Database database;
            Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter((Object)connectionAutoRegistration, (String)"connectionAutoRegistration");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Database $this$connect_u24lambda_u248 = database = this.doConnect(null, databaseConfig, connectionAutoRegistration, (Function0<? extends Connection>)((Function0)() -> Companion.connect$lambda$7(datasource)), setupConnection, manager);
            boolean bl = false;
            $this$connect_u24lambda_u248.connectsViaDataSource = true;
            return database;
        }

        public static /* synthetic */ Database connect$default(Companion companion, DataSource dataSource, Function1 function1, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Companion::connect$lambda$5;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                databaseConnectionAutoRegistration = companion.getConnectionInstanceImpl();
            }
            if ((n & 0x10) != 0) {
                function12 = Companion::connect$lambda$6;
            }
            return companion.connect(dataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, databaseConnectionAutoRegistration, (Function1<? super Database, ? extends TransactionManagerApi>)function12);
        }

        @NotNull
        public final Database connect(@NotNull Function0<? extends Connection> getNewConnection, @Nullable DatabaseConfig databaseConfig, @NotNull DatabaseConnectionAutoRegistration connectionAutoRegistration, @NotNull Function1<? super Database, ? extends TransactionManagerApi> manager) {
            Intrinsics.checkNotNullParameter(getNewConnection, (String)"getNewConnection");
            Intrinsics.checkNotNullParameter((Object)connectionAutoRegistration, (String)"connectionAutoRegistration");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.Database$Companion.doConnect$default(this, null, databaseConfig, connectionAutoRegistration, getNewConnection, null, manager, 16, null);
        }

        public static /* synthetic */ Database connect$default(Companion companion, Function0 function0, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                databaseConfig = null;
            }
            if ((n & 4) != 0) {
                databaseConnectionAutoRegistration = companion.getConnectionInstanceImpl();
            }
            if ((n & 8) != 0) {
                function1 = Companion::connect$lambda$9;
            }
            return companion.connect((Function0<? extends Connection>)function0, databaseConfig, databaseConnectionAutoRegistration, (Function1<? super Database, ? extends TransactionManagerApi>)function1);
        }

        @NotNull
        public final Database connect(@NotNull String url, @NotNull String driver, @NotNull String user, @NotNull String password, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull DatabaseConnectionAutoRegistration connectionAutoRegistration, @NotNull Function1<? super Database, ? extends TransactionManagerApi> manager) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter((Object)connectionAutoRegistration, (String)"connectionAutoRegistration");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Class.forName(driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String string = this.getDialectName(url);
            if (string == null) {
                throw new IllegalStateException(("Can't resolve dialect for connection: " + url).toString());
            }
            String dialectName = string;
            return this.doConnect(dialectName, databaseConfig, connectionAutoRegistration, (Function0<? extends Connection>)((Function0)() -> Companion.connect$lambda$12(url, user, password)), setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, String string, String string2, String string3, String string4, Function1 function1, DatabaseConfig databaseConfig, DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = companion.getDriver(string);
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            if ((n & 0x10) != 0) {
                function1 = Companion::connect$lambda$10;
            }
            if ((n & 0x20) != 0) {
                databaseConfig = null;
            }
            if ((n & 0x40) != 0) {
                databaseConnectionAutoRegistration = companion.getConnectionInstanceImpl();
            }
            if ((n & 0x80) != 0) {
                function12 = Companion::connect$lambda$11;
            }
            return companion.connect(string, string2, string3, string4, (Function1<? super Connection, Unit>)function1, databaseConfig, databaseConnectionAutoRegistration, (Function1<? super Database, ? extends TransactionManagerApi>)function12);
        }

        public final int getDefaultIsolationLevel(@NotNull Database db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            DatabaseDialect databaseDialect = db.getDialect();
            return databaseDialect instanceof SQLiteDialect ? 8 : (databaseDialect instanceof MysqlDialect ? 4 : 2);
        }

        private final String getDriver(String url) {
            String string;
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = driverMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix = (String)entry.getKey();
                    if (!StringsKt.startsWith$default((String)url, (String)prefix, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry == null || (string = (String)entry.getValue()) == null) {
                throw new IllegalStateException(("Database driver not found for " + url).toString());
            }
            return string;
        }

        @Nullable
        public final String getDialectName(@NotNull String url) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Iterable $this$firstOrNull$iv = dialectMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix = (String)entry.getKey();
                    if (!StringsKt.startsWith$default((String)url, (String)prefix, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            return entry != null ? (String)entry.getValue() : null;
        }

        private static final Unit doConnect$lambda$0(Connection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final TransactionManager doConnect$lambda$1(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new TransactionManager(it, null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final ExposedConnection doConnect$lambda$3(DatabaseConnectionAutoRegistration $connectionAutoRegistration, Function0 $getNewConnection, Function1 $setupConnection) {
            void $this$doConnect_u24lambda_u243_u24lambda_u242;
            Object object = $getNewConnection.invoke();
            Connection connection = (Connection)object;
            DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration = $connectionAutoRegistration;
            boolean bl = false;
            $setupConnection.invoke((Object)$this$doConnect_u24lambda_u243_u24lambda_u242);
            return (ExposedConnection)databaseConnectionAutoRegistration.invoke(object);
        }

        private static final Unit connect$lambda$5(Connection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final TransactionManager connect$lambda$6(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new TransactionManager(it, null, 2, null);
        }

        private static final Connection connect$lambda$7(DataSource $datasource) {
            Connection connection = $datasource.getConnection();
            Intrinsics.checkNotNull((Object)connection);
            return connection;
        }

        private static final TransactionManager connect$lambda$9(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new TransactionManager(it, null, 2, null);
        }

        private static final Unit connect$lambda$10(Connection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final TransactionManager connect$lambda$11(Database it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new TransactionManager(it, null, 2, null);
        }

        private static final Connection connect$lambda$12(String $url, String $user, String $password) {
            Connection connection = DriverManager.getConnection($url, $user, $password);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
            return connection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

