/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.vendors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.CheckConstraint;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Column;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ForeignKeyConstraint;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Index;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Schema;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Sequence;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Table;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.utils.CacheWithDefault;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.ColumnMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PrimaryKeyMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.SchemaMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.api.ExposedConnection;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.api.JdbcExposedDatabaseMetadata;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.transactions.TransactionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\u001e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007H\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\t\u00a2\u0006\u0004\b\u0014\u0010\rJ\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\t\u00a2\u0006\u0004\b\u0015\u0010\rJ\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001b\u001a\u00020\u0004*\u00020\b2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J3\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\t0&2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160$\"\u00020\u0016\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010+\u001a\u00020*2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\tH\u0014\u00a2\u0006\u0004\b+\u0010,JW\u00102\u001a8\u0012(\u0012&\u0012\u0004\u0012\u00020\u0016\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0.j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/`00-\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\t0&2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160$\"\u00020\u0016\u00a2\u0006\u0004\b2\u0010)J%\u00107\u001a\u00020\u00042\u0006\u00103\u001a\u00020\b2\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u00020\b\u00a2\u0006\u0004\b7\u00108J5\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002090\t0&2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160$\"\u00020\u0016H\u0016\u00a2\u0006\u0004\b:\u0010)J3\u0010<\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0\t0&2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160$\"\u00020\u0016\u00a2\u0006\u0004\b<\u0010)J/\u0010>\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010=0&2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160$\"\u00020\u0016\u00a2\u0006\u0004\b>\u0010)J3\u0010?\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\t0&2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160$\"\u00020\u0016\u00a2\u0006\u0004\b?\u0010)J\u0013\u0010@\u001a\b\u0012\u0004\u0012\u00020\b0\t\u00a2\u0006\u0004\b@\u0010\rJ\r\u0010A\u001a\u00020*\u00a2\u0006\u0004\bA\u0010\u0003J\r\u0010B\u001a\u00020*\u00a2\u0006\u0004\bB\u0010\u0003R*\u0010C\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u001e\u0010E\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\t8F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\rR,\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u0002010I0H8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\u00a8\u0006N"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata;", "", "<init>", "()V", "", "supportsLimitWithUpdateOrDelete", "()Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/utils/CacheWithDefault;", "", "", "getAllTableNamesCache", "()Lme/jfenn/coordshud/jetbrains/exposed/v1/core/utils/CacheWithDefault;", "getAllSchemaNamesCache", "()Ljava/util/List;", "getDatabase", "()Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "transaction", "catalog", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/JdbcTransaction;)Ljava/lang/String;", "allTablesNames", "allTablesNamesInAllSchemas", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;", "table", "tableExists", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;)Z", "schema", "metadataMatchesTable", "(Ljava/lang/String;Ljava/lang/String;Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Table;)Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;", "schemaExists", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Schema;)Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Sequence;", "sequence", "sequenceExists", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Sequence;)Z", "", "tables", "", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/ColumnMetadata;", "tableColumns", "([Lorg/jetbrains/exposed/v1/core/Table;)Ljava/util/Map;", "", "fillConstraintCacheForTables", "(Ljava/util/List;)V", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Column;", "Lkotlin/collections/LinkedHashSet;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ForeignKeyConstraint;", "columnConstraints", "columnMetadataSqlType", "", "columnMetadataType", "columnType", "areEquivalentColumnTypes", "(Ljava/lang/String;ILjava/lang/String;)Z", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Index;", "existingIndices", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/CheckConstraint;", "existingCheckConstraints", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/vendors/PrimaryKeyMetadata;", "existingPrimaryKeys", "existingSequences", "sequences", "resetCaches", "resetSchemaCaches", "_allTableNames", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/utils/CacheWithDefault;", "_allSchemaNames", "Ljava/util/List;", "getAllTablesNames", "", "", "columnConstraintsCache", "Ljava/util/Map;", "getColumnConstraintsCache", "()Ljava/util/Map;", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nDatabaseDialectMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDialectMetadata.kt\norg/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,203:1\n1374#2:204\n1460#2,5:205\n1761#2,3:210\n1761#2,3:213\n1761#2,3:216\n1761#2,3:219\n1869#2:226\n1870#2:234\n3829#3:222\n4344#3,2:223\n13472#3:225\n13473#3:235\n384#4,7:227\n*S KotlinDebug\n*F\n+ 1 DatabaseDialectMetadata.kt\norg/jetbrains/exposed/v1/jdbc/vendors/DatabaseDialectMetadata\n*L\n66#1:204\n66#1:205,5\n75#1:210,3\n82#1:213,3\n105#1:216,3\n111#1:219,3\n136#1:226\n136#1:234\n132#1:222\n132#1:223,2\n135#1:225\n135#1:235\n137#1:227,7\n*E\n"})
public abstract class DatabaseDialectMetadata {
    @Nullable
    private CacheWithDefault<String, List<String>> _allTableNames;
    @Nullable
    private List<String> _allSchemaNames;
    @NotNull
    private final Map<String, Collection<ForeignKeyConstraint>> columnConstraintsCache = new ConcurrentHashMap();

    public boolean supportsLimitWithUpdateOrDelete() {
        return true;
    }

    @NotNull
    public final List<String> getAllTablesNames() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        return (List)connection.metadata(arg_0 -> DatabaseDialectMetadata._get_allTablesNames_$lambda$0(this, arg_0));
    }

    @NotNull
    protected final CacheWithDefault<String, List<String>> getAllTableNamesCache() {
        if (this._allTableNames == null) {
            this._allTableNames = (CacheWithDefault)TransactionManager.Companion.current().getConnection().metadata(DatabaseDialectMetadata::getAllTableNamesCache$lambda$1);
        }
        CacheWithDefault<String, List<String>> cacheWithDefault = this._allTableNames;
        Intrinsics.checkNotNull(cacheWithDefault);
        return cacheWithDefault;
    }

    private final List<String> getAllSchemaNamesCache() {
        if (this._allSchemaNames == null) {
            this._allSchemaNames = (List)TransactionManager.Companion.current().getConnection().metadata(DatabaseDialectMetadata::getAllSchemaNamesCache$lambda$2);
        }
        List<String> list = this._allSchemaNames;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @NotNull
    public final String getDatabase() {
        return this.catalog(TransactionManager.Companion.current());
    }

    @NotNull
    public final String catalog(@NotNull JdbcTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return transaction.getConnection().getCatalog();
    }

    @NotNull
    public final List<String> allTablesNames() {
        return (List)TransactionManager.Companion.current().getConnection().metadata(DatabaseDialectMetadata::allTablesNames$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allTablesNamesInAllSchemas() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getAllSchemaNamesCache();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String schema = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getAllTableNamesCache().get(schema);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean tableExists(@NotNull Table table) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            String string = table.getSchemaName();
            if (string != null) {
                String schema = string;
                boolean bl2 = false;
                Iterable $this$any$iv = this.getAllTableNamesCache().get(DatabaseDialectKt.inProperCase(schema));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)table.nameInDatabaseCase())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                DatabaseDialectMetadata $this$tableExists_u24lambda_u249 = this;
                boolean bl4 = false;
                SchemaMetadata schemaMetadata = (SchemaMetadata)TransactionManager.Companion.current().getConnection().metadata(arg_0 -> DatabaseDialectMetadata.tableExists$lambda$9$lambda$7($this$tableExists_u24lambda_u249, arg_0));
                String schema = schemaMetadata.component1();
                List<String> allTables = schemaMetadata.component2();
                Iterable $this$any$iv = allTables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!$this$tableExists_u24lambda_u249.metadataMatchesTable(it, schema, table)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean metadataMatchesTable(@NotNull String $this$metadataMatchesTable, @NotNull String schema, @NotNull Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$metadataMatchesTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (((CharSequence)schema).length() == 0) {
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)table.nameInDatabaseCaseUnquoted());
        } else {
            String sanitizedTableName = table.getTableNameWithoutSchemeSanitized();
            String nameInDb = DatabaseDialectKt.inProperCase(schema + '.' + sanitizedTableName);
            bl = Intrinsics.areEqual((Object)$this$metadataMatchesTable, (Object)nameInDb);
        }
        return bl;
    }

    public final boolean schemaExists(@NotNull Schema schema) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            List<String> allSchemas = this.getAllSchemaNamesCache();
            Iterable $this$any$iv = allSchemas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DatabaseDialectKt.inProperCase(schema.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean sequenceExists(@NotNull Sequence sequence) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
            Iterable $this$any$iv = this.sequences();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)DatabaseDialectKt.inProperCase(sequence.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Map<Table, List<ColumnMetadata>> tableColumns(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getConnection().metadata(arg_0 -> DatabaseDialectMetadata.tableColumns$lambda$12(tables, arg_0));
    }

    @NotNull
    protected final Map<String, Collection<ForeignKeyConstraint>> getColumnConstraintsCache() {
        return this.columnConstraintsCache;
    }

    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        JdbcTransaction tx = TransactionManager.Companion.current();
        this.columnConstraintsCache.putAll((Map)tx.getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.fillConstraintCacheForTables$lambda$13(tables, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... tables) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        HashMap constraints = new HashMap();
        Table[] $this$filter$iv = tables;
        boolean $i$f$filter = false;
        Table[] tableArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterable element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(!this.columnConstraintsCache.containsKey(it.nameInDatabaseCaseUnquoted()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesToLoad = (List)destination$iv$iv;
        this.fillConstraintCacheForTables(tablesToLoad);
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$forEach$iv2;
            Table element$iv;
            Iterable element$iv$iv;
            Table table = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Collection collection = this.columnConstraintsCache.get(table.nameInDatabaseCaseUnquoted());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            element$iv$iv = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                ForeignKeyConstraint it = (ForeignKeyConstraint)element$iv2;
                boolean bl2 = false;
                Map map = constraints;
                Pair key$iv = TuplesKt.to((Object)table, it.getFrom());
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(it);
            }
        }
        return constraints;
    }

    public final boolean areEquivalentColumnTypes(@NotNull String columnMetadataSqlType, int columnMetadataType, @NotNull String columnType) {
        Intrinsics.checkNotNullParameter((Object)columnMetadataSqlType, (String)"columnMetadataSqlType");
        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
        return (Boolean)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.areEquivalentColumnTypes$lambda$18(columnMetadataSqlType, columnMetadataType, columnType, arg_0));
    }

    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingIndices$lambda$19(tables, arg_0));
    }

    @NotNull
    public final Map<Table, List<CheckConstraint>> existingCheckConstraints(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingCheckConstraints$lambda$20(tables, arg_0));
    }

    @NotNull
    public final Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingPrimaryKeys$lambda$21(tables, arg_0));
    }

    @NotNull
    public final Map<Table, List<Sequence>> existingSequences(Table ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(arg_0 -> DatabaseDialectMetadata.existingSequences$lambda$22(tables, arg_0));
    }

    @NotNull
    public final List<String> sequences() {
        return (List)TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(DatabaseDialectMetadata::sequences$lambda$23);
    }

    public final void resetCaches() {
        this._allTableNames = null;
        this.columnConstraintsCache.clear();
        TransactionManager.Companion.current().getDb().metadata$exposed_jdbc(DatabaseDialectMetadata::resetCaches$lambda$24);
    }

    public final void resetSchemaCaches() {
        this._allSchemaNames = null;
        this.resetCaches();
    }

    private static final List _get_allTablesNames_$lambda$0(DatabaseDialectMetadata this$0, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema(this$0.getAllTableNamesCache()).getTableNames();
    }

    private static final CacheWithDefault getAllTableNamesCache$lambda$1(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getTableNames();
    }

    private static final List getAllSchemaNamesCache$lambda$2(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.getSchemaNames();
    }

    private static final List allTablesNames$lambda$3(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema(null).getTableNames();
    }

    private static final SchemaMetadata tableExists$lambda$9$lambda$7(DatabaseDialectMetadata $this_run, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableNamesByCurrentSchema($this_run.getAllTableNamesCache());
    }

    private static final Map tableColumns$lambda$12(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.columns(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map fillConstraintCacheForTables$lambda$13(List $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.tableConstraints($tables);
    }

    private static final boolean areEquivalentColumnTypes$lambda$18(String $columnMetadataSqlType, int $columnMetadataType, String $columnType, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.areEquivalentColumnTypes($columnMetadataSqlType, $columnMetadataType, $columnType);
    }

    private static final Map existingIndices$lambda$19(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.existingIndices(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingCheckConstraints$lambda$20(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.existingCheckConstraints(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingPrimaryKeys$lambda$21(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.existingPrimaryKeys(Arrays.copyOf($tables, $tables.length));
    }

    private static final Map existingSequences$lambda$22(Table[] $tables, JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.existingSequences(Arrays.copyOf($tables, $tables.length));
    }

    private static final List sequences$lambda$23(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        return $this$metadata.sequences();
    }

    private static final Unit resetCaches$lambda$24(JdbcExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$metadata, (String)"$this$metadata");
        $this$metadata.cleanCache();
        return Unit.INSTANCE;
    }
}

