/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3481;
import net.minecraft.class_3528;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3675;
import net.minecraft.class_424;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7157;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.vanilla.AnimalOwnerProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeClientCommand;
import snownee.jade.compat.PolydexCompat;
import snownee.jade.gui.PreviewOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.ui.FluidStackElement;
import snownee.jade.mixin.KeyAccess;
import snownee.jade.network.ClientHandshakePacket;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.ServerHandshakePacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.KeyedReloadListener;
import snownee.jade.util.WailaExceptionHandler;

public final class ClientProxy
implements ClientModInitializer {
    public static boolean hasFastScroll = CommonProxy.isModLoaded("fastscroll");
    public static boolean hasAccessibilityMod = CommonProxy.isModLoaded("minecraft_access");
    private static boolean bossbarShown;
    private static int bossbarHeight;

    public static Optional<String> getModName(String namespace) {
        String modMenuKey = "modmenu.nameTranslation.%s".formatted(namespace);
        if (class_1074.method_4663((String)modMenuKey)) {
            return Optional.of(class_1074.method_4662((String)modMenuKey, (Object[])new Object[0]));
        }
        return FabricLoader.getInstance().getModContainer(namespace).map(ModContainer::getMetadata).map(ModMetadata::getName).filter(Predicate.not(Strings::isNullOrEmpty));
    }

    public static void registerClientCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register(JadeClientCommand.create(ClientCommandManager::literal, ClientCommandManager::argument, FabricClientCommandSource::sendFeedback, FabricClientCommandSource::sendError));
    }

    private static void onEntityJoin(class_1297 entity, class_638 level) {
        DatapackBlockManager.onEntityJoin(entity);
    }

    private static void onEntityLeave(class_1297 entity, class_638 level) {
        DatapackBlockManager.onEntityLeave(entity);
    }

    public static void onRenderTick(class_332 guiGraphics, float tickDelta) {
        try {
            OverlayRenderer.renderOverlay478757(guiGraphics, tickDelta);
        }
        catch (Throwable e) {
            WailaExceptionHandler.handleErr(e, null, null);
        }
        finally {
            bossbarShown = false;
        }
    }

    private static void onClientTick(class_310 mc) {
        try {
            JadeClient.tickHandler().tickClient();
        }
        catch (Throwable e) {
            WailaExceptionHandler.handleErr(e, null, null);
        }
    }

    private static void onPlayerLeave(class_634 handler, class_310 client) {
        ObjectDataCenter.disconnect();
        WailaClientRegistration.instance().setServerConfig(Map.of());
    }

    private static void onKeyPressed(class_310 mc) {
        JadeClient.onKeyPressed(1);
    }

    private static void onGui(class_437 screen) {
        JadeClient.onGui(screen);
    }

    public static class_304 registerKeyBinding(String desc, int defaultKey) {
        class_304 key = new class_304("key.jade." + desc, class_3675.class_307.field_1668, defaultKey, JadeClient.keyMappingCategory);
        KeyBindingHelper.registerKeyBinding((class_304)key);
        return key;
    }

    public static boolean shouldRegisterRecipeViewerKeys() {
        return true;
    }

    public static Element elementFromLiquid(class_2680 blockState) {
        class_3610 fluidState = blockState.method_26227();
        return new FluidStackElement(JadeFluidObject.of(fluidState.method_15772()));
    }

    public static void registerReloadListener(KeyedReloadListener listener) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)listener);
    }

    public static void drawBossBarPost(class_345 bossEvent, int bottom) {
        IWailaConfig.BossBarOverlapMode mode = Jade.config().general().getBossBarOverlapMode();
        if (mode == IWailaConfig.BossBarOverlapMode.PUSH_DOWN) {
            bossbarHeight = bottom;
            bossbarShown = true;
        }
    }

    @Nullable
    public static Rect2f getBossBarRect() {
        if (!bossbarShown) {
            return null;
        }
        int i = class_310.method_1551().method_22683().method_4486();
        int k = i / 2 - 91;
        return new Rect2f(k, 0.0f, 182.0f, bossbarHeight - 12);
    }

    public static boolean isShowDetailsPressed() {
        return JadeClient.showDetails.method_1434();
    }

    public static boolean shouldShowWithGui(class_310 mc, @Nullable class_437 screen) {
        return screen == null || ClientProxy.shouldShowBeforeGui(mc, screen) || ClientProxy.shouldShowAfterGui(mc, screen);
    }

    public static boolean shouldShowAfterGui(class_310 mc, @NotNull class_437 screen) {
        return screen instanceof PreviewOptionsScreen || JadeUI.isPinned();
    }

    public static boolean shouldShowBeforeGui(class_310 mc, @NotNull class_437 screen) {
        if (mc.field_1687 == null || mc.field_1755 instanceof class_424 || mc.field_1755 instanceof class_435) {
            return false;
        }
        IWailaConfig.General config = IWailaConfig.get().general();
        return !config.shouldHideFromGUIs();
    }

    public static void getFluidSpriteAndColor(JadeFluidObject fluid, BiConsumer<@Nullable class_1058, Integer> consumer) {
        class_3611 type = (class_3611)fluid.getType().comp_349();
        FluidVariant variant = FluidVariant.of((class_3611)type, (class_9326)fluid.getComponents());
        FluidVariantRenderHandler handler = FluidVariantRendering.getHandlerOrDefault((class_3611)type);
        class_1058[] sprites = handler.getSprites(variant);
        class_1058 fluidStillSprite = sprites == null ? null : sprites[0];
        int fluidColor = handler.getColor(variant, (class_1920)class_310.method_1551().field_1687, null);
        consumer.accept(fluidStillSprite, fluidColor);
    }

    public static void renderItemDecorationsExtra(class_332 guiGraphics, class_327 font, class_1799 stack, int x, int y, String text) {
    }

    public static class_1934 getGameMode() {
        class_636 gameMode = class_310.method_1551().field_1761;
        return gameMode == null ? class_1934.field_9215 : gameMode.method_2920();
    }

    public static boolean hasAccessibilityMod() {
        return hasAccessibilityMod;
    }

    @Nullable
    public static <IN, OUT> List<ClientViewGroup<OUT>> mapToClientGroups(Accessor<?> accessor, class_2960 key, class_9139<class_9129, Map.Entry<class_2960, List<ViewGroup<IN>>>> codec, Function<class_2960, IClientExtensionProvider<IN, OUT>> mapper, ITooltip tooltip) {
        class_2520 tag = accessor.getServerData().method_10580(key.toString());
        if (tag == null) {
            return null;
        }
        Map.Entry entry = accessor.decodeFromNbt(codec, tag).orElse(null);
        if (entry == null) {
            return null;
        }
        IClientExtensionProvider<IN, OUT> provider = mapper.apply((class_2960)entry.getKey());
        if (provider == null) {
            return null;
        }
        try {
            return provider.getClientGroups(accessor, (List)entry.getValue());
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip::add);
            return null;
        }
    }

    public static float getEnchantPowerBonus(class_2680 state, class_1937 world, class_2338 pos) {
        if (WailaClientRegistration.instance().customEnchantPowers.containsKey(state.method_26204())) {
            return WailaClientRegistration.instance().customEnchantPowers.get(state.method_26204()).getEnchantPowerBonus(state, world, pos);
        }
        return state.method_26164(class_3481.field_44472) ? 1.0f : 0.0f;
    }

    public static void sendPacket(class_8710 payload) {
        ClientPlayNetworking.send((class_8710)payload);
    }

    public static String lookupPlayerName(UUID uuid) {
        return AnimalOwnerProvider.lookupPlayerName(uuid, class_310.method_1551().method_73361());
    }

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(mc -> CommonProxy.loadComplete());
        ClientEntityEvents.ENTITY_LOAD.register(ClientProxy::onEntityJoin);
        ClientEntityEvents.ENTITY_UNLOAD.register(ClientProxy::onEntityLeave);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientProxy::onPlayerLeave);
        ClientTickEvents.END_CLIENT_TICK.register(ClientProxy::onClientTick);
        ClientTickEvents.END_CLIENT_TICK.register(ClientProxy::onKeyPressed);
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ClientProxy.onGui(screen));
        ClientCommandRegistrationCallback.EVENT.register(ClientProxy::registerClientCommand);
        HudElementRegistry.addLast((class_2960)JadeIds.UI_MAIN, (guiGraphics, deltaTracker) -> {
            if (class_310.method_1551().field_1755 == null) {
                ClientProxy.onRenderTick(guiGraphics, deltaTracker.method_60638());
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (ClientProxy.shouldShowAfterGui(client, screen)) {
                ScreenEvents.afterRender((class_437)screen).register((screen1, guiGraphics, mouseX, mouseY, tickDelta) -> ClientProxy.onRenderTick(guiGraphics, tickDelta));
            } else if (ClientProxy.shouldShowBeforeGui(client, screen)) {
                ScreenEvents.beforeRender((class_437)screen).register((screen1, guiGraphics, mouseX, mouseY, tickDelta) -> ClientProxy.onRenderTick(guiGraphics, tickDelta));
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ClientPlayNetworking.send((class_8710)new ClientHandshakePacket("9")));
        ClientPlayNetworking.registerGlobalReceiver(ReceiveDataPacket.TYPE, (payload, context) -> ReceiveDataPacket.handle(payload, arg_0 -> ((class_310)context.client()).execute(arg_0)));
        ClientPlayNetworking.registerGlobalReceiver(ServerHandshakePacket.TYPE, (payload, context) -> ServerHandshakePacket.handle(payload, arg_0 -> ((class_310)context.client()).execute(arg_0)));
        ClientPlayNetworking.registerGlobalReceiver(ShowOverlayPacket.TYPE, (payload, context) -> ShowOverlayPacket.handle(payload, arg_0 -> ((class_310)context.client()).execute(arg_0)));
        for (int i = 320; i <= 329; ++i) {
            class_3675.class_306 key = class_3675.class_307.field_1668.method_1447(i);
            ((KeyAccess)key).setDisplayName((class_3528<class_2561>)new class_3528(() -> class_2561.method_43471((String)key.method_1441())));
        }
        JadeClient.init();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)HarvestToolProvider.INSTANCE);
        CommonLifecycleEvents.TAGS_LOADED.register((registryAccess, client) -> HarvestToolProvider.INSTANCE.invalidateCache());
        JadeClient.recipeLookupPlugins.add(new PolydexCompat());
        if (CommonProxy.isModLoaded("roughlyenoughitems")) {
            JadeClient.addRecipeLookupPlugin("snownee.jade.compat.REICompat");
        }
        if (CommonProxy.isModLoaded("jei")) {
            JadeClient.addRecipeLookupPlugin("snownee.jade.compat.JEICompat");
        }
    }
}

