/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui;

import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigEntry;
import io.github.jamalam360.jamlib.client.gui.WidgetList;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.config.HiddenInGui;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8662;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ConfigScreen<T>
extends class_437 {
    protected final ConfigManager<T> manager;
    private final class_437 parent;
    private final List<ConfigEntry<T, ?>> entries;
    private WidgetList widgetList;
    private class_4185 doneButton;

    public ConfigScreen(ConfigManager<T> manager, class_437 parent) {
        super(ConfigScreen.createTitle(manager));
        this.manager = manager;
        this.parent = parent;
        this.entries = new ArrayList();
    }

    @ApiStatus.Internal
    public static String createTranslationKey(String modId, String configName, String path) {
        if (modId.equals(configName)) {
            return "config." + modId + "." + path;
        }
        return "config." + modId + "." + configName + "." + path;
    }

    protected static class_2561 createTitle(ConfigManager<?> manager) {
        String translationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), "title");
        if (class_1074.method_4663((String)translationKey)) {
            return class_2561.method_43471((String)translationKey);
        }
        return class_2561.method_43470((String)Platform.getMod((String)manager.getModId()).getName());
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> {
            this.manager.reloadFromDisk();
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }).method_46433(this.field_22789 / 2 - 154, this.field_22790 - 28).method_46437(150, 20).method_46431());
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            if (this.hasChanges()) {
                this.manager.save();
            }
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }).method_46433(this.field_22789 / 2 + 4, this.field_22790 - 28).method_46437(150, 20).method_46431());
        class_8662 editManuallyButton = (class_8662)this.method_37063((class_364)class_8662.method_52723((class_2561)class_2561.method_43471((String)"config.jamlib.edit_manually"), button -> {
            if (this.hasChanges()) {
                this.manager.save();
            }
            class_156.method_668().method_672(Platform.getConfigFolder().resolve(this.manager.getConfigName() + ".json5").toFile());
            Objects.requireNonNull(this.field_22787).method_1507(this.parent);
        }, (boolean)true).method_52727(JamLib.id("writable_book"), 16, 16).method_52726(20, 20).method_52724());
        editManuallyButton.method_46421(7);
        editManuallyButton.method_46419(7);
        this.widgetList = new WidgetList(this.field_22787, this.field_22789, this.field_22790 - 64, 32);
        if (this.entries.isEmpty()) {
            for (Field field : this.manager.getConfigClass().getFields()) {
                if (field.isAnnotationPresent(HiddenInGui.class)) continue;
                this.entries.add(ConfigEntry.createFromField(this.manager.getModId(), this.manager.getConfigName(), field));
            }
        }
        for (ConfigEntry configEntry : this.entries) {
            this.widgetList.addWidgetGroup(configEntry.createWidgets(this.field_22789));
        }
        this.method_37063((class_364)this.widgetList);
        T t = this.manager.get();
        if (t instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)t;
            List<ConfigExtensions.Link> list = ext.getLinks();
            for (int i = 0; i < list.size(); ++i) {
                ConfigExtensions.Link link = list.get(i);
                class_8662 linkButton = (class_8662)this.method_37063((class_364)class_8662.method_52723((class_2561)link.getTooltip(), button -> {
                    try {
                        class_156.method_668().method_673(link.getUrl().toURI());
                    }
                    catch (Exception e) {
                        JamLib.LOGGER.error("Failed to open link", (Throwable)e);
                    }
                }, (boolean)true).method_52727(link.getTexture(), 16, 16).method_52726(20, 20).method_52724());
                linkButton.method_46421(this.field_22789 - 30 - 28 * i);
                linkButton.method_46419(5);
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(class_310.method_1551().field_1772, this.field_22785, this.field_22789 / 2, 12, -1);
    }

    private boolean canExit() {
        return this.entries.stream().allMatch(ConfigEntry::isValid);
    }

    private boolean hasChanges() {
        return this.entries.stream().anyMatch(ConfigEntry::hasChanged);
    }

    public void method_25393() {
        super.method_25393();
        boolean canExit = this.canExit();
        if (this.doneButton.field_22763 != canExit) {
            this.doneButton.field_22763 = canExit;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            ConfigEntry<T, ?> entry = this.entries.get(i);
            List<class_339> widgets = entry.getNewWidgets(this.field_22789);
            if (widgets == null) continue;
            this.widgetList.updateWidgetGroup(i, widgets);
        }
    }
}

