/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.gui;

import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.api.ModContext;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import squeek.appleskin.ModConfig;

public class ConfiguredConfigProvider
implements IModConfigProvider {
    private static final ModConfig DEFAULTS = new ModConfig();

    public Set<IModConfig> getConfigurationsForMod(ModContext modContext) {
        if (FabricLoader.getInstance().isModLoaded("cloth-config")) {
            return Set.of();
        }
        if (!modContext.modId().equals("appleskin")) {
            return Set.of();
        }
        return Set.of(new ConfiguredModConfig());
    }

    private static <T> T asT(Object val) {
        if (val instanceof Float) {
            return (T)((Float)val).toString();
        }
        return (T)val;
    }

    private static <T> Object fromT(T val) {
        if (val instanceof String) {
            return Float.valueOf((String)val);
        }
        return val;
    }

    protected static class ConfiguredModConfig
    implements IModConfig {
        List<IConfigEntry> options = List.of(new LeafEntry("showFoodValuesInTooltip"), new LeafEntry("showFoodValuesInTooltipAlways"), new LeafEntry("showSaturationHudOverlay"), new LeafEntry("showFoodValuesHudOverlay"), new LeafEntry("showFoodValuesHudOverlayWhenOffhand"), new LeafEntry("showFoodExhaustionHudUnderlay"), new LeafEntry("showFoodHealthHudOverlay"), new LeafEntry("showVanillaAnimationsOverlay"), new LeafEntry("maxHudOverlayFlashAlpha"));

        public ConfigType getType() {
            return ConfigType.CLIENT;
        }

        public boolean isChanged() {
            return true;
        }

        public String getFileName() {
            return "appleskin.json5";
        }

        public String getModId() {
            return "appleskin";
        }

        public IConfigEntry createRootEntry() {
            return new RootEntry(this.options);
        }

        public ActionResult update(IConfigEntry entry) {
            for (IConfigEntry option : entry.getChildren()) {
                IConfigValue configValue = option.getValue();
                assert (configValue != null);
                Object value = ConfiguredConfigProvider.fromT(configValue.get());
                try {
                    Field field = ModConfig.class.getDeclaredField(configValue.getName());
                    field.set(ModConfig.INSTANCE, value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                ModConfig.INSTANCE.save();
                return ActionResult.success();
            }
            catch (Exception e) {
                return ActionResult.fail((class_2561)class_2561.method_30163((String)e.getMessage()));
            }
        }

        public ActionResult canPlayerEdit(@Nullable class_1657 player) {
            return ActionResult.success();
        }

        @Nullable
        public String getTranslationKey() {
            return "text.autoconfig.appleskin.title";
        }

        public void startEditing() {
            for (IConfigEntry option : this.options) {
                IConfigValue value = option.getValue();
                assert (value != null);
                value.cleanCache();
            }
        }
    }

    protected static class FloatVal<T>
    extends SimpleValue<T> {
        protected FloatVal(String name, T initValue, T defaultValue) {
            super(name, initValue, defaultValue);
        }

        @Override
        public boolean isValid(T value) {
            try {
                float floatVal = Float.parseFloat((String)value);
                return floatVal >= 0.0f && floatVal <= 1.0f;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        @Nullable
        public class_2561 getValidationHint() {
            return class_2561.method_43469((String)"configured.validator.range_hint", (Object[])new Object[]{"0.0", "1.0"});
        }
    }

    protected static class SimpleValue<T>
    implements IConfigValue<T> {
        private final String name;
        private T value;
        private T initValue;
        private final T defaultValue;

        protected SimpleValue(String name, T initValue, T defaultValue) {
            this.name = name;
            this.value = initValue;
            this.initValue = initValue;
            this.defaultValue = defaultValue;
        }

        public T get() {
            return this.value;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public void set(T value) {
            this.value = value;
        }

        public boolean isValid(T value) {
            return true;
        }

        public boolean isDefault() {
            return this.value.equals(this.defaultValue);
        }

        public boolean isChanged() {
            return !this.value.equals(this.initValue);
        }

        public void restore() {
            this.value = this.defaultValue;
        }

        @Nullable
        public class_2561 getComment() {
            return class_2561.method_43471((String)(this.getTranslationKey() + ".@Tooltip"));
        }

        @Nullable
        public String getTranslationKey() {
            return "text.autoconfig.appleskin.option." + this.name;
        }

        @Nullable
        public class_2561 getValidationHint() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void cleanCache() {
            try {
                this.value = ConfiguredConfigProvider.asT(ModConfig.class.getDeclaredField(this.name).get(ModConfig.INSTANCE));
                this.initValue = this.value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public boolean requiresWorldRestart() {
            return false;
        }

        public boolean requiresGameRestart() {
            return false;
        }
    }

    protected static class LeafEntry<T>
    implements IConfigEntry {
        private final String name;
        private final IConfigValue<T> value;

        protected LeafEntry(String name) {
            Object defaultValue;
            Object value;
            this.name = name;
            try {
                value = ConfiguredConfigProvider.asT(ModConfig.class.getDeclaredField(this.name).get(ModConfig.INSTANCE));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                defaultValue = ConfiguredConfigProvider.asT(ModConfig.class.getDeclaredField(this.name).get(DEFAULTS));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Object t = value;
            Objects.requireNonNull(t);
            Object t2 = t;
            int n = 0;
            this.value = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, t2, n)) {
                case 0 -> {
                    String s = (String)t2;
                    yield new FloatVal(this.name, value, defaultValue);
                }
                default -> new SimpleValue(this.name, value, defaultValue);
            };
        }

        public List<IConfigEntry> getChildren() {
            return List.of();
        }

        public boolean isRoot() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        @Nullable
        public IConfigValue<T> getValue() {
            return this.value;
        }

        public String getEntryName() {
            return this.name;
        }

        @Nullable
        public class_2561 getTooltip() {
            return class_2561.method_43471((String)(this.getTranslationKey() + ".@Tooltip"));
        }

        @Nullable
        public String getTranslationKey() {
            return "text.autoconfig.appleskin.option." + this.name;
        }
    }

    protected static class RootEntry
    implements IConfigEntry {
        List<IConfigEntry> children;

        public RootEntry(List<IConfigEntry> options) {
            this.children = options;
        }

        public List<IConfigEntry> getChildren() {
            return this.children;
        }

        public boolean isRoot() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        @Nullable
        public IConfigValue<?> getValue() {
            return null;
        }

        public String getEntryName() {
            return "";
        }

        @Nullable
        public class_2561 getTooltip() {
            return null;
        }

        @Nullable
        public String getTranslationKey() {
            return null;
        }
    }
}

