/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv;

import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.compat.eiv.RecipeButton;
import com.zurrtum.create.client.compat.eiv.RecipeTransferHandler;
import com.zurrtum.create.client.content.logistics.stockTicker.CraftableBigItemStack;
import com.zurrtum.create.client.content.logistics.stockTicker.CraftableInput;
import com.zurrtum.create.client.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.mixin.CraftingViewRecipeAccessor;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import de.crafty.eiv.common.recipe.item.FluidItem;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class StockKeeperTransferHandler
implements RecipeTransferHandler {
    @Override
    public boolean checkApplicable(class_437 screen) {
        return screen instanceof StockKeeperRequestScreen;
    }

    @Override
    public boolean handle(class_437 currentScreen, IEivViewRecipe current, RecipeButton button, boolean craft) {
        CraftableInput inputs;
        class_2960 id = null;
        class_1799 output = null;
        for (Object result : current.getResults()) {
            for (class_1799 stack : result.getValidContents()) {
                if (stack.method_7909() instanceof FluidItem) {
                    return false;
                }
                if (stack.method_7960()) continue;
                id = class_2960.method_60655((String)"create", (String)("result_" + result.hashCode()));
                output = stack;
            }
        }
        if (output == null) {
            button.setTooltip((class_2561)CreateLang.translateDirect("gui.stock_keeper.recipe_result_empty", new Object[0]));
            return false;
        }
        StockKeeperRequestScreen screen = (StockKeeperRequestScreen)currentScreen;
        for (CraftableBigItemStack cbis : screen.recipesToOrder) {
            if (!cbis.id.equals(id)) continue;
            button.setTooltip((class_2561)CreateLang.translateDirect("gui.stock_keeper.already_ordering_recipe", new Object[0]));
            return false;
        }
        if (screen.itemsToOrder.size() >= 9) {
            button.setTooltip((class_2561)CreateLang.translateDirect("gui.stock_keeper.slots_full", new Object[0]));
            return false;
        }
        if (current instanceof CraftingViewRecipeAccessor) {
            CraftingViewRecipeAccessor accessor = (CraftingViewRecipeAccessor)current;
            inputs = CraftableInput.create(true);
            HashMap<Integer, SlotContent> ingredientSlotContents = accessor.getIngredientSlotContents();
            for (i = 0; i < 9; ++i) {
                List contents;
                int size;
                SlotContent ingredient = ingredientSlotContents.get(i);
                if (ingredient == null || (size = (contents = ingredient.getValidContents()).size()) == 0) continue;
                if (size == 1) {
                    class_1799 stack = (class_1799)contents.getFirst();
                    if (stack.method_7909() instanceof FluidItem) {
                        return false;
                    }
                    inputs.add(List.of(StockKeeperTransferHandler.getRawStack(stack)), i);
                    continue;
                }
                ArrayList<class_1799> items = new ArrayList<class_1799>(size);
                for (class_1799 stack : contents) {
                    if (stack.method_7909() instanceof FluidItem) {
                        return false;
                    }
                    items.add(StockKeeperTransferHandler.getRawStack(stack));
                }
                inputs.add(items, i);
            }
        } else {
            inputs = CraftableInput.create(false);
            List ingredients = current.getIngredients();
            int ingredientSize = ingredients.size();
            for (i = 0; i < ingredientSize; ++i) {
                SlotContent ingredient = (SlotContent)ingredients.get(i);
                List contents = ingredient.getValidContents();
                int size = contents.size();
                if (size == 0) continue;
                if (size == 1) {
                    class_1799 stack = (class_1799)contents.getFirst();
                    if (stack.method_7909() instanceof FluidItem) {
                        return false;
                    }
                    inputs.add(List.of(StockKeeperTransferHandler.getRawStack(stack)), i);
                    continue;
                }
                ArrayList<class_1799> items = new ArrayList<class_1799>(size);
                for (class_1799 stack : contents) {
                    if (stack.method_7909() instanceof FluidItem) {
                        return false;
                    }
                    items.add(StockKeeperTransferHandler.getRawStack(stack));
                }
                inputs.add(items, i);
            }
        }
        if (inputs.data().size() > 9) {
            return false;
        }
        InventorySummary summary = ((StockTickerBlockEntity)((StockKeeperRequestMenu)screen.method_17577()).contentHolder).getLastClientsideStockSnapshotAsSummary();
        if (summary == null) {
            return false;
        }
        IntSet missingIndices = inputs.getMissing(summary.getStacksByCount());
        if (!missingIndices.isEmpty()) {
            button.updateMissing(missingIndices, (class_2561)CreateLang.translateDirect("gui.stock_keeper.not_in_stock", new Object[0]));
            return false;
        }
        if (craft) {
            CraftableBigItemStack cbis = new CraftableBigItemStack(id, inputs, output);
            screen.recipesToOrder.add(cbis);
            screen.searchBox.method_1852("");
            screen.refreshSearchNextTick = true;
            screen.requestCraftable(cbis, AllKeys.hasShiftDown() ? cbis.stack.method_7914() : 1);
        }
        button.setSuccess();
        return true;
    }

    private static class_1799 getRawStack(class_1799 stack) {
        class_2487 nbt;
        class_9279 custom = (class_9279)stack.method_58694(class_9334.field_49628);
        if (custom != null && !custom.method_57458() && (nbt = custom.method_57461()).method_10545("eiv_recipeTag")) {
            stack = stack.method_7972();
            if (nbt.method_10546() == 1) {
                stack.method_57381(class_9334.field_49628);
            } else {
                nbt.method_10551("eiv_recipeTag");
                stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
            }
        }
        return stack;
    }
}

