/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.elevator;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.pulley.AbstractPulleyRenderer;
import com.zurrtum.create.client.content.contraptions.pulley.PulleyRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlock;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ElevatorPulleyRenderer
extends KineticBlockEntityRenderer<ElevatorPulleyBlockEntity, ElevatorPulleyRenderState> {
    public ElevatorPulleyRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public ElevatorPulleyRenderState createRenderState() {
        return new ElevatorPulleyRenderState();
    }

    @Override
    public void extractRenderState(ElevatorPulleyBlockEntity be, ElevatorPulleyRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1937 world = be.method_10997();
        class_2680 blockState = be.method_11010();
        float offset = PulleyRenderer.getBlockEntityOffset(tickProgress, be);
        boolean running = PulleyRenderer.isPulleyRunning(be);
        state.yRot = (float)Math.PI / 180 * (180.0f + AngleHelper.horizontalAngle((class_2350)blockState.method_11654((class_2769)ElevatorPulleyBlock.HORIZONTAL_FACING)));
        if (running || offset == 0.0f) {
            state.magnet = CachedBuffers.partial(AllPartialModels.ELEVATOR_MAGNET, blockState);
            state.magnetOffset = -offset;
            state.magnetLight = class_761.method_23794((class_1920)world, (class_2338)state.field_62673.method_10087((int)offset));
        }
        state.rotatedCoil = this.getRotatedCoil(be);
        if (offset == 0.0f) {
            return;
        }
        state.coilShift = AllSpriteShifts.ELEVATOR_COIL;
        state.coilScroll = AbstractPulleyRenderer.getCoilVScroll(state.coilShift, offset, 2.0f);
        float f = offset % 1.0f;
        if (f < 0.25f || f > 0.75f) {
            state.halfRope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT_HALF, blockState);
            ElevatorPulleyRenderer.updateHalfShift(state, offset);
            float down = f > 0.75f ? f - 1.0f : f;
            state.halfRopeOffset = -down;
            state.halfRopeLight = class_761.method_23794((class_1920)world, (class_2338)state.field_62673.method_10087((int)down));
        }
        if (!running) {
            return;
        }
        if (state.halfRope == null) {
            ElevatorPulleyRenderer.updateHalfShift(state, offset);
        }
        state.rope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT, blockState);
        int size = (int)Math.ceil(offset - 0.25f);
        float[] offsets = new float[size];
        int[] lights = new int[size];
        for (int i = 0; i < size; ++i) {
            float down = offset - (float)i;
            int light = class_761.method_23794((class_1920)world, (class_2338)state.field_62673.method_10087((int)down));
            offsets[i] = -down;
            lights[i] = light;
        }
        state.offsets = offsets;
        state.lights = lights;
    }

    @Override
    public void submit(ElevatorPulleyRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
    }

    private static void updateHalfShift(ElevatorPulleyRenderState state, float offset) {
        state.halfShift = AllSpriteShifts.ELEVATOR_BELT;
        double beltScroll = (-((double)offset + 0.5) - Math.floor(-((double)offset + 0.5))) / 2.0;
        class_1058 target = state.halfShift.getTarget();
        float spriteSize = target.method_4575() - target.method_4593();
        state.halfScroll = (float)beltScroll * spriteSize;
    }

    @Override
    protected class_1921 getRenderType(ElevatorPulleyBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    @Override
    protected class_2680 getRenderedBlockState(ElevatorPulleyBlockEntity be) {
        return ElevatorPulleyRenderer.shaft(ElevatorPulleyRenderer.getRotationAxisOf(be));
    }

    protected SuperByteBuffer getRotatedCoil(KineticBlockEntity be) {
        class_2680 blockState = be.method_11010();
        return CachedBuffers.partialFacing(AllPartialModels.ELEVATOR_COIL, blockState, (class_2350)blockState.method_11654((class_2769)ElevatorPulleyBlock.HORIZONTAL_FACING));
    }

    public boolean method_3563() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ElevatorPulleyRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public float yRot;
        public SuperByteBuffer magnet;
        public float magnetOffset;
        public int magnetLight;
        public SuperByteBuffer rotatedCoil;
        public SpriteShiftEntry coilShift;
        public float coilScroll;
        public SuperByteBuffer halfRope;
        public SpriteShiftEntry halfShift;
        public float halfScroll;
        public float halfRopeOffset;
        public int halfRopeLight;
        public SuperByteBuffer rope;
        public float[] offsets;
        public int[] lights;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            if (this.magnet != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.magnet.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, this.magnetOffset, 0.0f)).light(this.magnetLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.coilScroll != 0.0f) {
                this.rotatedCoil.shiftUVScrolling(this.coilShift, this.coilScroll);
            }
            this.rotatedCoil.light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            if (this.halfRope != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.halfRope.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, this.halfRopeOffset, 0.0f)).shiftUVScrolling(this.halfShift, this.halfScroll).light(this.halfRopeLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.rope != null) {
                int size = this.offsets.length;
                for (int i = 0; i < size; ++i) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.rope.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, this.offsets[i], 0.0f)).shiftUVScrolling(this.halfShift, this.halfScroll).light(this.lights[i]).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}

