/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_897;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class ContraptionEntityRenderer<C extends AbstractContraptionEntity, S extends AbstractContraptionState>
extends class_897<C, S> {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, class_11515>> CONTRAPTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final class_4587 matrixStack = new class_4587();

    public ContraptionEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public static SuperByteBuffer getBuffer(Contraption contraption, ClientContraption clientContraption, VirtualRenderWorld renderWorld, class_11515 renderType) {
        return SuperByteBufferCache.getInstance().get(CONTRAPTION, Pair.of((Object)contraption, (Object)renderType), () -> ContraptionEntityRenderer.buildStructureBuffer(clientContraption, renderWorld, renderType));
    }

    public ClientContraption getOrCreateClientContraptionLazy(Contraption contraption) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption out = (ClientContraption)clientContraption.getAcquire();
        if (out == null) {
            clientContraption.compareAndExchangeRelease(null, this.createClientContraption(contraption));
            out = (ClientContraption)clientContraption.getAcquire();
        }
        return out;
    }

    protected ClientContraption createClientContraption(Contraption contraption) {
        return new ClientContraption(contraption);
    }

    private static SuperByteBuffer buildStructureBuffer(ClientContraption clientContraption, VirtualRenderWorld renderWorld, class_11515 layer) {
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.poseStack;
        class_5819 random = objects.random;
        ClientContraption.RenderedBlocks blocks = clientContraption.getRenderedBlocks();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        class_778.method_20544();
        for (class_2338 pos : blocks.positions()) {
            class_2680 state = blocks.lookup().apply(pos);
            if (state.method_26217() != class_2464.field_11458) continue;
            class_1087 model = dispatcher.method_3349(state);
            long randomSeed = state.method_26190(pos);
            random.method_43052(randomSeed);
            if (class_4696.method_23679((class_2680)state) != layer) continue;
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            ObjectArrayList parts = new ObjectArrayList();
            class_1087 class_10872 = WrapperBlockStateModel.unwrapCompat(model);
            if (class_10872 instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)class_10872;
                wrapper.addPartsWithInfo((class_1920)renderWorld, pos, state, random, (List<class_10889>)parts);
            } else {
                model.method_68513(random, (List)parts);
            }
            renderer.method_3374((class_1920)renderWorld, (List)parts, state, pos, poseStack, (class_4588)sbbBuilder, true, class_4608.field_21444);
            poseStack.method_22909();
        }
        class_778.method_20545();
        return sbbBuilder.end();
    }

    public boolean shouldRender(C entity, class_4604 frustum, double cameraX, double cameraY, double cameraZ) {
        if (((AbstractContraptionEntity)((Object)entity)).getContraption() == null) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isAliveOrStale()) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isReadyForRender()) {
            return false;
        }
        return super.method_3933(entity, frustum, cameraX, cameraY, cameraZ);
    }

    public S createRenderState() {
        return (S)((Object)new AbstractContraptionState());
    }

    public void extractRenderState(C entity, S state, float tickProgress) {
        ClientContraption clientContraption;
        ((AbstractContraptionState)((Object)state)).field_58171 = entity.method_5864();
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        ClientContraption clientContraption2 = clientContraption = contraption != null ? this.getOrCreateClientContraptionLazy(contraption) : null;
        if (clientContraption == null) {
            return;
        }
        class_4184 camera = this.field_4676.field_4686;
        if (camera == null) {
            return;
        }
        ((AbstractContraptionState)((Object)state)).contraption = contraption;
        ((AbstractContraptionState)((Object)state)).field_53325 = class_3532.method_16436((double)tickProgress, (double)((AbstractContraptionEntity)((Object)entity)).field_6038, (double)entity.method_23317());
        ((AbstractContraptionState)((Object)state)).field_53326 = class_3532.method_16436((double)tickProgress, (double)((AbstractContraptionEntity)((Object)entity)).field_5971, (double)entity.method_23318());
        ((AbstractContraptionState)((Object)state)).field_53327 = class_3532.method_16436((double)tickProgress, (double)((AbstractContraptionEntity)((Object)entity)).field_5989, (double)entity.method_23321());
        this.matrixStack.method_22903();
        this.transform(state, this.matrixStack);
        ((AbstractContraptionState)((Object)state)).modelEntry = this.matrixStack.method_23760().method_56822();
        this.matrixStack.method_22909();
        class_1937 world = entity.method_73183();
        VirtualRenderWorld renderWorld = clientContraption.getRenderLevel();
        Matrix4f worldMatrix4f = new Matrix4f().setTranslation((float)((AbstractContraptionState)((Object)state)).field_53325, (float)((AbstractContraptionState)((Object)state)).field_53326, (float)((AbstractContraptionState)((Object)state)).field_53327);
        boolean support = VisualizationManager.supportsVisualization((class_1936)world);
        if (!support) {
            ((AbstractContraptionState)((Object)state)).layers = ContraptionEntityRenderer.createLayers(contraption, clientContraption, renderWorld, world, worldMatrix4f);
        }
        BitSet adjustRenderedBlockEntities = clientContraption.getAndAdjustShouldRenderBlockEntities();
        clientContraption.scratchErroredBlockEntities.clear();
        class_243 cameraPos = camera.method_71156();
        Matrix4f lightTransform = worldMatrix4f.mul((Matrix4fc)((AbstractContraptionState)((Object)state)).modelEntry.method_23761(), new Matrix4f());
        ((AbstractContraptionState)((Object)state)).blockEntity = BlockEntityRenderHelper.getBlockEntitiesRenderState(support, clientContraption.renderedBlockEntityView, adjustRenderedBlockEntities, clientContraption.scratchErroredBlockEntities, renderWorld, world, lightTransform, contraption.entity.toLocalVector(cameraPos, tickProgress), tickProgress);
        clientContraption.shouldRenderBlockEntities.andNot(clientContraption.scratchErroredBlockEntities);
        ((AbstractContraptionState)((Object)state)).actors = ContraptionEntityRenderer.createActors(cameraPos, this.method_3932(), world, renderWorld, contraption, worldMatrix4f);
    }

    public void submit(S state, class_4587 poseStack, class_11659 queue, class_12075 cameraRenderState) {
        if (((AbstractContraptionState)((Object)state)).contraption == null) {
            return;
        }
        poseStack.method_22903();
        class_4587.class_4665 entry = poseStack.method_23760();
        entry.method_23761().mul((Matrix4fc)((AbstractContraptionState)((Object)state)).modelEntry.method_23761());
        entry.method_23762().mul((Matrix3fc)((AbstractContraptionState)((Object)state)).modelEntry.method_23762());
        if (((AbstractContraptionState)((Object)state)).layers != null) {
            for (ContraptionBlockLayer layer : ((AbstractContraptionState)((Object)state)).layers) {
                queue.method_73483(poseStack, layer.renderLayer, (class_11659.class_11660)layer);
            }
        }
        if (((AbstractContraptionState)((Object)state)).blockEntity != null) {
            ((AbstractContraptionState)((Object)state)).blockEntity.render(poseStack, queue, cameraRenderState);
        }
        if (((AbstractContraptionState)((Object)state)).actors != null) {
            for (MovementRenderState actor : ((AbstractContraptionState)((Object)state)).actors) {
                poseStack.method_22903();
                actor.transform(poseStack);
                actor.render(poseStack, queue);
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    public void transform(S state, class_4587 matrixStack) {
    }

    @Nullable
    public static List<ContraptionBlockLayer> createLayers(Contraption contraption, ClientContraption clientContraption, VirtualRenderWorld renderWorld, class_1937 world, Matrix4f lightTransform) {
        ArrayList<ContraptionBlockLayer> layers = new ArrayList<ContraptionBlockLayer>();
        for (class_11515 blockLayer : class_11515.values()) {
            SuperByteBuffer buffer = ContraptionEntityRenderer.getBuffer(contraption, clientContraption, renderWorld, blockLayer);
            if (buffer.isEmpty()) continue;
            layers.add(new ContraptionBlockLayer(ContraptionEntityRenderer.getRenderLayer(blockLayer), buffer, world, lightTransform));
        }
        if (layers.isEmpty()) {
            return null;
        }
        return layers;
    }

    private static class_1921 getRenderLayer(class_11515 layer) {
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case class_11515.field_60923 -> class_12249.method_75965();
            case class_11515.field_60925 -> class_12249.method_75972();
            case class_11515.field_60926 -> class_12249.method_75977();
            case class_11515.field_60927 -> class_12249.method_76009();
        };
    }

    @Nullable
    public static List<MovementRenderState> createActors(class_243 camera, class_327 textRenderer, class_1937 world, VirtualRenderWorld renderWorld, Contraption contraption, Matrix4f worldMatrix4f) {
        ArrayList<MovementRenderState> actors = new ArrayList<MovementRenderState>();
        for (Pair pair : contraption.getActors()) {
            MovementRenderState renderState;
            MovementRenderBehaviour render;
            MovementBehaviour movementBehaviour;
            MovementContext context = (MovementContext)pair.getRight();
            if (context == null) continue;
            if (context.world == null) {
                context.world = world;
            }
            if ((movementBehaviour = MovementBehaviour.REGISTRY.get((class_2688<class_2248, ?>)context.state)) == null || (render = (MovementRenderBehaviour)movementBehaviour.getAttachRender()) == null || contraption.isHiddenInPortal(context.localPos) || (renderState = render.getRenderState(camera, textRenderer, context, renderWorld, worldMatrix4f)) == null) continue;
            actors.add(renderState);
        }
        if (actors.isEmpty()) {
            return null;
        }
        return actors;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ThreadLocalObjects {
        public final class_4587 poseStack = new class_4587();
        public final class_5819 random = class_5819.method_43053();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AbstractContraptionState
    extends class_10017 {
        public Contraption contraption;
        public class_4587.class_4665 modelEntry;
        public List<ContraptionBlockLayer> layers;
        public BlockEntityRenderHelper.BlockEntityListRenderState blockEntity;
        @Nullable
        public List<MovementRenderState> actors;
    }

    @Environment(value=EnvType.CLIENT)
    public record ContraptionBlockLayer(class_1921 renderLayer, SuperByteBuffer buffer, class_1937 world, Matrix4f lightTransform) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.buffer.useLevelLight((class_1920)this.world, this.lightTransform).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

