/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.spout;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.fluids.spout.SpoutBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SpoutRenderer
implements class_827<SpoutBlockEntity, SpoutRenderState> {
    public SpoutRenderer(class_5614.class_5615 context) {
    }

    public SpoutRenderState createRenderState() {
        return new SpoutRenderState();
    }

    public void extractRenderState(SpoutBlockEntity be, SpoutRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null) {
            return;
        }
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float radius = 0.0f;
        int processingTicks = be.processingTicks;
        float processingPT = (float)processingTicks - tickProgress;
        if (!fluidStack.isEmpty()) {
            float level = primaryTank.getFluidLevel().getValue(tickProgress);
            if (level != 0.0f) {
                boolean top = false;
                float min = 0.15625f;
                float n = 0.6875f;
                float max = min + n;
                float yOffset = n * Math.max(level, 0.175f);
                float yMin = min - yOffset;
                float offset = top ? max - min : yOffset;
                state.fluid = new FluidRenderState(class_12249.method_75977(), fluidStack.getFluid(), fluidStack.getComponentChanges(), min, max, yMin, offset, state.field_62676);
            }
            if (processingTicks != -1) {
                float processingProgress = 1.0f - (processingPT - 5.0f) / 10.0f;
                processingProgress = class_3532.method_15363((float)processingProgress, (float)0.0f, (float)1.0f);
                radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
                class_238 box = new class_238(0.5, 0.0, 0.5, 0.5, -1.2, 0.5).method_1014((double)(radius / 32.0f));
                state.process = new ProcessRenderState(class_12249.method_75977(), fluidStack.getFluid(), fluidStack.getComponentChanges(), box, state.field_62676);
            }
        }
        float squeeze = processingPT < 0.0f ? 0.0f : (processingPT < 2.0f ? (float)class_3532.method_48781((float)(processingPT / 2.0f), (int)0, (int)-1) : (processingPT < 10.0f ? -1.0f : radius));
        SuperByteBuffer top = CachedBuffers.partial(AllPartialModels.SPOUT_TOP, state.field_62674);
        SuperByteBuffer middle = CachedBuffers.partial(AllPartialModels.SPOUT_MIDDLE, state.field_62674);
        SuperByteBuffer bottom = CachedBuffers.partial(AllPartialModels.SPOUT_BOTTOM, state.field_62674);
        float offset = -3.0f * squeeze / 32.0f;
        state.bits = new BitsRenderState(class_12249.method_75965(), top, middle, bottom, offset, state.field_62676);
    }

    public void submit(SpoutRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.process != null) {
            queue.method_73483(matrices, state.process.layer, (class_11659.class_11660)state.process);
        }
        queue.method_73483(matrices, state.bits.layer, (class_11659.class_11660)state.bits);
        if (state.fluid != null) {
            matrices.method_46416(0.0f, state.fluid.offset, 0.0f);
            queue.method_73483(matrices, state.fluid.layer, (class_11659.class_11660)state.fluid);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SpoutRenderState
    extends class_11954 {
        public FluidRenderState fluid;
        public ProcessRenderState process;
        public BitsRenderState bits;
    }

    @Environment(value=EnvType.CLIENT)
    public record FluidRenderState(class_1921 layer, class_3611 fluid, class_9326 changes, float min, float max, float yMin, float offset, int light) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, this.min, this.yMin, this.min, this.max, this.min, this.max, vertexConsumer, matricesEntry, this.light, false, true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record ProcessRenderState(class_1921 layer, class_3611 fluid, class_9326 changes, class_238 box, int light) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(this.fluid, this.changes, (float)this.box.field_1323, (float)this.box.field_1322, (float)this.box.field_1321, (float)this.box.field_1320, (float)this.box.field_1325, (float)this.box.field_1324, vertexConsumer, matricesEntry, this.light, true, true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record BitsRenderState(class_1921 layer, SuperByteBuffer top, SuperByteBuffer middle, SuperByteBuffer bottom, float offset, int light) implements class_11659.class_11660
    {
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            this.top.light(this.light).renderInto(matricesEntry, vertexConsumer);
            matricesEntry.method_67796(0.0f, this.offset, 0.0f);
            this.middle.light(this.light).renderInto(matricesEntry, vertexConsumer);
            matricesEntry.method_67796(0.0f, this.offset, 0.0f);
            this.bottom.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

