/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.crank;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlock;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11683;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class HandCrankRenderer
extends KineticBlockEntityRenderer<HandCrankBlockEntity, HandCrankRenderState> {
    public HandCrankRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public HandCrankRenderState createRenderState() {
        return new HandCrankRenderState();
    }

    @Override
    public void extractRenderState(HandCrankBlockEntity be, HandCrankRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        if (this.shouldRenderShaft()) {
            super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
            if (state.support) {
                return;
            }
        } else {
            class_1937 world = be.method_10997();
            state.support = VisualizationManager.supportsVisualization((class_1936)world);
            if (state.support) {
                return;
            }
            this.updateBaseRenderState(be, state, world, crumblingOverlay);
        }
        state.handle = this.getRenderedHandle(state.field_62674);
        state.handleAngle = AngleHelper.rad(this.getIndependentAngle(be, tickProgress));
    }

    @Override
    protected class_1921 getRenderType(HandCrankBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    public float getIndependentAngle(HandCrankBlockEntity be, float partialTicks) {
        return HandCrankRenderer.getHandCrankIndependentAngle(be, partialTicks);
    }

    public static float getHandCrankIndependentAngle(HandCrankBlockEntity be, float partialTicks) {
        return be.independentAngle + partialTicks * be.chasingAngularVelocity;
    }

    public SuperByteBuffer getRenderedHandle(class_2680 blockState) {
        class_2350 facing = blockState.method_28500((class_2769)HandCrankBlock.FACING).orElse(class_2350.field_11036);
        return CachedBuffers.partialFacing(AllPartialModels.HAND_CRANK_HANDLE, blockState, facing.method_10153());
    }

    public boolean shouldRenderShaft() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class HandCrankRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer handle;
        public float handleAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            this.handle.light(this.field_62676);
            this.handle.rotateCentered(this.handleAngle, this.direction);
            this.handle.color(this.color);
            this.handle.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

