/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.backend.glsl.generate;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslBlock;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslExpr;
import com.zurrtum.create.client.flywheel.backend.glsl.generate.GlslStmt;
import com.zurrtum.create.client.flywheel.lib.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class GlslSwitch
implements GlslStmt {
    private final GlslExpr on;
    private final List<Pair<GlslExpr, GlslBlock>> cases = new ArrayList<Pair<GlslExpr, GlslBlock>>();
    @Nullable
    private GlslBlock defaultCase = null;

    private GlslSwitch(GlslExpr on) {
        this.on = on;
    }

    public static GlslSwitch on(GlslExpr on) {
        return new GlslSwitch(on);
    }

    public void intCase(int expr, GlslBlock block) {
        this.cases.add((Pair<GlslExpr, GlslBlock>)Pair.of((Object)GlslExpr.intLiteral(expr), (Object)block));
    }

    public void uintCase(int expr, GlslBlock block) {
        this.cases.add((Pair<GlslExpr, GlslBlock>)Pair.of((Object)GlslExpr.uintLiteral(expr), (Object)block));
    }

    public void defaultCase(GlslBlock block) {
        this.defaultCase = block;
    }

    @Override
    public String prettyPrint() {
        return "switch (%s) {\n%s\n}".formatted(this.on.prettyPrint(), this.formatCases());
    }

    private String formatCases() {
        Object cases = this.cases.stream().map(GlslSwitch::prettyPrintCase).collect(Collectors.joining("\n"));
        if (this.defaultCase != null) {
            cases = (String)cases + "\ndefault:\n" + StringUtil.indent(this.defaultCase.prettyPrint(), 4);
        }
        return cases;
    }

    private static String prettyPrintCase(Pair<GlslExpr, GlslBlock> p) {
        String variant = ((GlslExpr)p.getFirst()).prettyPrint();
        String block = ((GlslBlock)p.getSecond()).prettyPrint();
        return "case %s:\n%s".formatted(variant, StringUtil.indent(block, 4));
    }
}

