/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_12137;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_9326;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class SpoutRenderer
extends class_11239<SpoutRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public SpoutRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(SpoutRenderState item, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = 26 * windowScaleFactor;
        int height = 65 * windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(item.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(item.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.field_60042.method_71092((float)width, (float)height), (class_10366)class_10366.field_54954);
        texture.prepare();
        this.matrices.method_22903();
        this.matrices.method_46416((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        float scale = 20 * windowScaleFactor;
        this.matrices.method_22905(scale, scale, scale);
        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-15.5f));
        this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(22.5f));
        this.matrices.method_46416(-0.5f, -0.5f, -0.5f);
        this.matrices.method_22905(1.0f, -1.0f, 1.0f);
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = this.field_59933.method_73477(class_4722.method_24074());
        float time = AnimationTickHolder.getRenderTime();
        class_2680 blockState = AllBlocks.SPOUT.method_9564();
        world.blockState(blockState);
        List parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, (class_1920)world, this.matrices, buffer, false, parts);
        float cycle = (time - (float)(item.offset() * 8)) % 30.0f;
        float squeeze = cycle < 20.0f ? -class_3532.method_15374((double)((float)((double)(cycle / 20.0f) * Math.PI))) : 0.0f;
        float move = -3.0f * squeeze / 32.0f;
        blockState = class_2246.field_10124.method_9564();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.SPOUT_TOP.get());
        blockRenderManager.method_3355(blockState, class_2338.field_10980, (class_1920)world, this.matrices, buffer, false, parts);
        this.matrices.method_22903();
        parts = List.of(AllPartialModels.SPOUT_MIDDLE.get());
        this.matrices.method_46416(0.0f, move, 0.0f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, (class_1920)world, this.matrices, buffer, false, parts);
        parts = List.of(AllPartialModels.SPOUT_BOTTOM.get());
        this.matrices.method_46416(0.0f, move, 0.0f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, (class_1920)world, this.matrices, buffer, false, parts);
        this.matrices.method_22909();
        this.matrices.method_22903();
        blockState = AllBlocks.DEPOT.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        this.matrices.method_46416(0.07f, -2.0f, -0.14f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, (class_1920)world, this.matrices, buffer, false, parts);
        this.matrices.method_22909();
        this.matrices.method_22909();
        class_3611 fluid = item.fluid();
        if (fluid != class_3612.field_15906) {
            class_9326 components = item.components();
            this.matrices.method_22903();
            this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-15.5f));
            this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(22.5f));
            float fluidScale = 16 * windowScaleFactor;
            this.matrices.method_22905(fluidScale, -fluidScale, fluidScale);
            this.matrices.method_46416(0.0f, -1.4f, 0.0f);
            float from = 0.1875f;
            float to = 1.0625f;
            FluidRenderHelper.renderFluidBox(fluid, components, from, from, from, to, to, to, (class_4597)this.field_59933, this.matrices, 0xF000F0, false, true);
            this.matrices.method_22909();
            this.matrices.method_22903();
            this.matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-15.5f));
            this.matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(22.5f));
            this.matrices.method_46416(scale / 2.0f, scale * 1.5f, scale / 2.0f);
            this.matrices.method_22905(fluidScale, -fluidScale, fluidScale);
            this.matrices.method_46416(-0.5f, -1.0f, -0.5f);
            float fluidWidth = 0.0078125f * -squeeze * 16.0f;
            from = -fluidWidth / 2.0f + 0.5f;
            to = fluidWidth / 2.0f + 0.5f;
            FluidRenderHelper.renderFluidBox(fluid, components, from, 0.0f, from, to, 2.0f, to, (class_4597)this.field_59933, this.matrices, 0xF000F0, false, true);
            this.matrices.method_22909();
        }
        this.field_59933.method_22993();
        texture.clear();
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView(), (class_12137)RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST)), item.method_72127(), item.comp_4122(), item.comp_4123(), item.comp_4124(), item.comp_4125(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    protected void renderToTexture(SpoutRenderState state, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Spout";
    }

    public Class<SpoutRenderState> method_70903() {
        return SpoutRenderState.class;
    }
}

