/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerClientHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_10526;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_12249;
import net.minecraft.class_1306;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class LinkedControllerModel
implements class_10439,
class_10515<RenderData> {
    public static final class_2960 ID = class_2960.method_60655((String)"create", (String)"model/linked_controller");
    public static final class_2960 ITEM_ID = class_2960.method_60655((String)"create", (String)"item/linked_controller/item");
    public static final class_2960 POWERED_ID = class_2960.method_60655((String)"create", (String)"item/linked_controller/powered");
    public static final class_2960 TORCH_ID = class_2960.method_60655((String)"create", (String)"item/linked_controller/torch");
    public static final class_2960 TORCH_OFF_ID = class_2960.method_60655((String)"create", (String)"item/linked_controller/torch_off");
    public static final class_2960 BUTTON_ID = class_2960.method_60655((String)"create", (String)"item/linked_controller/button");
    private static final LerpedFloat equipProgress = LerpedFloat.linear().startWithValue(0.0);
    private static final List<LerpedFloat> buttons = (List)class_156.method_654(new ArrayList(6), list -> {
        for (int i = 0; i < 6; ++i) {
            list.add(LerpedFloat.linear().startWithValue(0.0));
        }
    });
    private final class_1921 itemLayer = class_4722.method_29382();
    private final class_1921 blockLayer = class_4722.method_24074();
    private final class_1921 cutoutLayer = class_12249.method_75972();
    private final int[] tints = new int[0];
    private final class_10809 settings;
    private final Supplier<Vector3fc[]> vector;
    private final List<class_777> item;
    private final List<class_777> powered;
    private final List<class_777> torch;
    private final List<class_777> torchOff;
    private final List<class_777> button;

    public static void tick(class_310 mc) {
        if (mc.method_1493()) {
            return;
        }
        boolean active = LinkedControllerClientHandler.MODE != LinkedControllerClientHandler.Mode.IDLE;
        equipProgress.chase(active ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        equipProgress.tickChaser();
        if (!active) {
            return;
        }
        for (int i = 0; i < buttons.size(); ++i) {
            LerpedFloat lerpedFloat = buttons.get(i);
            lerpedFloat.chase(LinkedControllerClientHandler.currentlyPressed.contains(i) ? 1.0 : 0.0, 0.4f, LerpedFloat.Chaser.EXP);
            lerpedFloat.tickChaser();
        }
    }

    public static void resetButtons() {
        for (LerpedFloat button : buttons) {
            button.startWithValue(0.0);
        }
    }

    public LinkedControllerModel(class_10809 settings, List<class_777> item, List<class_777> powered, List<class_777> torch, List<class_777> torchOff, List<class_777> button) {
        this.settings = settings;
        this.item = item;
        this.vector = Suppliers.memoize(() -> class_10430.method_67990((List)item));
        this.powered = powered;
        this.torch = torch;
        this.torchOff = torchOff;
        this.button = button;
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 user, int seed) {
        boolean bind;
        state.method_70946((Object)this);
        state.method_70947();
        class_10444.class_10446 layerRenderState = state.method_65601();
        layerRenderState.method_67995(this.vector);
        this.settings.method_68000(layerRenderState, displayContext);
        RenderData data = RenderData.EMPTY;
        class_310 mc = class_310.method_1551();
        LinkedControllerClientHandler.Mode mode = LinkedControllerClientHandler.MODE;
        boolean bl = bind = mode == LinkedControllerClientHandler.Mode.BIND;
        if (displayContext == class_811.field_4317) {
            class_1799 mainStack;
            class_746 player;
            if ((bind || mode == LinkedControllerClientHandler.Mode.ACTIVE) && (player = mc.field_1724) != null && (stack == (mainStack = player.method_6047()) || mainStack.method_7909() != AllItems.LINKED_CONTROLLER && stack == player.method_6079())) {
                data = new RenderData(true, false, bind);
            }
        } else {
            class_746 player = mc.field_1724;
            class_1306 arm = (class_1306)mc.field_1690.method_42552().method_41753();
            if (displayContext == class_811.field_4322) {
                data = (bind || mode == LinkedControllerClientHandler.Mode.ACTIVE) && (arm == class_1306.field_6183 || LinkedControllerModel.canUse((class_1657)player, arm)) ? new RenderData(true, true, bind) : RenderData.EQUIP;
            } else if (displayContext == class_811.field_4321) {
                data = (bind || mode == LinkedControllerClientHandler.Mode.ACTIVE) && (arm == class_1306.field_6182 || LinkedControllerModel.canUse((class_1657)player, arm)) ? new RenderData(true, true, bind) : RenderData.EQUIP;
            } else if (displayContext == class_811.field_4320) {
                if ((bind || mode == LinkedControllerClientHandler.Mode.ACTIVE) && (arm == class_1306.field_6183 || LinkedControllerModel.canUse((class_1657)player, arm))) {
                    data = new RenderData(true, false, bind);
                }
            } else if (displayContext == class_811.field_4323 && (bind || mode == LinkedControllerClientHandler.Mode.ACTIVE) && (arm == class_1306.field_6182 || LinkedControllerModel.canUse((class_1657)player, arm))) {
                data = new RenderData(true, false, bind);
            }
        }
        layerRenderState.method_65617((class_10515)this, (Object)data);
        state.method_70946((Object)data.active);
    }

    private static boolean canUse(class_1657 player, class_1306 arm) {
        return player != null && player.method_61420(arm).method_7909() != AllItems.LINKED_CONTROLLER;
    }

    public void submit(RenderData data, class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, boolean glint, int i) {
        assert (data != null);
        this.render(displayContext, matrices, queue, light, overlay, data.bind, data.equip, data.active, true);
    }

    public void renderInLectern(class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, boolean active, boolean renderDepression) {
        this.render(displayContext, matrices, queue, light, overlay, false, false, active, renderDepression);
    }

    private void render(class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, boolean bind, boolean equip, boolean active, boolean renderDepression) {
        float pt = -1.0f;
        matrices.method_22903();
        if (equip) {
            pt = AnimationTickHolder.getPartialTicks();
            float progress = equipProgress.getValue(pt);
            int handModifier = displayContext == class_811.field_4321 ? -1 : 1;
            matrices.method_46416(0.0f, progress / 4.0f, progress / 4.0f * (float)handModifier);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(progress * -30.0f * (float)handModifier));
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(progress * -30.0f));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
        }
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.itemLayer, active ? this.powered : this.item);
        if (!active) {
            this.renderQuads(displayContext, matrices, queue, light, overlay, this.blockLayer, this.torchOff);
            matrices.method_22909();
            return;
        }
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.cutoutLayer, this.torch);
        if (bind) {
            light = class_3532.method_48781((float)((class_3532.method_15374((double)(AnimationTickHolder.getRenderTime() / 4.0f)) + 1.0f) / 2.0f), (int)5, (int)15) << 20;
        }
        float s = 0.0625f;
        float b = s * -0.75f;
        int index = 0;
        if (pt == -1.0f) {
            pt = AnimationTickHolder.getPartialTicks();
        }
        matrices.method_22903();
        matrices.method_46416(2.0f * s, 0.0f, 8.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.method_46416(4.0f * s, 0.0f, 0.0f);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.method_46416(-2.0f * s, 0.0f, 2.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.method_46416(0.0f, 0.0f, -4.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.method_22909();
        matrices.method_46416(3.0f * s, 0.0f, 3.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.method_46416(2.0f * s, 0.0f, 0.0f);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index, renderDepression);
        matrices.method_22909();
    }

    private void renderButton(class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, List<class_777> button, float pt, float b, int index, boolean renderDepression) {
        matrices.method_22903();
        if (renderDepression) {
            float depression = b * buttons.get(index).getValue(pt);
            matrices.method_46416(0.0f, depression, 0.0f);
        }
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.itemLayer, button);
        matrices.method_22909();
    }

    private void renderQuads(class_811 displayContext, class_4587 matrices, class_11659 queue, int light, int overlay, class_1921 layer, List<class_777> quads) {
        queue.method_73480(matrices, displayContext, light, overlay, 0, this.tints, quads, layer, class_10444.class_10445.field_55341);
    }

    public void method_72175(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public RenderData extractArgument(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    @Environment(value=EnvType.CLIENT)
    public record RenderData(boolean active, boolean equip, boolean bind) {
        public static RenderData EMPTY = new RenderData(false, false, false);
        public static RenderData EQUIP = new RenderData(false, true, false);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Unbaked
    implements class_10439.class_10441 {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> method_65585() {
            return CODEC;
        }

        public void method_62326(class_10526.class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(POWERED_ID);
            resolver.markDependency(TORCH_ID);
            resolver.markDependency(TORCH_OFF_ID);
            resolver.markDependency(BUTTON_ID);
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(ITEM_ID);
            class_10419 textures = model.method_68045();
            List quads = model.method_68034(textures, baker, (class_3665)class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001((class_7775)baker, (class_10819)model, (class_10419)textures);
            return new LinkedControllerModel(settings, quads, Unbaked.bakeQuads(baker, POWERED_ID), Unbaked.bakeQuads(baker, TORCH_ID), Unbaked.bakeQuads(baker, TORCH_OFF_ID), Unbaked.bakeQuads(baker, BUTTON_ID));
        }

        private static List<class_777> bakeQuads(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            return model.method_68034(model.method_68045(), baker, (class_3665)class_1086.field_63619).method_68048();
        }
    }
}

