/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

@Environment(value=EnvType.CLIENT)
public class MechanicalSawScenes {
    public static void processing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_saw_processing", "Processing Items on the Mechanical Saw");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        class_2338 shaftPos = util.grid().at(2, 1, 3);
        scene.world().setBlock(shaftPos, (class_2680)AllBlocks.SHAFT.method_9564().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), false);
        class_2338 sawPos = util.grid().at(2, 1, 2);
        Selection sawSelect = util.select().position(sawPos);
        scene.world().modifyBlockEntityNBT(sawSelect, SawBlockEntity.class, nbt -> nbt.method_10569("RecipeIndex", 0));
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(2, 1, 3, 2, 1, 5), class_2350.field_11033);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(shaftPos);
        scene.world().showSection(sawSelect, class_2350.field_11033);
        scene.idle(10);
        scene.overlay().showText(50).attachKeyFrame().text("Upward facing Mechanical Saws can process a variety of items").pointAt(util.vector().blockSurface(sawPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(45);
        class_1799 log = new class_1799((class_1935)class_1802.field_8583);
        class_1799 strippedLog = new class_1799((class_1935)class_1802.field_8415);
        class_1799 planks = new class_1799((class_1935)class_1802.field_8118);
        class_243 itemSpawn = util.vector().centerOf(sawPos.method_10084().method_10067());
        ElementLink<EntityElement> logItem = scene.world().createItemEntity(itemSpawn, util.vector().of(0.0, 0.0, 0.0), log);
        scene.idle(12);
        scene.overlay().showControls(itemSpawn, Pointing.DOWN, 20).withItem(log);
        scene.idle(10);
        scene.world().modifyEntity(logItem, e -> e.method_18799(util.vector().of(0.05, 0.2, 0.0)));
        scene.idle(12);
        scene.world().modifyEntity(logItem, class_1297::method_31472);
        scene.world().createItemOnBeltLike(sawPos, class_2350.field_11039, log);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.recipeDuration = 50.0f;
            inventory.remainingTime = 50.0f;
            inventory.appliedRecipe = false;
        });
        scene.idle(34);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, strippedLog);
            inventory.recipeDuration = 20.0f;
            inventory.remainingTime = 20.0f;
            inventory.appliedRecipe = true;
        });
        scene.idle(16);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(1, class_1799.field_8037);
            inventory.remainingTime = -1.0f;
        });
        logItem = scene.world().createItemEntity(util.vector().topOf(sawPos).method_1031(0.5, -0.1, 0.0), util.vector().of(0.05, 0.18, 0.0), strippedLog);
        scene.idle(12);
        scene.overlay().showControls(itemSpawn.method_1031(2.0, 0.0, 0.0), Pointing.DOWN, 20).withItem(strippedLog);
        scene.idle(30);
        scene.overlay().showText(60).attachKeyFrame().text("The processed item always moves against the rotational input to the saw").pointAt(util.vector().blockSurface(sawPos, class_2350.field_11036)).placeNearTarget();
        scene.idle(70);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(-2.0f * f.floatValue()));
        scene.effects().rotationDirectionIndicator(shaftPos);
        scene.world().modifyEntity(logItem, e -> e.method_18799(util.vector().of(-0.05, 0.2, 0.0)));
        scene.idle(12);
        scene.world().modifyEntity(logItem, class_1297::method_31472);
        scene.world().createItemOnBeltLike(sawPos, class_2350.field_11034, strippedLog);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.recipeDuration = 50.0f;
            inventory.remainingTime = 50.0f;
            inventory.appliedRecipe = false;
        });
        scene.idle(17);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, planks);
            inventory.recipeDuration = 20.0f;
            inventory.remainingTime = 20.0f;
            inventory.appliedRecipe = true;
        });
        scene.idle(8);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(1, class_1799.field_8037);
            inventory.remainingTime = -1.0f;
        });
        logItem = scene.world().createItemEntity(util.vector().topOf(sawPos).method_1031(-0.5, -0.1, 0.0), util.vector().of(-0.05, 0.18, 0.0), planks);
        scene.idle(22);
        Selection otherBelt = util.select().fromTo(3, 1, 3, 4, 1, 2);
        Selection belt = util.select().fromTo(0, 1, 2, 1, 1, 3);
        scene.world().setKineticSpeed(otherBelt, 0.0f);
        scene.world().setKineticSpeed(belt, 0.0f);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world().modifyEntity(logItem, class_1297::method_31472);
        scene.world().setBlock(shaftPos, (class_2680)AllBlocks.COGWHEEL.method_9564().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), true);
        scene.idle(3);
        scene.addKeyframe();
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.5f);
        ElementLink<WorldSectionElement> beltSection = scene.world().showIndependentSection(belt, class_2350.field_11034);
        scene.world().moveSection(beltSection, util.vector().of(0.0, 100.0, 0.0), 0);
        scene.idle(1);
        scene.world().removeItemsFromBelt(util.grid().at(1, 1, 2));
        scene.idle(1);
        scene.world().setKineticSpeed(belt, -64.0f);
        scene.idle(1);
        scene.world().moveSection(beltSection, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.idle(3);
        ElementLink<WorldSectionElement> otherBeltSection = scene.world().showIndependentSection(otherBelt, class_2350.field_11039);
        scene.world().moveSection(otherBeltSection, util.vector().of(0.0, 100.0, 0.0), 0);
        scene.idle(1);
        scene.world().removeItemsFromBelt(util.grid().at(3, 1, 2));
        scene.idle(1);
        scene.world().setKineticSpeed(otherBelt, -64.0f);
        scene.idle(1);
        scene.world().moveSection(otherBeltSection, util.vector().of(0.0, -100.0, 0.0), 0);
        scene.idle(3);
        class_1799 stone = new class_1799((class_1935)class_2246.field_10340);
        class_2338 firstBelt = util.grid().at(0, 1, 2);
        scene.overlay().showText(60).text("Saws can work in-line with Mechanical Belts").pointAt(util.vector().blockSurface(firstBelt, class_2350.field_11039)).placeNearTarget();
        scene.idle(40);
        scene.world().createItemOnBelt(firstBelt, class_2350.field_11039, stone);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.recipeDuration = 50.0f;
            inventory.remainingTime = 50.0f;
            inventory.appliedRecipe = false;
        });
        scene.idle(34);
        class_1799 bricks = new class_1799((class_1935)class_2246.field_10056);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, bricks);
            inventory.recipeDuration = 20.0f;
            inventory.remainingTime = 20.0f;
            inventory.appliedRecipe = true;
        });
        class_243 filter = util.vector().of(2.5, 1.8125, 2.3125);
        scene.overlay().showFilterSlotInput(filter, class_2350.field_11036, 80);
        scene.overlay().showText(80).attachKeyFrame().text("When an ingredient has multiple possible outcomes, the filter slot can specify it").pointAt(filter).placeNearTarget();
        scene.idle(15);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(1, class_1799.field_8037);
            DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((class_1922)saw.method_10997(), util.grid().at(3, 1, 2), DirectBeltInputBehaviour.TYPE);
            behaviour.handleInsertion(bricks, class_2350.field_11034, false);
        });
        scene.idle(75);
        scene.overlay().showControls(filter, Pointing.DOWN, 30).withItem(bricks);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.idle(7);
        scene.world().setFilterData(util.select().position(sawPos), SawBlockEntity.class, bricks);
        scene.idle(10);
        scene.world().createItemOnBelt(firstBelt, class_2350.field_11039, stone);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.recipeDuration = 50.0f;
            inventory.remainingTime = 50.0f;
            inventory.appliedRecipe = false;
        });
        scene.idle(34);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(0, class_1799.field_8037);
            inventory.method_5447(1, bricks);
            inventory.recipeDuration = 20.0f;
            inventory.remainingTime = 20.0f;
            inventory.appliedRecipe = true;
        });
        scene.idle(15);
        scene.world().modifyBlockEntity(sawPos, SawBlockEntity.class, saw -> {
            ProcessingInventory inventory = saw.inventory;
            inventory.method_5447(1, class_1799.field_8037);
            DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get((class_1922)saw.method_10997(), util.grid().at(3, 1, 2), DirectBeltInputBehaviour.TYPE);
            behaviour.handleInsertion(bricks, class_2350.field_11034, false);
        });
        scene.markAsFinished();
        scene.overlay().showText(100).text("Without filter, the Saw would cycle through all outcomes instead").colored(PonderPalette.RED).pointAt(filter).placeNearTarget();
        scene.idle(65);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
    }

    public static void treeCutting(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_saw_breaker", "Cutting Trees with the Mechanical Saw");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        scene.world().setBlock(util.grid().at(2, 0, 2), class_2246.field_10219.method_9564(), false);
        scene.world().showSection(util.select().layer(0).add(util.select().position(3, 1, 1)).add(util.select().position(1, 1, 2)), class_2350.field_11036);
        scene.world().setKineticSpeed(util.select().position(5, 0, 1), -8.0f);
        scene.world().setKineticSpeed(util.select().fromTo(3, 1, 2, 5, 1, 2), 16.0f);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 5, 1, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(3, 1, 2), class_2350.field_11033);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 2, 3, 2), class_2350.field_11036);
        scene.world().showSection(util.select().layersFrom(4), class_2350.field_11036);
        class_2338 breakingPos = util.grid().at(2, 1, 2);
        scene.idle(5);
        for (i = 0; i < 10; ++i) {
            scene.idle(10);
            scene.world().incrementBlockBreakingProgress(breakingPos);
            if (i != 1) continue;
            scene.overlay().showText(80).attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(breakingPos, class_2350.field_11039)).text("When given Rotational Force, a Mechanical Saw will cut trees directly in front of it");
        }
        scene.world().replaceBlocks(util.select().fromTo(2, 2, 2, 2, 6, 2), class_2246.field_10124.method_9564(), true);
        scene.world().destroyBlock(util.grid().at(3, 5, 0));
        scene.world().destroyBlock(util.grid().at(0, 4, 1));
        scene.world().destroyBlock(util.grid().at(2, 6, 1));
        scene.world().destroyBlock(util.grid().at(1, 4, 0));
        scene.world().destroyBlock(util.grid().at(1, 6, 2));
        scene.world().destroyBlock(util.grid().at(1, 5, 3));
        scene.world().destroyBlock(util.grid().at(0, 4, 3));
        scene.world().replaceBlocks(util.select().layersFrom(4), class_2246.field_10124.method_9564(), false);
        for (i = 0; i < 5; ++i) {
            class_243 dropPos = util.vector().centerOf(breakingPos.method_10086(i));
            float distance = (float)dropPos.method_1022(util.vector().centerOf(breakingPos));
            scene.world().createItemEntity(dropPos, util.vector().of(-distance / 20.0f, 0.0, 0.0), new class_1799((class_1935)class_1802.field_8583));
        }
        scene.idle(35);
        scene.world().destroyBlock(util.grid().at(1, 1, 2));
        scene.world().hideSection(util.select().layersFrom(2).add(util.select().fromTo(2, 1, 2, 1, 1, 3)), class_2350.field_11036);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.idle(15);
        scene.world().setBlocks(util.select().fromTo(2, 1, 2, 1, 20, 3), class_2246.field_10306.method_9564(), false);
        scene.world().showSection(util.select().layersFrom(2).add(util.select().fromTo(2, 1, 2, 1, 1, 3)), class_2350.field_11036);
        scene.idle(15);
        scene.world().hideSection(util.select().fromTo(2, 1, 2, 1, 1, 3).substract(util.select().position(breakingPos)), class_2350.field_11039);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().position(breakingPos), 90).attachKeyFrame().colored(PonderPalette.GREEN).placeNearTarget().text("In order to cut the tree fully, the Saw has to break the last block connecting it to the ground");
        scene.idle(25);
        for (i = 0; i < 10; ++i) {
            scene.idle(10);
            scene.world().incrementBlockBreakingProgress(breakingPos);
        }
        for (i = 0; i < 30; ++i) {
            scene.world().replaceBlocks(util.select().fromTo(2, i + 1, 2, 1, i + 1, 3), class_2246.field_10124.method_9564(), true);
            for (int x = 1; x <= 2; ++x) {
                for (int z = 2; z <= 3; ++z) {
                    class_243 dropPos = util.vector().centerOf(x, i + 1, z);
                    float distance = (float)dropPos.method_1022(util.vector().centerOf(breakingPos));
                    scene.world().createItemEntity(dropPos, util.vector().of(-distance / 20.0f, 0.0, 0.0), new class_1799((class_1935)class_1802.field_8125));
                }
            }
            scene.idle(1);
        }
    }

    public static void contraption(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_saw_contraption", "Using Mechanical Saws on Contraptions");
        scene.configureBasePlate(1, 0, 6);
        scene.scaleSceneView(0.9f);
        scene.world().setBlock(util.grid().at(2, 0, 3), class_2246.field_10219.method_9564(), false);
        scene.world().showSection(util.select().layer(0).add(util.select().position(3, 1, 1)).add(util.select().position(1, 1, 2)).add(util.select().position(2, 1, 4)), class_2350.field_11036);
        Selection kinetics = util.select().fromTo(6, 1, 2, 6, 1, 6);
        scene.idle(5);
        ElementLink<WorldSectionElement> pistonHead = scene.world().showIndependentSection(util.select().fromTo(6, 1, 1, 8, 1, 1), class_2350.field_11033);
        scene.world().moveSection(pistonHead, util.vector().of(0.0, 0.0, 1.0), 0);
        scene.world().showSection(kinetics, class_2350.field_11033);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().fromTo(5, 1, 3, 5, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(4, 1, 3), class_2350.field_11034, contraption);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(4, 1, 2), class_2350.field_11034, contraption);
        scene.idle(5);
        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(util.grid().at(4, 1, 3))).text("Whenever Saws are moved as part of an animated Contraption...");
        scene.idle(70);
        Selection saws = util.select().fromTo(4, 1, 2, 4, 1, 3);
        Selection tree = util.select().fromTo(2, 1, 3, 2, 7, 3).add(util.select().layersFrom(3));
        scene.world().showSection(tree, class_2350.field_11036);
        scene.world().setKineticSpeed(util.select().position(5, 0, 6), -8.0f);
        scene.world().setKineticSpeed(kinetics, 16.0f);
        scene.world().setKineticSpeed(saws, 16.0f);
        scene.world().moveSection(pistonHead, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.world().moveSection(contraption, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.idle(20);
        class_2338 breakingPos = util.grid().at(2, 1, 3);
        for (i = 0; i < 10; ++i) {
            scene.idle(3);
            scene.world().incrementBlockBreakingProgress(breakingPos);
            if (i != 2) continue;
            scene.overlay().showText(80).placeNearTarget().pointAt(util.vector().blockSurface(breakingPos, class_2350.field_11039)).text("...they will cut any trees the contraption runs them into");
        }
        scene.world().replaceBlocks(util.select().fromTo(2, 2, 3, 2, 6, 3), class_2246.field_10124.method_9564(), true);
        scene.world().destroyBlock(util.grid().at(4, 5, 1));
        scene.world().destroyBlock(util.grid().at(1, 4, 2));
        scene.world().destroyBlock(util.grid().at(3, 6, 2));
        scene.world().destroyBlock(util.grid().at(2, 4, 1));
        scene.world().destroyBlock(util.grid().at(2, 6, 3));
        scene.world().destroyBlock(util.grid().at(2, 5, 2));
        scene.world().destroyBlock(util.grid().at(1, 4, 2));
        scene.world().replaceBlocks(util.select().layersFrom(4), class_2246.field_10124.method_9564(), false);
        for (i = 0; i < 5; ++i) {
            class_243 dropPos = util.vector().centerOf(breakingPos.method_10086(i));
            float distance = (float)dropPos.method_1022(util.vector().centerOf(breakingPos));
            scene.world().createItemEntity(dropPos, util.vector().of(-distance / 20.0f, 0.0, 0.0), new class_1799((class_1935)class_1802.field_8583));
        }
        scene.world().moveSection(pistonHead, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.world().moveSection(contraption, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.idle(20);
        scene.world().setKineticSpeed(saws, 0.0f);
        scene.idle(20);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world().moveSection(pistonHead, util.vector().of(2.0, 0.0, 0.0), 40);
        scene.world().moveSection(contraption, util.vector().of(2.0, 0.0, 0.0), 40);
        scene.world().hideSection(tree, class_2350.field_11036);
        scene.idle(40);
        scene.world().restoreBlocks(tree);
        scene.world().modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world().glueBlockOnto(util.grid().at(5, 2, 2), class_2350.field_11033, contraption);
        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(5, 2, 2), class_2350.field_11039)).sharedText("storage_on_contraption");
        scene.idle(70);
        scene.world().showSection(tree, class_2350.field_11033);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world().setKineticSpeed(saws, 16.0f);
        scene.world().moveSection(pistonHead, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.world().moveSection(contraption, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.idle(20);
        for (i = 0; i < 10; ++i) {
            scene.idle(3);
            scene.world().incrementBlockBreakingProgress(breakingPos);
        }
        scene.world().replaceBlocks(util.select().fromTo(2, 2, 3, 2, 6, 3), class_2246.field_10124.method_9564(), true);
        scene.world().destroyBlock(util.grid().at(4, 5, 1));
        scene.world().destroyBlock(util.grid().at(1, 4, 2));
        scene.world().destroyBlock(util.grid().at(3, 6, 2));
        scene.world().destroyBlock(util.grid().at(2, 4, 1));
        scene.world().destroyBlock(util.grid().at(2, 6, 3));
        scene.world().destroyBlock(util.grid().at(2, 5, 2));
        scene.world().destroyBlock(util.grid().at(1, 4, 2));
        scene.world().replaceBlocks(util.select().layersFrom(4), class_2246.field_10124.method_9564(), false);
        scene.world().moveSection(pistonHead, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.world().moveSection(contraption, util.vector().of(-1.0, 0.0, 0.0), 20);
        scene.idle(20);
        scene.world().setKineticSpeed(saws, 0.0f);
        scene.idle(10);
        scene.overlay().showControls(util.vector().topOf(3, 2, 2), Pointing.DOWN, 60).withItem(new class_1799((class_1935)class_2246.field_10431));
        scene.idle(20);
    }
}

