/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@Environment(value=EnvType.CLIENT)
public class MixinPlugin
implements IMixinConfigPlugin {
    private List<String> mixins;

    public void onLoad(String mixinPackage) {
        this.mixins = new ArrayList<String>();
        FabricLoader loader = FabricLoader.getInstance();
        if (loader.isModLoaded("sodium")) {
            this.mixins.add("FabricModelAccessMixin");
            this.mixins.add("AbstractBlockRenderContextMixin");
        }
        if (loader.isModLoaded("iris")) {
            this.mixins.add("IrisPipelinesMixin");
        }
        if (loader.isModLoaded("eiv")) {
            this.mixins.add("ItemSlotMixin");
            this.mixins.add("FabricEIVMixin");
            this.mixins.add("RecipeViewMenuMixin");
            this.mixins.add("ViewTypeButtonMixin");
            this.mixins.add("FluidItemSpecialRendererMixin");
            this.mixins.add("RecipeViewScreenMixin");
            this.mixins.add("CraftingViewRecipeAccessor");
        }
        if (!loader.isModLoaded("fabric-item-group-api-v1")) {
            this.mixins.add("CreativeModeInventoryScreenMixin");
        }
        if (loader.isModLoaded("fabric-renderer-api-v1")) {
            this.mixins.add("FabricBlockStateModelMixin");
        }
        if (loader.isModLoaded("fabric-renderer-indigo")) {
            this.mixins.add("BlockRenderInfoMixin");
            this.mixins.add("AbstractTerrainRenderContextMixin");
        }
        if (loader.isModLoaded("fabric-rendering-fluids-v1")) {
            this.mixins.add("WaterRenderHandlerMixin");
        }
        if (loader.isModLoaded("fabric-transfer-api-v1")) {
            this.mixins.add("FluidVariantRenderHandlerMixin");
        }
        if (loader.isModLoaded("fabric-model-loading-api-v1")) {
            this.mixins.add("WrapperBlockStateModelMixin");
        } else {
            this.mixins.add("LoadBlockModelMixin");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return this.mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

