/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.instruction.PonderInstruction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RotateSceneInstruction
extends PonderInstruction {
    private final float xRot;
    private final float yRot;
    private final boolean relative;

    public RotateSceneInstruction(float xRot, float yRot, boolean relative) {
        this.xRot = xRot;
        this.yRot = yRot;
        this.relative = relative;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public void tick(PonderScene scene) {
        PonderScene.SceneTransform transform = scene.getTransform();
        float targetX = this.relative ? transform.xRotation.getChaseTarget() + this.xRot : this.xRot;
        float targetY = this.relative ? transform.yRotation.getChaseTarget() + this.yRot : this.yRot;
        transform.xRotation.chase(targetX, 0.1f, LerpedFloat.Chaser.EXP);
        transform.yRotation.chase(targetY, 0.1f, LerpedFloat.Chaser.EXP);
    }
}

