/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.ui;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11910;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PonderButton
extends BoxWidget {
    public static final Couple<Color> COLOR_IDLE = Couple.create(new Color(1623245055, true), new Color(817938687, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_HOVER = Couple.create(new Color(-255803137, true), new Color(-1597980417, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_CLICK = Couple.create(new Color(-1, true), new Color(-570425345, true)).map(Color::setImmutable);
    public static final Couple<Color> COLOR_DISABLED = Couple.create(new Color(-2138009456, true), new Color(0x20909090, true)).map(Color::setImmutable);
    @Nullable
    protected class_1799 item;
    @Nullable
    protected PonderTag tag;
    @Nullable
    protected class_304 shortcut;
    protected LerpedFloat flash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);

    public PonderButton(int x, int y) {
        this(x, y, 20, 20);
    }

    public PonderButton(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.z = 420.0f;
        this.paddingX = 2.0f;
        this.paddingY = 2.0f;
        this.colorIdle = COLOR_IDLE;
        this.colorHover = COLOR_HOVER;
        this.colorClick = COLOR_CLICK;
        this.colorDisabled = COLOR_DISABLED;
        this.updateGradientFromState();
    }

    public <T extends PonderButton> T withShortcut(class_304 key) {
        this.shortcut = key;
        return (T)this;
    }

    public <T extends PonderButton> T showingTag(PonderTag tag) {
        this.tag = tag;
        return (T)((PonderButton)this.showing(this.tag));
    }

    public <T extends PonderButton> T showing(class_1799 item) {
        this.item = item;
        return (T)((PonderButton)super.showingElement((RenderElement)GuiGameElement.of(item).scale(1.5f).at(-4.0f, -4.0f)));
    }

    public void flash() {
        this.flash.updateChaseTarget(1.0f);
    }

    public void dim() {
        this.flash.updateChaseTarget(0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.flash.tickChaser();
    }

    @Override
    protected void beforeRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        float flashValue = this.flash.getValue(partialTicks);
        if (flashValue > 0.1f) {
            float sin = 0.5f + 0.5f * class_3532.method_15374((double)(((float)AnimationTickHolder.getTicks(true) + partialTicks) / 10.0f));
            Color nc1 = new Color(255, 255, 255, class_3532.method_15340((int)(((Color)this.gradientColor.getFirst()).getAlpha() + 150), (int)0, (int)255));
            Color nc2 = new Color(155, 155, 155, class_3532.method_15340((int)(((Color)this.gradientColor.getSecond()).getAlpha() + 150), (int)0, (int)255));
            Couple<Color> newColors = Couple.create(nc1, nc2);
            float finalSin = sin *= flashValue;
            this.gradientColor = this.gradientColor.mapWithParams((color, other) -> color.mixWith((Color)other, finalSin), newColors);
        }
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        if (!this.isVisible()) {
            return;
        }
        if (this.shortcut != null) {
            graphics.method_25300(graphics.field_44656.field_1772, this.shortcut.method_16007().getString().toLowerCase(Locale.ROOT), this.method_46426() + this.field_22758 / 2 + 8, this.method_46427() + this.field_22759 - 6, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).scaleAlpha(this.fade.getValue()).getRGB());
        }
    }

    public boolean method_25370() {
        return false;
    }

    public boolean method_25404(class_11908 input) {
        if (this.shortcut != null && this.shortcut.method_1417(input)) {
            this.gradientColor = this.getColorClick();
            this.startGradientAnimation(this.getColorForState(), 0.15);
            this.runCallback((float)this.field_22758 / 2.0f, (float)this.field_22759 / 2.0f);
            return true;
        }
        return super.method_25404(input);
    }

    protected boolean method_25351(class_11910 input) {
        return this.isVisible();
    }

    @Nullable
    public class_1799 getItem() {
        return this.item;
    }

    @Nullable
    public PonderTag getTag() {
        return this.tag;
    }

    public boolean isVisible() {
        return !(this.fade.getValue() < 0.1f);
    }

    public void clear() {
        if (this.tag != null) {
            this.tag.clear();
        }
        if (this.element != null) {
            this.element.clear();
        }
    }
}

