/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.api.contraption.storage.fluid.MountedFluidStorageWrapper;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import org.jetbrains.annotations.Nullable;

public class TrainCargoManager
extends MountedStorageManager {
    int ticksSinceLastExchange = 0;
    AtomicInteger version = new AtomicInteger();

    @Override
    public void initialize() {
        super.initialize();
        this.items = new CargoInvWrapper(this.items);
        this.allItems = this.items;
        if (this.fuelItems != null) {
            this.fuelItems = new CargoInvWrapper(this.fuelItems);
        }
        this.fluids = new CargoTankWrapper(this.fluids);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.method_71465("TicksSinceLastExchange", this.ticksSinceLastExchange);
    }

    @Override
    public <T> void write(DynamicOps<T> ops, T empty, RecordBuilder<T> map, boolean clientPacket) {
        super.write(ops, empty, map, clientPacket);
        map.add("TicksSinceLastExchange", ops.createInt(this.ticksSinceLastExchange));
    }

    @Override
    public void read(class_11368 view, boolean clientPacket, @Nullable Contraption contraption) {
        super.read(view, clientPacket, contraption);
        this.ticksSinceLastExchange = view.method_71424("TicksSinceLastExchange", 0);
    }

    @Override
    public <T> void read(DynamicOps<T> ops, MapLike<T> map, boolean clientPacket, @Nullable Contraption contraption) {
        super.read(ops, map, clientPacket, contraption);
        this.ticksSinceLastExchange = ops.getNumberValue(map.get("TicksSinceLastExchange"), (Number)0).intValue();
    }

    public void resetIdleCargoTracker() {
        this.ticksSinceLastExchange = 0;
    }

    public void tickIdleCargoTracker() {
        ++this.ticksSinceLastExchange;
    }

    public int getTicksSinceLastExchange() {
        return this.ticksSinceLastExchange;
    }

    public int getVersion() {
        return this.version.get();
    }

    void changeDetected() {
        this.version.incrementAndGet();
        this.resetIdleCargoTracker();
    }

    class CargoInvWrapper
    extends MountedItemStorageWrapper {
        CargoInvWrapper(MountedItemStorageWrapper wrapped) {
            super(wrapped.storages);
        }

        @Override
        public void markInventoryDirty() {
            TrainCargoManager.this.changeDetected();
        }
    }

    class CargoTankWrapper
    extends MountedFluidStorageWrapper {
        CargoTankWrapper(MountedFluidStorageWrapper wrapped) {
            super(wrapped.storages);
        }

        @Override
        public void markInventoryDirty() {
            TrainCargoManager.this.changeDetected();
        }
    }
}

