/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids;

import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.fluid.FluidHelper;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class FlowSource {
    BlockFace location;

    public FlowSource(BlockFace location) {
        this.location = location;
    }

    public FluidStack provideFluid(Predicate<FluidStack> extractionPredicate) {
        return Optional.ofNullable(this.provideHandler()).flatMap(tank -> tank.stream(this.location.getOppositeFace()).filter(stack -> !stack.isEmpty() && extractionPredicate.test((FluidStack)stack)).findFirst().map(stack -> stack.copyWithAmount(1))).orElse(FluidStack.EMPTY);
    }

    public void keepAlive() {
    }

    public abstract boolean isEndpoint();

    public void manageSource(class_1937 world, class_2586 networkBE) {
    }

    public void whileFlowPresent(class_1937 world, boolean pulling) {
    }

    @Nullable
    public FluidInventory provideHandler() {
        return null;
    }

    public static class Blocked
    extends FlowSource {
        public Blocked(BlockFace location) {
            super(location);
        }

        @Override
        public boolean isEndpoint() {
            return false;
        }
    }

    public static class OtherPipe
    extends FlowSource {
        WeakReference<FluidTransportBehaviour> cached;

        public OtherPipe(BlockFace location) {
            super(location);
        }

        @Override
        public void manageSource(class_1937 world, class_2586 networkBE) {
            if (this.cached != null && this.cached.get() != null && !((FluidTransportBehaviour)this.cached.get()).blockEntity.method_11015()) {
                return;
            }
            this.cached = null;
            FluidTransportBehaviour fluidTransportBehaviour = BlockEntityBehaviour.get((class_1922)world, this.location.getConnectedPos(), FluidTransportBehaviour.TYPE);
            if (fluidTransportBehaviour != null) {
                this.cached = new WeakReference<FluidTransportBehaviour>(fluidTransportBehaviour);
            }
        }

        @Override
        public FluidStack provideFluid(Predicate<FluidStack> extractionPredicate) {
            if (this.cached == null || this.cached.get() == null) {
                return FluidStack.EMPTY;
            }
            FluidTransportBehaviour behaviour = (FluidTransportBehaviour)this.cached.get();
            FluidStack providedOutwardFluid = behaviour.getProvidedOutwardFluid(this.location.getOppositeFace());
            return extractionPredicate.test(providedOutwardFluid) ? providedOutwardFluid : FluidStack.EMPTY;
        }

        @Override
        public boolean isEndpoint() {
            return false;
        }
    }

    public static class FluidHandler
    extends FlowSource {
        @Nullable
        Supplier<FluidInventory> fluidHandlerCache;

        public FluidHandler(BlockFace location) {
            super(location);
        }

        @Override
        public void manageSource(class_1937 world, class_2586 networkBE) {
            class_2338 pos;
            class_2586 blockEntity;
            if (this.fluidHandlerCache == null && (blockEntity = world.method_8321(pos = this.location.getConnectedPos())) != null) {
                SmartBlockEntity smartBE;
                class_2350 side = this.location.getOppositeFace();
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    this.fluidHandlerCache = FluidHelper.getFluidInventoryCache(serverWorld, pos, side);
                } else if (networkBE instanceof SmartBlockEntity && (smartBE = (SmartBlockEntity)networkBE).isVirtual()) {
                    this.fluidHandlerCache = () -> FluidHelper.getFluidInventory(world, pos, null, blockEntity, side);
                }
            }
        }

        @Override
        @Nullable
        public FluidInventory provideHandler() {
            return this.fluidHandlerCache != null ? this.fluidHandlerCache.get() : null;
        }

        @Override
        public boolean isEndpoint() {
            return true;
        }
    }
}

