/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.press;

import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;

public class BeltPressingCallbacks {
    static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, PressingBehaviour behaviour) {
        if (behaviour.specifics.getKineticSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (behaviour.running) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!behaviour.specifics.tryProcessOnBelt(transported, null, true)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        behaviour.start(PressingBehaviour.Mode.BELT);
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, PressingBehaviour behaviour) {
        if (behaviour.specifics.getKineticSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!behaviour.running) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (behaviour.runningTicks != 120) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        behaviour.particleItems.clear();
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        if (!behaviour.specifics.tryProcessOnBelt(transported, results, false)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        boolean bulk = behaviour.specifics.canProcessInBulk() || transported.stack.method_7947() == 1;
        transported.clearFanProcessingData();
        List<TransportedItemStack> collect = results.stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            boolean centered = BeltHelper.isItemUpright(stack);
            copy.stack = stack;
            copy.locked = true;
            copy.angle = centered ? 180 : behaviour.getLevel().field_9229.method_43048(360);
            return copy;
        }).collect(Collectors.toList());
        if (bulk) {
            if (collect.isEmpty()) {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            } else {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(collect));
            }
        } else {
            TransportedItemStack left = transported.copy();
            left.stack.method_7934(1);
            if (collect.isEmpty()) {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left));
            } else {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(collect, left));
            }
        }
        behaviour.blockEntity.sendData();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }
}

