/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.nixieTube;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.utility.DynamicComponent;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NixieTubeBlockEntity
extends SmartBlockEntity {
    private int redstoneStrength = 0;
    private Optional<class_2561> customText = Optional.empty();
    private int nixieIndex;
    private Couple<String> displayedStrings;
    @Nullable
    public ComputerSignal computerSignal;
    private WeakReference<SignalBlockEntity> cachedSignalTE = new WeakReference<Object>(null);
    public SignalBlockEntity.SignalState signalState;

    public NixieTubeBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.NIXIE_TUBE, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.method_8608()) {
            return;
        }
        this.signalState = null;
        if (AbstractComputerBehaviour.contains(this)) {
            if (this.field_11863.method_8608() && this.cachedSignalTE.get() != null) {
                this.cachedSignalTE = new WeakReference<Object>(null);
            }
            return;
        }
        this.computerSignal = null;
        SignalBlockEntity signalBlockEntity = (SignalBlockEntity)this.cachedSignalTE.get();
        if (signalBlockEntity == null || signalBlockEntity.method_11015()) {
            class_2350 facing = NixieTubeBlock.getFacing(this.method_11010());
            class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(facing.method_10153()));
            if (blockEntity instanceof SignalBlockEntity) {
                SignalBlockEntity signal = (SignalBlockEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signal);
            }
            return;
        }
        this.signalState = signalBlockEntity.getState();
    }

    @Override
    public void initialize() {
        if (this.field_11863.method_8608()) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        if (AbstractComputerBehaviour.contains(this)) {
            return false;
        }
        return this.customText.isEmpty();
    }

    @Nullable
    public Couple<String> getDisplayedStrings() {
        return this.displayedStrings;
    }

    public class_5250 getFullText() {
        return this.customText.map(class_2561::method_27661).orElse(class_2561.method_43470((String)("" + this.redstoneStrength)));
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void displayCustomText(class_2561 text, int nixiePositionInRow) {
        if (text == null) {
            return;
        }
        if (this.customText.filter(d -> d.equals((Object)text)).isPresent()) {
            return;
        }
        this.customText = Optional.ofNullable(DynamicComponent.parseCustomText(this.field_11863, this.field_11867, text));
        this.nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void displayEmptyText(int nixiePositionInRow) {
        this.displayCustomText(class_5244.field_39003, nixiePositionInRow);
    }

    public void updateDisplayedStrings() {
        if (this.signalState != null || this.computerSignal != null) {
            return;
        }
        this.customText.map(class_2561::getString).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create(this.charOrEmpty((String)fullText, this.nixieIndex * 2), this.charOrEmpty((String)fullText, this.nixieIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create(this.redstoneStrength < 10 ? "0" : "1", String.valueOf(this.redstoneStrength % 10));
        });
    }

    public void clearCustomText() {
        this.nixieIndex = 0;
        this.customText = Optional.empty();
    }

    public int getRedstoneStrength() {
        return this.redstoneStrength;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        view.method_71426("CustomText", class_8824.field_46597).ifPresentOrElse(text -> {
            this.customText = Optional.of(text);
            this.nixieIndex = view.method_71424("CustomTextIndex", 0);
        }, () -> {
            this.redstoneStrength = view.method_71424("RedstoneStrength", 0);
        });
        if (clientPacket || this.isVirtual()) {
            view.method_71426("ComputerSignal", (Codec)Codec.BYTE_BUFFER).ifPresentOrElse(t -> {
                byte[] encodedComputerSignal = t.array();
                if (this.computerSignal == null) {
                    this.computerSignal = new ComputerSignal();
                }
                this.computerSignal.decode(encodedComputerSignal);
            }, () -> {
                this.computerSignal = null;
            });
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        this.customText.ifPresentOrElse(text -> {
            view.method_71465("CustomTextIndex", this.nixieIndex);
            view.method_71468("CustomText", class_8824.field_46597, text);
        }, () -> view.method_71465("RedstoneStrength", this.redstoneStrength));
        if (clientPacket && this.computerSignal != null) {
            view.method_71468("ComputerSignal", (Codec)Codec.BYTE_BUFFER, (Object)ByteBuffer.wrap(this.computerSignal.encode()));
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public static final class ComputerSignal {
        @NotNull
        public TubeDisplay first = new TubeDisplay();
        @NotNull
        public TubeDisplay second = new TubeDisplay();

        public void decode(byte[] encoded) {
            this.first.decode(encoded, 0);
            this.second.decode(encoded, 7);
        }

        public byte[] encode() {
            byte[] encoded = new byte[14];
            this.first.encode(encoded, 0);
            this.second.encode(encoded, 7);
            return encoded;
        }

        public static final class TubeDisplay {
            public static final int ENCODED_SIZE = 7;
            public byte r = (byte)63;
            public byte g = (byte)63;
            public byte b = (byte)63;
            public byte blinkPeriod = 0;
            public byte blinkOffTime = 0;
            public byte glowWidth = 1;
            public byte glowHeight = 1;

            public void decode(byte[] data, int offset) {
                this.r = data[offset];
                this.g = data[offset + 1];
                this.b = data[offset + 2];
                this.blinkPeriod = data[offset + 3];
                this.blinkOffTime = data[offset + 4];
                this.glowWidth = data[offset + 5];
                this.glowHeight = data[offset + 6];
            }

            public void encode(byte[] data, int offset) {
                data[offset] = this.r;
                data[offset + 1] = this.g;
                data[offset + 2] = this.b;
                data[offset + 3] = this.blinkPeriod;
                data[offset + 4] = this.blinkOffTime;
                data[offset + 5] = this.glowWidth;
                data[offset + 6] = this.glowHeight;
            }
        }
    }
}

