/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.trains.graph;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.trains.graph.DimensionPalette;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackMaterial;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class TrackNodeLocation
extends class_2382 {
    private static final Codec<TrackNodeLocation> POS_CODEC = Codec.INT_STREAM.comapFlatMap(stream -> class_156.method_29190((IntStream)stream, (int)3).map(coordinates -> new TrackNodeLocation(coordinates[0], coordinates[1], coordinates[2])), vec -> IntStream.of(vec.method_10263(), vec.method_10264(), vec.method_10260()));
    public static final class_9139<ByteBuf, TrackNodeLocation> POS_PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.field_48550, class_2382::method_10263, (class_9139)class_9135.field_48550, class_2382::method_10264, (class_9139)class_9135.field_48550, class_2382::method_10260, TrackNodeLocation::new);
    public class_5321<class_1937> dimension;
    public int yOffsetPixels;

    private TrackNodeLocation(int x, int y, int z) {
        super(x, y, z);
    }

    public TrackNodeLocation(class_243 vec) {
        this(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public TrackNodeLocation(double x, double y, double z) {
        super(class_3532.method_15357((double)Math.round(x * 2.0)), class_3532.method_15357((double)y) * 2, class_3532.method_15357((double)Math.round(z * 2.0)));
    }

    public TrackNodeLocation in(class_1937 level) {
        return this.in((class_5321<class_1937>)level.method_27983());
    }

    public TrackNodeLocation in(class_5321<class_1937> dimension) {
        this.dimension = dimension;
        return this;
    }

    private static TrackNodeLocation fromPackedPos(class_2338 bufferPos) {
        return new TrackNodeLocation(bufferPos);
    }

    private TrackNodeLocation(class_2338 readBlockPos) {
        super(readBlockPos.method_10263(), readBlockPos.method_10264(), readBlockPos.method_10260());
    }

    public class_243 getLocation() {
        return new class_243((double)this.method_10263() / 2.0, (double)this.method_10264() / 2.0 + (double)this.yOffsetPixels / 16.0, (double)this.method_10260() / 2.0);
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object pOther) {
        if (!this.equalsIgnoreDim(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (!Objects.equals(tnl.dimension, this.dimension)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equalsIgnoreDim(Object pOther) {
        if (!super.equals(pOther)) return false;
        if (!(pOther instanceof TrackNodeLocation)) return false;
        TrackNodeLocation tnl = (TrackNodeLocation)((Object)pOther);
        if (tnl.yOffsetPixels != this.yOffsetPixels) return false;
        return true;
    }

    public int hashCode() {
        return (this.method_10264() + ((this.method_10260() + this.yOffsetPixels * 31) * 31 + this.dimension.hashCode()) * 31) * 31 + this.method_10263();
    }

    public void write(class_11372 view, DimensionPalette dimensions) {
        view.method_71468("Pos", POS_CODEC, (Object)this);
        if (dimensions != null) {
            view.method_71468("D", (Codec)dimensions, this.dimension);
        }
        if (this.yOffsetPixels != 0) {
            view.method_71465("YO", this.yOffsetPixels);
        }
    }

    public static <T> DataResult<T> encode(TrackNodeLocation input, DynamicOps<T> ops, T empty, DimensionPalette dimensions) {
        RecordBuilder builder = ops.mapBuilder();
        builder.add("Pos", (Object)input, POS_CODEC);
        if (dimensions != null) {
            builder.add("D", input.dimension, (Encoder)dimensions);
        }
        if (input.yOffsetPixels != 0) {
            builder.add("YO", ops.createInt(input.yOffsetPixels));
        }
        return builder.build(empty);
    }

    public static TrackNodeLocation read(class_11368 view, DimensionPalette dimensions) {
        TrackNodeLocation location = (TrackNodeLocation)((Object)view.method_71426("Pos", POS_CODEC).orElseThrow());
        if (dimensions != null) {
            location.dimension = view.method_71426("D", (Codec)dimensions).orElse(null);
        }
        location.yOffsetPixels = view.method_71424("YO", 0);
        return location;
    }

    public static <T> TrackNodeLocation decode(DynamicOps<T> ops, T input, DimensionPalette dimensions) {
        MapLike map = (MapLike)ops.getMap(input).getOrThrow();
        TrackNodeLocation location = (TrackNodeLocation)((Object)((Pair)POS_CODEC.decode(ops, map.get("Pos")).getOrThrow()).getFirst());
        if (dimensions != null) {
            location.dimension = dimensions.parse(ops, map.get("D")).result().orElse(null);
        }
        location.yOffsetPixels = Optional.ofNullable(map.get("YO")).map(value -> ((Number)ops.getNumberValue(value).getOrThrow()).intValue()).orElse(0);
        return location;
    }

    public void send(class_2540 buffer, DimensionPalette dimensions) {
        buffer.method_10804(this.method_10263());
        buffer.method_52998(this.method_10264());
        buffer.method_10804(this.method_10260());
        buffer.method_10804(this.yOffsetPixels);
        buffer.method_10804(dimensions.encode(this.dimension));
    }

    public static TrackNodeLocation receive(class_2540 buffer, DimensionPalette dimensions) {
        TrackNodeLocation location = new TrackNodeLocation(buffer.method_10816(), buffer.readShort(), buffer.method_10816());
        location.yOffsetPixels = buffer.method_10816();
        location.dimension = dimensions.decode(buffer.method_10816());
        return location;
    }

    public Collection<class_2338> allAdjacent() {
        HashSet<class_2338> set = new HashSet<class_2338>();
        class_243 vec3 = this.getLocation().method_1023(0.0, (double)this.yOffsetPixels / 16.0, 0.0);
        double step = 0.125;
        for (int x : Iterate.positiveAndNegative) {
            for (int y : Iterate.positiveAndNegative) {
                for (int z : Iterate.positiveAndNegative) {
                    set.add(class_2338.method_49638((class_2374)vec3.method_1031((double)x * step, (double)y * step, (double)z * step)));
                }
            }
        }
        return set;
    }

    public static class DiscoveredLocation
    extends TrackNodeLocation {
        BezierConnection turn = null;
        boolean forceNode = false;
        class_243 direction;
        class_243 normal;
        TrackMaterial materialA;
        TrackMaterial materialB;

        public DiscoveredLocation(class_1937 level, double x, double y, double z) {
            super(x, y, z);
            this.in(level);
        }

        public DiscoveredLocation(class_5321<class_1937> dimension, class_243 vec) {
            super(vec);
            this.in(dimension);
        }

        public DiscoveredLocation(class_1937 level, class_243 vec) {
            this((class_5321<class_1937>)level.method_27983(), vec);
        }

        public DiscoveredLocation materialA(TrackMaterial material) {
            this.materialA = material;
            return this;
        }

        public DiscoveredLocation materialB(TrackMaterial material) {
            this.materialB = material;
            return this;
        }

        public DiscoveredLocation materials(TrackMaterial materialA, TrackMaterial materialB) {
            this.materialA = materialA;
            this.materialB = materialB;
            return this;
        }

        public DiscoveredLocation viaTurn(BezierConnection turn) {
            this.turn = turn;
            if (turn != null) {
                this.forceNode();
            }
            return this;
        }

        public DiscoveredLocation forceNode() {
            this.forceNode = true;
            return this;
        }

        public DiscoveredLocation withNormal(class_243 normal) {
            this.normal = normal;
            return this;
        }

        public DiscoveredLocation withYOffset(int yOffsetPixels) {
            this.yOffsetPixels = yOffsetPixels;
            return this;
        }

        public DiscoveredLocation withDirection(class_243 direction) {
            this.direction = direction == null ? null : direction.method_1029();
            return this;
        }

        public boolean connectedViaTurn() {
            return this.turn != null;
        }

        public BezierConnection getTurn() {
            return this.turn;
        }

        public boolean shouldForceNode() {
            return this.forceNode;
        }

        public boolean differentMaterials() {
            return this.materialA != this.materialB;
        }

        public boolean notInLineWith(class_243 direction) {
            return this.direction != null && Math.max(direction.method_1026(this.direction), direction.method_1026(this.direction.method_1021(-1.0))) < 0.875;
        }

        public class_243 getDirection() {
            return this.direction;
        }
    }
}

