/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.fabric.networking;

import com.natamus.collective_common_fabric.data.Constants;
import com.natamus.collective_common_fabric.implementations.networking.PacketRegistrationHandler;
import com.natamus.collective_common_fabric.implementations.networking.data.CommonPacketWrapper;
import com.natamus.collective_common_fabric.implementations.networking.data.PacketContainer;
import com.natamus.collective_common_fabric.implementations.networking.data.PacketContext;
import com.natamus.collective_common_fabric.implementations.networking.data.Side;
import com.natamus.collective_common_fabric.implementations.networking.exceptions.RegistrationException;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FabricNetworkHandler
extends PacketRegistrationHandler {
    public FabricNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        try {
            if (container.packetType() == PacketContainer.PacketType.PLAY) {
                PayloadTypeRegistry.playC2S().register(container.getType(), container.getCodec());
                PayloadTypeRegistry.playS2C().register(container.getType(), container.getCodec());
            } else {
                PayloadTypeRegistry.configurationC2S().register(container.getType(), container.getCodec());
                PayloadTypeRegistry.configurationS2C().register(container.getType(), container.getCodec());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (Side.CLIENT.equals((Object)this.side)) {
            Constants.LOG.debug("Registering packet {} : {} on the: {}", new Object[]{container.type().comp_2242(), container.classType(), Side.CLIENT});
            if (container.packetType() == PacketContainer.PacketType.PLAY) {
                ClientPlayNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.client().execute(() -> container.handler().accept(new PacketContext(payload.packet(), Side.CLIENT))));
            } else {
                ClientConfigurationNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.client().execute(() -> container.handler().accept(new PacketContext(payload.packet(), Side.CLIENT))));
            }
        }
        Constants.LOG.debug("Registering packet {} : {} on the: {}", new Object[]{container.type().comp_2242(), container.classType(), Side.SERVER});
        if (container.packetType() == PacketContainer.PacketType.PLAY) {
            ServerPlayNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.player().method_51469().method_8503().execute(() -> container.handler().accept(new PacketContext((class_1657)context.player(), payload.packet(), Side.SERVER))));
        } else {
            ServerConfigurationNetworking.registerGlobalReceiver(container.getType(), (payload, context) -> context.server().execute(() -> container.handler().accept(new PacketContext(null, payload.packet(), Side.SERVER))));
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (ignoreCheck || ClientPlayNetworking.canSend((class_2960)container.type().comp_2242())) {
                ClientPlayNetworking.send(new CommonPacketWrapper<T>(container, packet));
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the client, packets need to be registered on both sides!");
        }
    }

    @Override
    public <T> void sendToClient(T packet, class_3222 player) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (ServerPlayNetworking.canSend((class_3222)player, (class_2960)container.type().comp_2242())) {
                ServerPlayNetworking.send((class_3222)player, new CommonPacketWrapper<T>(container, packet));
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the server, packets need to be registered on both sides!");
        }
    }
}

