/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.elements.ScalableDrawable;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.GuiProperties;
import mezz.jei.gui.bookmarks.BookmarkFactory;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.elements.IconButton;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUserInput;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.UserInputRouter;
import mezz.jei.gui.overlay.bookmarks.history.LookupHistory;
import mezz.jei.gui.recipes.CraftingStations;
import mezz.jei.gui.recipes.IRecipeGuiLogic;
import mezz.jei.gui.recipes.IRecipeLayoutWithButtons;
import mezz.jei.gui.recipes.RecipeCategoryTitle;
import mezz.jei.gui.recipes.RecipeGuiLayouts;
import mezz.jei.gui.recipes.RecipeGuiLogic;
import mezz.jei.gui.recipes.RecipeGuiTabs;
import mezz.jei.gui.recipes.RecipeOptionButtons;
import mezz.jei.gui.recipes.lookups.StaticFocusedRecipes;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jspecify.annotations.Nullable;

public class RecipesGui
extends class_437
implements IRecipesGui,
IRecipeFocusSource {
    private static final int borderPadding = 6;
    private static final int minRecipePadding = 4;
    private static final int navBarPadding = 2;
    private static final int titleInnerPadding = 14;
    private static final int smallButtonWidth = 13;
    private static final int smallButtonHeight = 13;
    private static final int minGuiWidth = 198;
    private final IInternalKeyMappings keyBindings;
    private final BookmarkList bookmarks;
    private final IFocusFactory focusFactory;
    private int headerHeight;
    private final IRecipeGuiLogic logic;
    private final RecipeGuiLayouts layouts;
    private String pageString = "1/1";
    private final ScalableDrawable background;
    private final CraftingStations craftingStations;
    private final RecipeGuiTabs recipeGuiTabs;
    private final RecipeOptionButtons optionButtons;
    private final UserInputRouter inputHandler;
    private final IconButton nextRecipeCategory;
    private final IconButton previousRecipeCategory;
    private final IconButton nextPage;
    private final IconButton previousPage;
    private @Nullable class_437 parentScreen;
    private ImmutableRect2i idealArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i area = ImmutableRect2i.EMPTY;
    private RecipeCategoryTitle recipeCategoryTitle = new RecipeCategoryTitle();
    private boolean init = false;

    public RecipesGui(IRecipeManager recipeManager, IIngredientManager ingredientManager, IRecipeTransferManager recipeTransferManager, IInternalKeyMappings keyBindings, IFocusFactory focusFactory, BookmarkList bookmarks, LookupHistory lookupHistory, IGuiHelper guiHelper, BookmarkFactory bookmarkFactory) {
        super((class_2561)class_2561.method_43470((String)"Recipes"));
        this.bookmarks = bookmarks;
        this.keyBindings = keyBindings;
        this.logic = new RecipeGuiLogic(recipeManager, ingredientManager, lookupHistory, recipeTransferManager, this::updateLayout, focusFactory, bookmarkFactory);
        this.craftingStations = new CraftingStations(recipeManager);
        this.recipeGuiTabs = new RecipeGuiTabs(this.logic, recipeManager, guiHelper);
        this.optionButtons = new RecipeOptionButtons(this.logic::goToFirstPage);
        this.focusFactory = focusFactory;
        this.layouts = new RecipeGuiLayouts();
        Textures textures = Internal.getTextures();
        final IDrawableStatic arrowNext = textures.getArrowNext();
        final IDrawableStatic arrowPrevious = textures.getArrowPrevious();
        ImmutableRect2i buttonSize = new ImmutableRect2i(0, 0, 13, 13);
        this.nextRecipeCategory = new IconButton(new IIconButtonController(){

            @Override
            public boolean onPress(IJeiUserInput input) {
                return input.isSimulate() || RecipesGui.this.logic.nextRecipeCategory();
            }

            @Override
            public void initState(IButtonState state) {
                state.setIcon(arrowNext);
                this.updateState(state);
            }

            @Override
            public void updateState(IButtonState state) {
                state.setActive(RecipesGui.this.logic.hasMultipleCategories());
            }
        }, buttonSize);
        this.previousRecipeCategory = new IconButton(new IIconButtonController(){

            @Override
            public boolean onPress(IJeiUserInput input) {
                return input.isSimulate() || RecipesGui.this.logic.previousRecipeCategory();
            }

            @Override
            public void initState(IButtonState state) {
                state.setIcon(arrowPrevious);
                this.updateState(state);
            }

            @Override
            public void updateState(IButtonState state) {
                state.setActive(RecipesGui.this.logic.hasMultipleCategories());
            }
        }, buttonSize);
        this.nextPage = new IconButton(new IIconButtonController(){

            @Override
            public boolean onPress(IJeiUserInput input) {
                return input.isSimulate() || RecipesGui.this.logic.nextPage();
            }

            @Override
            public void initState(IButtonState state) {
                state.setIcon(arrowNext);
                this.updateState(state);
            }

            @Override
            public void updateState(IButtonState state) {
                state.setActive(RecipesGui.this.logic.hasMultiplePages());
            }
        }, buttonSize);
        this.previousPage = new IconButton(new IIconButtonController(){

            @Override
            public boolean onPress(IJeiUserInput input) {
                return input.isSimulate() || RecipesGui.this.logic.previousPage();
            }

            @Override
            public void initState(IButtonState state) {
                state.setIcon(arrowPrevious);
                this.updateState(state);
            }

            @Override
            public void updateState(IButtonState state) {
                state.setActive(RecipesGui.this.logic.hasMultiplePages());
            }
        }, buttonSize);
        this.background = textures.getRecipeGuiBackground();
        this.inputHandler = new UserInputRouter("RecipesGui", this.layouts.createInputHandler(), new UserInputHandler(this), this.optionButtons.createInputHandler(), this.recipeGuiTabs.createInputHandler(), this.nextRecipeCategory.createInputHandler(), this.previousRecipeCategory.createInputHandler(), this.nextPage.createInputHandler(), this.previousPage.createInputHandler());
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public int getLeftSideExtraWidth() {
        if (this.craftingStations.isEmpty()) {
            return this.optionButtons.getWidth();
        }
        return Math.max(this.craftingStations.getWidth(), this.optionButtons.getWidth());
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25426() {
        super.method_25426();
        int xSize = 198;
        IClientConfig clientConfig = Internal.getJeiClientConfigs().getClientConfig();
        int ySize = clientConfig.isCenterSearchBarEnabled() ? this.field_22790 - 76 : this.field_22790 - 58;
        int extraSpace = 0;
        int maxHeight = clientConfig.getMaxRecipeGuiHeight();
        if (ySize > maxHeight) {
            extraSpace = ySize - maxHeight;
            ySize = maxHeight;
        }
        int guiLeft = (this.field_22789 - 198) / 2;
        int guiTop = 45 + extraSpace / 2;
        this.area = this.idealArea = new ImmutableRect2i(guiLeft, guiTop, 198, ySize);
        int rightButtonX = guiLeft + 198 - 6 - 13;
        int leftButtonX = guiLeft + 6;
        Objects.requireNonNull(this.field_22793);
        int titleHeight = 9 + 6;
        int recipeClassButtonTop = guiTop + titleHeight - 13 + 2;
        this.nextRecipeCategory.updateBounds(this.nextRecipeCategory.getArea().setPosition(rightButtonX, recipeClassButtonTop));
        this.previousRecipeCategory.updateBounds(this.previousRecipeCategory.getArea().setPosition(leftButtonX, recipeClassButtonTop));
        int pageButtonTop = recipeClassButtonTop + 13 + 2;
        this.nextPage.updateBounds(this.nextPage.getArea().setPosition(rightButtonX, pageButtonTop));
        this.previousPage.updateBounds(this.previousPage.getArea().setPosition(leftButtonX, pageButtonTop));
        this.headerHeight = pageButtonTop + 13 - guiTop;
        this.init = true;
        this.updateLayout();
    }

    protected void method_57736(class_332 guiGraphics, int x, int y, int width, int height) {
        this.method_52752(guiGraphics);
        this.background.draw(guiGraphics, this.area);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_25294(this.previousRecipeCategory.getX() + this.previousRecipeCategory.getWidth(), this.previousRecipeCategory.getY(), this.nextRecipeCategory.getX(), this.nextRecipeCategory.getY() + this.nextRecipeCategory.getHeight(), 0x30000000);
        guiGraphics.method_25294(this.previousPage.getX() + this.previousPage.getWidth(), this.previousPage.getY(), this.nextPage.getX(), this.nextPage.getY() + this.nextPage.getHeight(), 0x30000000);
        this.recipeCategoryTitle.draw(guiGraphics, this.field_22793);
        ImmutableRect2i pageArea = MathUtil.union(this.previousPage.getArea(), this.nextPage.getArea());
        StringUtil.drawCenteredStringWithShadow(guiGraphics, this.field_22793, this.pageString, pageArea);
        this.nextRecipeCategory.draw(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousRecipeCategory.draw(guiGraphics, mouseX, mouseY, partialTicks);
        this.nextPage.draw(guiGraphics, mouseX, mouseY, partialTicks);
        this.previousPage.draw(guiGraphics, mouseX, mouseY, partialTicks);
        Optional<IRecipeLayoutDrawable<?>> hoveredRecipeLayout = this.layouts.draw(guiGraphics, mouseX, mouseY);
        this.optionButtons.draw(guiGraphics, mouseX, mouseY, partialTicks);
        Optional<IRecipeSlotDrawable> hoveredRecipeCatalyst = this.craftingStations.draw(guiGraphics, mouseX, mouseY);
        this.recipeGuiTabs.draw(this.field_22787, guiGraphics, mouseX, mouseY, partialTicks);
        this.layouts.drawTooltips(guiGraphics, mouseX, mouseY);
        this.optionButtons.drawTooltips(guiGraphics, mouseX, mouseY);
        hoveredRecipeLayout.ifPresent(l -> l.drawOverlays(guiGraphics, mouseX, mouseY));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawHoverOverlays(guiGraphics));
        hoveredRecipeCatalyst.ifPresent(h -> h.drawTooltip(guiGraphics, mouseX, mouseY));
        if (this.recipeCategoryTitle.isMouseOver(mouseX, mouseY)) {
            JeiTooltip tooltip = new JeiTooltip();
            this.recipeCategoryTitle.getTooltip(tooltip);
            if (!this.logic.hasAllCategories()) {
                tooltip.addKeyUsageComponent("jei.tooltip.show.all.recipes.hotkey", this.keyBindings.getLeftClick());
            }
            tooltip.draw(guiGraphics, mouseX, mouseY);
        }
        if (DebugConfig.isDebugGuisEnabled()) {
            guiGraphics.method_25294(this.idealArea.getX(), this.idealArea.getY(), this.idealArea.getX() + this.idealArea.getWidth(), this.idealArea.getY() + this.idealArea.getHeight(), 0x4400FF00);
            guiGraphics.method_25294(this.area.getX(), this.area.getY(), this.area.getX() + this.area.getWidth(), this.area.getY() + this.area.getHeight(), 0x44990044);
            ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
            guiGraphics.method_25294(recipeLayoutsArea.getX(), recipeLayoutsArea.getY(), recipeLayoutsArea.getX() + recipeLayoutsArea.getWidth(), recipeLayoutsArea.getY() + recipeLayoutsArea.getHeight(), 0x44228844);
        }
    }

    private static ImmutableRect2i calculateAreaToFitLayouts(ImmutableRect2i idealArea, int screenWidth, int recipeWidth) {
        if (recipeWidth == 0) {
            return idealArea;
        }
        int padding = 12;
        int width = 186;
        width = Math.max(recipeWidth, width);
        int newWidth = width + 12;
        int newX = (screenWidth - newWidth) / 2;
        return new ImmutableRect2i(newX, idealArea.getY(), newWidth, idealArea.getHeight());
    }

    public void method_25393() {
        super.method_25393();
        this.layouts.tick();
        this.optionButtons.tick();
        this.logic.tick();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (this.field_22787.field_1755 == this) {
            return this.area.contains(mouseX, mouseY) || this.optionButtons.getArea().contains(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public Stream<IClickableIngredientInternal<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isOpen()) {
            return Stream.concat(this.craftingStations.getIngredientUnderMouse(mouseX, mouseY), this.layouts.getIngredientUnderMouse(mouseX, mouseY));
        }
        return Stream.empty();
    }

    @Override
    public Stream<IDraggableIngredientInternal<?>> getDraggableIngredientUnderMouse(double mouseX, double mouseY) {
        return Stream.empty();
    }

    public void method_16014(double mouseX, double mouseY) {
        this.layouts.mouseMoved(mouseX, mouseY);
    }

    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        class_3675.class_306 input = class_3675.class_307.field_1672.method_1447(event.method_74245());
        return this.layouts.mouseDragged(event.comp_4798(), event.comp_4799(), input, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.inputHandler.handleMouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        boolean handled = UserInput.fromVanilla(mouseButtonEvent, doubleClick, InputType.SIMULATE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.method_25402(mouseButtonEvent, doubleClick);
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        boolean handled = MouseUserInput.fromVanilla(mouseButtonEvent, false, InputType.EXECUTE).map(this::handleInput).orElse(false);
        if (handled) {
            return true;
        }
        return super.method_25406(mouseButtonEvent);
    }

    public boolean method_25404(class_11908 keyEvent) {
        UserInput input = UserInput.fromVanilla(keyEvent, InputType.IMMEDIATE);
        return this.handleInput(input);
    }

    private boolean handleInput(UserInput input) {
        IGuiProperties guiProperties = this.getProperties();
        if (guiProperties == null) {
            return false;
        }
        return this.inputHandler.handleUserInput(this, guiProperties, input, this.keyBindings);
    }

    public boolean isOpen() {
        return this.field_22787.field_1755 == this;
    }

    private void open() {
        if (!this.isOpen()) {
            this.parentScreen = this.field_22787.field_1755;
        }
        this.field_22787.method_1507((class_437)this);
    }

    public void method_25419() {
        if (this.isOpen()) {
            this.field_22787.method_1507(this.parentScreen);
            this.parentScreen = null;
            this.logic.clearHistory();
            return;
        }
        super.method_25419();
    }

    @Override
    public void show(List<IFocus<?>> focuses) {
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        if (this.logic.showFocus(checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public void showTypes(List<IRecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotEmpty(recipeTypes, "recipeTypes");
        if (this.logic.showCategories(recipeTypes)) {
            this.open();
        }
    }

    @Override
    public <T> void showRecipes(IRecipeCategory<T> recipeCategory, List<T> recipes, List<IFocus<?>> focuses) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotEmpty(recipes, "recipes");
        IFocusGroup checkedFocuses = this.focusFactory.createFocusGroup(focuses);
        StaticFocusedRecipes<T> focusedRecipes = new StaticFocusedRecipes<T>(recipeCategory, recipes);
        if (this.logic.showRecipes(focusedRecipes, checkedFocuses)) {
            this.open();
        }
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        double x = MouseUtil.getX();
        double y = MouseUtil.getY();
        return this.getIngredientUnderMouse(x, y).map(IClickableIngredientInternal::getTypedIngredient).flatMap(i -> i.getIngredient(ingredientType).stream()).findFirst();
    }

    public void back() {
        this.logic.back();
    }

    private void updateLayout() {
        if (!this.init) {
            return;
        }
        ImmutableRect2i titleArea = MathUtil.union(this.previousRecipeCategory.getArea(), this.nextRecipeCategory.getArea()).cropLeft(this.previousRecipeCategory.getWidth() + 14).cropRight(this.nextRecipeCategory.getWidth() + 14);
        IRecipeCategory<?> recipeCategory = this.logic.getSelectedRecipeCategory();
        this.recipeCategoryTitle = RecipeCategoryTitle.create(recipeCategory, this.field_22793, titleArea);
        ImmutableRect2i recipeLayoutsArea = this.getRecipeLayoutsArea();
        int availableHeight = recipeLayoutsArea.getHeight();
        class_1703 containerMenu = this.getParentContainerMenu();
        List<IRecipeLayoutWithButtons<?>> recipeLayoutsWithButtons = this.logic.getVisibleRecipeLayoutsWithButtons(availableHeight, 4, containerMenu, this.bookmarks, this);
        int recipesPerPage = this.logic.getRecipesPerPage();
        this.layouts.setRecipeLayoutsWithButtons(recipeLayoutsWithButtons);
        this.layouts.tick();
        this.area = RecipesGui.calculateAreaToFitLayouts(this.idealArea, this.field_22789, this.layouts.getWidth());
        recipeLayoutsArea = this.getRecipeLayoutsArea();
        this.layouts.updateLayout(recipeLayoutsArea, recipesPerPage);
        this.nextRecipeCategory.tick();
        this.previousRecipeCategory.tick();
        this.nextPage.tick();
        this.previousPage.tick();
        this.pageString = this.logic.getPageString();
        this.optionButtons.updateLayout(this.area);
        ImmutableRect2i optionButtonsArea = this.optionButtons.getArea();
        List<ITypedIngredient<?>> recipeCatalystIngredients = this.logic.getRecipeCatalysts().toList();
        this.craftingStations.updateLayout(recipeCatalystIngredients, this.area, optionButtonsArea);
        this.recipeGuiTabs.initLayout(this.idealArea);
    }

    private ImmutableRect2i getRecipeLayoutsArea() {
        return new ImmutableRect2i(this.area.getX() + 6, this.area.getY() + this.headerHeight + 2, this.area.getWidth() - 12, this.area.getHeight() - (this.headerHeight + 6 + 2));
    }

    public @Nullable class_1703 getParentContainerMenu() {
        class_437 screen = this.parentScreen == null ? class_310.method_1551().field_1755 : this.parentScreen;
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            return containerScreen.method_17577();
        }
        return null;
    }

    @Override
    public Optional<class_437> getParentScreen() {
        return Optional.ofNullable(this.parentScreen);
    }

    public @Nullable IGuiProperties getProperties() {
        if (this.field_22789 <= 0 || this.field_22790 <= 0) {
            return null;
        }
        int extraWidth = this.getLeftSideExtraWidth();
        ImmutableRect2i recipeArea = this.getArea();
        int guiXSize = recipeArea.getWidth() + extraWidth;
        int guiYSize = recipeArea.getHeight();
        if (guiXSize <= 0 || guiYSize <= 0) {
            return null;
        }
        return new GuiProperties(this.getClass(), recipeArea.getX() - extraWidth, recipeArea.getY(), guiXSize, guiYSize, this.field_22789, this.field_22790);
    }

    private static class UserInputHandler
    implements IUserInputHandler {
        private final RecipesGui recipesGui;

        public UserInputHandler(RecipesGui recipesGui) {
            this.recipesGui = recipesGui;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(class_437 screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
            double mouseY;
            double mouseX = input.getMouseX();
            if (this.recipesGui.method_25405(mouseX, mouseY = input.getMouseY()) && this.recipesGui.recipeCategoryTitle.isMouseOver(mouseX, mouseY) && input.is(keyBindings.getLeftClick()) && (input.isSimulate() || this.recipesGui.logic.showAllRecipes())) {
                return Optional.of(this);
            }
            class_310 minecraft = class_310.method_1551();
            if (input.is(keyBindings.getCloseRecipeGui()) || input.is(minecraft.field_1690.field_1822)) {
                if (!input.isSimulate()) {
                    this.recipesGui.method_25419();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getRecipeBack())) {
                if (!input.isSimulate()) {
                    this.recipesGui.back();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextCategory())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.nextRecipeCategory();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousCategory())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.previousRecipeCategory();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getNextRecipePage())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.nextPage();
                }
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousRecipePage())) {
                if (!input.isSimulate()) {
                    this.recipesGui.logic.previousPage();
                }
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
            if (this.recipesGui.method_25405(mouseX, mouseY)) {
                if (scrollDeltaY < 0.0) {
                    this.recipesGui.logic.nextPage();
                    return Optional.of(this);
                }
                if (scrollDeltaY > 0.0) {
                    this.recipesGui.logic.previousPage();
                    return Optional.of(this);
                }
            }
            return Optional.empty();
        }
    }
}

