/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves;

import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.common.protection.api.ProtectionProvider;
import eu.pb4.graves.CardboardWarning;
import eu.pb4.graves.GenericModInfo;
import eu.pb4.graves.GraveTextures;
import eu.pb4.graves.GravesApi;
import eu.pb4.graves.compat.AccessoriesCompat;
import eu.pb4.graves.compat.GomlCompat;
import eu.pb4.graves.compat.InventorioCompat;
import eu.pb4.graves.compat.SaveGearOnDeathCompat;
import eu.pb4.graves.compat.TrinketsCompat;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.other.Commands;
import eu.pb4.graves.other.GraveProtectionProvider;
import eu.pb4.graves.other.VanillaInventoryMask;
import eu.pb4.graves.registry.GraveGameRules;
import eu.pb4.graves.registry.GravesRegistry;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GravesMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Universal Graves");
    public static final boolean DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final boolean IS_CLIENT = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    public static ModContainer CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("universal-graves").get();
    public static final List<Runnable> DO_ON_NEXT_TICK = new ArrayList<Runnable>();

    public void onInitialize() {
        CardboardWarning.checkAndAnnounce();
        FabricLoader loader = FabricLoader.getInstance();
        GenericModInfo.build(CONTAINER);
        GravesRegistry.register();
        Commands.register();
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(e -> e.method_45421((class_1935)GravesRegistry.CONTAINER_GRAVE_ITEM));
        GraveTextures.initialize();
        GraveGameRules.register();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            PolymerResourcePackUtils.addModAssets((String)"universal-graves");
        }
        CommonProtection.register((class_2960)class_2960.method_60655((String)"universal_graves", (String)"graves"), (ProtectionProvider)GraveProtectionProvider.INSTANCE);
        GravesApi.registerInventoryMask(class_2960.method_60654((String)"vanilla"), VanillaInventoryMask.INSTANCE);
        if (loader.isModLoaded("goml")) {
            GomlCompat.register();
        }
        if (loader.isModLoaded("inventorio")) {
            InventorioCompat.register();
        }
        if (loader.isModLoaded("accessories")) {
            AccessoriesCompat.register();
        }
        if (loader.isModLoaded("trinkets")) {
            TrinketsCompat.register(loader.isModLoaded("tclayer"));
        }
        if (loader.isModLoaded("sgod")) {
            SaveGearOnDeathCompat.register();
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ConfigManager.loadConfig((class_7225.class_7874)server.method_30611()));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            GraveManager.INSTANCE = null;
            ConfigManager.clearConfig();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> CardboardWarning.checkAndAnnounce());
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world == server.method_30002()) {
                GraveManager.INSTANCE = (GraveManager)world.method_17983().method_17924(GraveManager.getType(world));
                GraveManager.INSTANCE.setServer(server);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(s -> {
            GraveManager.INSTANCE.tick(s);
            ArrayList<Runnable> copied = new ArrayList<Runnable>(DO_ON_NEXT_TICK);
            DO_ON_NEXT_TICK.clear();
            for (Runnable c : copied) {
                try {
                    c.run();
                }
                catch (Throwable e) {
                    LOGGER.error("Error occurred while executing delayed task!", e);
                }
            }
        });
    }
}

