/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.helper;

import net.caffeinemc.mods.sodium.client.render.model.MutableQuadViewImpl;
import net.minecraft.class_1058;
import net.minecraft.class_2350;

public class TextureHelper {
    private static final float NORMALIZER = 0.0625f;
    public static final int BAKE_ROTATE_NONE = 0;
    public static final int BAKE_ROTATE_90 = 1;
    public static final int BAKE_ROTATE_180 = 2;
    public static final int BAKE_ROTATE_270 = 3;
    public static final int BAKE_LOCK_UV = 4;
    public static final int BAKE_FLIP_U = 8;
    public static final int BAKE_FLIP_V = 16;
    public static final int BAKE_NORMALIZED = 32;
    private static final VertexModifier[] ROTATIONS = new VertexModifier[]{null, (q, i) -> q.setUV(i, q.getTexV(i), 1.0f - q.getTexU(i)), (q, i) -> q.setUV(i, 1.0f - q.getTexU(i), 1.0f - q.getTexV(i)), (q, i) -> q.setUV(i, 1.0f - q.getTexV(i), q.getTexU(i))};
    private static final VertexModifier[] UVLOCKERS = new VertexModifier[6];

    private TextureHelper() {
    }

    public static void bakeSprite(MutableQuadViewImpl quad, class_1058 sprite, int bakeFlags) {
        if (quad.getNominalFace() != null && (4 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, UVLOCKERS[quad.getNominalFace().method_10146()]);
        } else if ((0x20 & bakeFlags) == 0) {
            TextureHelper.applyModifier(quad, (q, i) -> q.setUV(i, q.getTexU(i) * 0.0625f, q.getTexV(i) * 0.0625f));
        }
        int rotation = bakeFlags & 3;
        if (rotation != 0) {
            TextureHelper.applyModifier(quad, ROTATIONS[rotation]);
        }
        if ((8 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, (q, i) -> q.setUV(i, 1.0f - q.getTexU(i), q.getTexV(i)));
        }
        if ((0x10 & bakeFlags) != 0) {
            TextureHelper.applyModifier(quad, (q, i) -> q.setUV(i, q.getTexU(i), 1.0f - q.getTexV(i)));
        }
        TextureHelper.interpolate(quad, sprite);
    }

    private static void interpolate(MutableQuadViewImpl q, class_1058 sprite) {
        float uMin = sprite.method_4594();
        float uSpan = sprite.method_4577() - uMin;
        float vMin = sprite.method_4593();
        float vSpan = sprite.method_4575() - vMin;
        for (int i = 0; i < 4; ++i) {
            q.setUV(i, uMin + q.getTexU(i) * uSpan, vMin + q.getTexV(i) * vSpan);
        }
    }

    private static void applyModifier(MutableQuadViewImpl quad, VertexModifier modifier) {
        for (int i = 0; i < 4; ++i) {
            modifier.apply(quad, i);
        }
    }

    static {
        TextureHelper.UVLOCKERS[class_2350.field_11034.method_10146()] = (q, i) -> q.setUV(i, 1.0f - q.getZ(i), 1.0f - q.getY(i));
        TextureHelper.UVLOCKERS[class_2350.field_11039.method_10146()] = (q, i) -> q.setUV(i, q.getZ(i), 1.0f - q.getY(i));
        TextureHelper.UVLOCKERS[class_2350.field_11043.method_10146()] = (q, i) -> q.setUV(i, 1.0f - q.getX(i), 1.0f - q.getY(i));
        TextureHelper.UVLOCKERS[class_2350.field_11035.method_10146()] = (q, i) -> q.setUV(i, q.getX(i), 1.0f - q.getY(i));
        TextureHelper.UVLOCKERS[class_2350.field_11033.method_10146()] = (q, i) -> q.setUV(i, q.getX(i), 1.0f - q.getZ(i));
        TextureHelper.UVLOCKERS[class_2350.field_11036.method_10146()] = (q, i) -> q.setUV(i, q.getX(i), q.getZ(i));
    }

    @FunctionalInterface
    private static interface VertexModifier {
        public void apply(MutableQuadViewImpl var1, int var2);
    }
}

