/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import net.caffeinemc.mods.sodium.client.render.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.helper.ModelHelper;
import net.caffeinemc.mods.sodium.client.render.model.AbstractRenderContext;
import net.caffeinemc.mods.sodium.client.render.model.AmbientOcclusionMode;
import net.caffeinemc.mods.sodium.client.render.model.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.model.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.SodiumShadeMode;
import net.caffeinemc.mods.sodium.client.services.PlatformBlockAccess;
import net.caffeinemc.mods.sodium.client.services.PlatformModelAccess;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jspecify.annotations.Nullable;

public abstract class AbstractBlockRenderContext
extends AbstractRenderContext {
    private final BlockEmitter editorQuad = new BlockEmitter();
    protected class_1920 level;
    protected LevelSlice slice;
    protected class_2680 state;
    protected class_2338 pos;
    protected class_11515 defaultRenderType;
    protected boolean allowDowngrade;
    private final BlockOcclusionCache occlusionCache = new BlockOcclusionCache();
    private boolean enableCulling = true;
    private int cullCompletionFlags;
    private int cullResultFlags;
    protected class_5819 random;
    protected LightPipelineProvider lighters;
    protected final QuadLightData quadLightData = new QuadLightData();
    protected boolean useAmbientOcclusion;
    protected LightMode defaultLightMode = LightMode.FLAT;
    private List<class_10889> parts = new ObjectArrayList();

    @Override
    public MutableQuadViewImpl getForEmitting() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public boolean isFaceCulled(@Nullable class_2350 face) {
        if (face == null || !this.enableCulling) {
            return false;
        }
        int mask = 1 << face.method_10146();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (this.occlusionCache.shouldDrawSide(this.state, (class_1922)this.level, this.pos, face)) {
                this.cullResultFlags |= mask;
                return false;
            }
            return true;
        }
        return (this.cullResultFlags & mask) == 0;
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (this.isFaceCulled(quad.getCullFace())) {
            return;
        }
        this.processQuad(quad);
    }

    protected abstract void processQuad(MutableQuadViewImpl var1);

    protected void prepareCulling(boolean enableCulling) {
        this.enableCulling = enableCulling;
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    protected void prepareAoInfo(boolean modelAo) {
        this.useAmbientOcclusion = class_310.method_1588();
        this.defaultLightMode = this.useAmbientOcclusion && modelAo && this.state != null && PlatformBlockAccess.getInstance().getLightEmission(this.state, this.level, this.pos) == 0 ? LightMode.SMOOTH : LightMode.FLAT;
    }

    protected void shadeQuad(MutableQuadViewImpl quad, LightMode lightMode, boolean emissive, SodiumShadeMode shadeMode) {
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        QuadLightData data = this.quadLightData;
        lighter.calculate(quad, this.pos, data, quad.getCullFace(), quad.getLightFace(), quad.hasShade(), shadeMode == SodiumShadeMode.ENHANCED);
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.setLight(i, 0xF000F0);
            }
        } else {
            int[] lightmaps = data.lm;
            for (int i = 0; i < 4; ++i) {
                quad.setLight(i, ColorHelper.maxBrightness(quad.getLight(i), lightmaps[i]));
            }
        }
    }

    public void bufferDefaultModel(class_10889 part, Predicate<class_2350> cullTest, Consumer<MutableQuadViewImpl> emitter) {
        BlockEmitter editorQuad = this.editorQuad;
        this.prepareAoInfo(part.comp_3751());
        class_11515 renderType = PlatformModelAccess.getInstance().getPartRenderType(part, this.state, this.defaultRenderType);
        class_11515 defaultType = this.defaultRenderType;
        this.defaultRenderType = renderType;
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex(i);
            if (cullTest.test(cullFace)) continue;
            AmbientOcclusionMode ao = PlatformBlockAccess.getInstance().usesAmbientOcclusion(part, this.state, renderType, this.slice, this.pos);
            List<class_777> quads = PlatformModelAccess.getInstance().getQuads(this.level, this.pos, part, this.state, cullFace, this.random, renderType);
            int count = quads.size();
            for (int j = 0; j < count; ++j) {
                class_777 q = quads.get(j);
                editorQuad.fromBakedQuad(q);
                editorQuad.setCullFace(cullFace);
                editorQuad.setRenderType(renderType);
                editorQuad.setAmbientOcclusion(ao.toTriState());
                emitter.accept(editorQuad);
            }
        }
        editorQuad.clear();
        this.defaultRenderType = defaultType;
    }

    public class BlockEmitter
    extends MutableQuadViewImpl {
        public BlockEmitter() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            AbstractBlockRenderContext.this.renderQuad(this);
        }

        public void markInvalidToDowngrade() {
            AbstractBlockRenderContext.this.allowDowngrade = false;
        }

        public void emitPart(class_10889 part, Predicate<@Nullable class_2350> cullTest, Consumer<MutableQuadViewImpl> emitter) {
            AbstractBlockRenderContext.this.bufferDefaultModel(part, cullTest, emitter);
        }
    }
}

