/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import journeymap.client.JourneymapClient;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.BiomeRenderer;
import journeymap.client.cartography.render.CaveRenderer;
import journeymap.client.cartography.render.EndCaveRenderer;
import journeymap.client.cartography.render.EndSurfaceRenderer;
import journeymap.client.cartography.render.NetherCaveRenderer;
import journeymap.client.cartography.render.NetherSurfaceRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.cartography.render.TopoRenderer;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.model.region.RegionImageCache;
import journeymap.client.model.region.RegionImageSet;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import org.apache.logging.log4j.Level;

public class ChunkRenderController {
    private final SurfaceRenderer overWorldSurfaceRenderer = new SurfaceRenderer();
    private final SurfaceRenderer netherSurfaceRenderer;
    private final BaseRenderer netherCaveRenderer;
    private final SurfaceRenderer endSurfaceRenderer;
    private final BaseRenderer endCaveRenderer;
    private final BaseRenderer topoRenderer;
    private final BaseRenderer overWorldCaveRenderer = new CaveRenderer(this.overWorldSurfaceRenderer);
    private final BaseRenderer biomeRenderer;

    public ChunkRenderController() {
        this.netherSurfaceRenderer = new NetherSurfaceRenderer();
        this.netherCaveRenderer = new NetherCaveRenderer();
        this.endSurfaceRenderer = new EndSurfaceRenderer();
        this.endCaveRenderer = new EndCaveRenderer(this.endSurfaceRenderer);
        this.topoRenderer = new TopoRenderer();
        this.biomeRenderer = new BiomeRenderer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseRenderer getRenderer(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd) {
        try {
            RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
            if (!mapType.isUnderground()) {
                if (!class_1937.field_25180.equals(rCoord.dimension)) return this.overWorldSurfaceRenderer;
                return this.netherSurfaceRenderer;
            }
            try (ComparableNativeImage image = regionImageSet.getChunkImage(chunkMd, mapType);){
                if (image == null) return null;
                if (class_1937.field_25180.equals(rCoord.dimension)) {
                    BaseRenderer baseRenderer = this.netherCaveRenderer;
                    return baseRenderer;
                }
                if (class_1937.field_25181.equals(rCoord.dimension)) {
                    BaseRenderer baseRenderer = this.endCaveRenderer;
                    return baseRenderer;
                }
                BaseRenderer baseRenderer = this.overWorldCaveRenderer;
                return baseRenderer;
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toPartialString(t));
        }
        return null;
    }

    public boolean renderChunk(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd, RegionData regionData) {
        boolean renderOkay;
        block42: {
            class_310 mc = class_310.method_1551();
            if (!JourneymapClient.getInstance().isMapping().booleanValue() || chunkMd.getChunk().method_12200().method_27983() != mc.field_1724.method_73183().method_27983() || mc.field_1724.method_73183() != mc.field_1687) {
                return false;
            }
            renderOkay = false;
            try {
                RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
                if (mapType.isUnderground()) {
                    try (ComparableNativeImage chunkSliceImage = regionImageSet.getChunkImage(chunkMd, mapType);){
                        if (chunkSliceImage != null && (renderOkay = class_1937.field_25180.equals(rCoord.dimension) ? this.netherCaveRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice) : (class_1937.field_25181.equals(rCoord.dimension) ? this.endCaveRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice) : this.overWorldCaveRenderer.render(chunkSliceImage, regionData, chunkMd, mapType.vSlice)))) {
                            regionImageSet.setChunkImage(chunkMd, mapType, chunkSliceImage);
                        }
                        break block42;
                    }
                }
                if (mapType.isTopo()) {
                    try (ComparableNativeImage imageTopo = regionImageSet.getChunkImage(chunkMd, MapType.topo(rCoord.dimension));){
                        renderOkay = this.topoRenderer.render(imageTopo, regionData, chunkMd, null);
                        if (renderOkay) {
                            regionImageSet.setChunkImage(chunkMd, MapType.topo(rCoord.dimension), imageTopo);
                        }
                        break block42;
                    }
                }
                if (mapType.isBiome()) {
                    try (ComparableNativeImage imageBiome = regionImageSet.getChunkImage(chunkMd, MapType.biome(rCoord.dimension));){
                        renderOkay = this.biomeRenderer.render(imageBiome, regionData, chunkMd, null);
                        if (renderOkay) {
                            regionImageSet.setChunkImage(chunkMd, MapType.biome(rCoord.dimension), imageBiome);
                        }
                        break block42;
                    }
                }
                try (ComparableNativeImage imageDay = regionImageSet.getChunkImage(chunkMd, MapType.day(rCoord.dimension));
                     ComparableNativeImage imageNight = regionImageSet.getChunkImage(chunkMd, MapType.night(rCoord.dimension));){
                    renderOkay = this.overWorldSurfaceRenderer.render(imageDay, imageNight, regionData, chunkMd);
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, MapType.day(rCoord.dimension), imageDay);
                        regionImageSet.setChunkImage(chunkMd, MapType.night(rCoord.dimension), imageNight);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Journeymap.getLogger().log(Level.WARN, LogFormatter.toString(e));
                return false;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toString(t));
            }
        }
        if (!renderOkay && Journeymap.getLogger().isDebugEnabled()) {
            Journeymap.getLogger().debug(String.format("Chunk %s render failed for %s", chunkMd.getCoord(), mapType));
        }
        return renderOkay;
    }
}

