/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import journeymap.api.services.Services;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.JMLogger;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.mixin.client.LevelRendererAccessor;
import journeymap.common.version.VersionCheck;
import net.minecraft.class_1132;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_4877;
import net.minecraft.class_4905;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;

public class WorldData
extends CacheLoader<Class, WorldData> {
    String name;
    String dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneymapClient.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.INSTANCE.getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            class_310 mc;
            String serverName;
            block9: {
                serverName = null;
                mc = class_310.method_1551();
                if (!mc.method_1496()) {
                    try {
                        class_4905 realmsScreen;
                        class_634 netHandler = mc.method_1562();
                        class_437 callbackScreen = netHandler.field_45593;
                        if (!(callbackScreen instanceof class_4905) || !((realmsScreen = (class_4905)callbackScreen) instanceof class_4325)) break block9;
                        class_4325 mainScreen = (class_4325)realmsScreen;
                        class_4877 selectedServer = mainScreen.method_38503();
                        List realmsServers = StreamSupport.stream(mainScreen.field_39681.spliterator(), false).toList();
                        for (class_4877 realmsServer : realmsServers) {
                            if (realmsServer.field_22599 != selectedServer.field_22599) continue;
                            serverName = realmsServer.field_22601;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                    }
                }
            }
            if (serverName != null) {
                return serverName.replaceAll("\\W+", "~").trim();
            }
            mc = class_310.method_1551();
            class_642 serverData = mc.method_1558();
            if (serverData != null && (serverName = serverData.field_3752) != null) {
                serverName = serverName.replaceAll("\\W+", "~").trim();
                if (Services.COMMON_SERVICE.isModLoaded("essential") || Strings.isNullOrEmpty((String)serverName.replaceAll("~", ""))) {
                    serverName = serverData.field_3761;
                }
                return serverName.replaceAll("\\W+", "~").trim();
            }
            return null;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get service name: " + LogFormatter.toString(t));
            return WorldData.getLegacyServerName().replaceAll("\\W+", "~").trim();
        }
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            class_2535 netManager = class_310.method_1551().method_1562().method_48296();
            if (netManager != null && (socketAddress = netManager.method_10755()) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    public static String getWorldName(class_310 mc) {
        String serverName = null;
        if (mc.method_1496()) {
            return mc.method_1576().field_23784.method_27005();
        }
        serverName = WorldData.getServerName();
        if (serverName == null) {
            return "offline";
        }
        if (Strings.isNullOrEmpty((String)serverName.trim())) {
            serverName = "unnamed";
        }
        return serverName.trim();
    }

    public static List<DimensionProvider> getDimensionProviders() {
        return WorldData.getDimensionProviders(Lists.newArrayList());
    }

    public static List<DimensionProvider> getDimensionProviders(List<String> requiredDimensionList) {
        try {
            HashSet<String> requiredDims = new HashSet<String>(requiredDimensionList);
            HashMap<String, DimensionProvider> dimProviders = new HashMap<String, DimensionProvider>();
            Level logLevel = Level.DEBUG;
            Journeymap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            class_310 mc = class_310.method_1551();
            class_5321<class_1937> dimension = DimensionHelper.getDimension((class_1297)mc.field_1724);
            String dimId = DimensionHelper.getDimKeyName(dimension);
            WrappedProvider playerDimProvider = new WrappedProvider(dimension);
            dimProviders.put(dimId, playerDimProvider);
            requiredDims.remove(dimId);
            Journeymap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", dimId, WorldData.getSafeDimensionName(playerDimProvider)));
            for (class_5321<class_1937> class_53212 : DimensionHelper.getClientDimList()) {
                try {
                    WrappedProvider dimProvider = new WrappedProvider(class_53212);
                    dimProviders.put(DimensionHelper.getDimKeyName(class_53212), dimProvider);
                    Journeymap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", class_53212, WorldData.getSafeDimensionName(dimProvider)));
                }
                catch (Throwable t) {
                    JMLogger.throwLogOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", class_53212, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (String string : requiredDims) {
                if (dimProviders.containsKey(string)) continue;
                dimProviders.put(string, new DummyProvider(DimensionHelper.getWorldKeyForName(string)));
                Journeymap.getLogger().warn(String.format("Used DummyProvider for required dim: %s", string));
            }
            ArrayList<DimensionProvider> providerList = new ArrayList<DimensionProvider>(dimProviders.values());
            Collections.sort(providerList, (o1, o2) -> String.valueOf(o1.getDimensionId()).compareTo(o2.getDimensionId()));
            return providerList;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(DimensionProvider dimensionProvider) {
        if (dimensionProvider == null || dimensionProvider.getDimensionId() == null) {
            return null;
        }
        try {
            return dimensionProvider.getDimensionId();
        }
        catch (Exception e) {
            class_310 mc = class_310.method_1551();
            return Constants.getString("jm.common.dimension", DimensionHelper.getDimName((class_1937)mc.field_1687));
        }
    }

    public static String getDimension() {
        class_746 player = class_310.method_1551().field_1724;
        String dim = DimensionHelper.getDimName((class_1297)player);
        String dimName = WorldData.getSafeDimensionName(new WrappedProvider((class_5321<class_1937>)class_310.method_1551().field_1724.method_73183().method_27983()));
        return dimName + " (" + dim + ")";
    }

    public static String getCurrentWeather() {
        String weather = "jm.common.info_slot.weather.clear";
        if (class_310.method_1551().field_1687.method_8419()) {
            weather = "jm.common.info_slot.weather.rain";
            if (class_310.method_1551().field_1687.method_8546()) {
                weather = "jm.common.info_slot.weather.thunder";
            }
        }
        return Constants.getString("jm.common.info_slot.weather.label", Constants.getString(weather));
    }

    public static String getDay() {
        long days = class_310.method_1551().field_1687.method_75260() / 24000L;
        return Constants.getString("jm.theme.infoslot.day", days);
    }

    public WorldData load(Class aClass) throws Exception {
        class_310 mc = class_310.method_1551();
        class_638.class_5271 worldInfo = mc.field_1687.method_28104();
        class_1132 server = mc.method_1576();
        boolean multiplayer = server == null || server.method_3860();
        this.name = WorldData.getWorldName(mc);
        this.dimension = DimensionHelper.getDimKeyName((class_1937)mc.field_1687);
        this.hardcore = worldInfo.method_152();
        this.singlePlayer = !multiplayer;
        this.time = mc.field_1687.method_8532() % 24000L;
        this.features = FeatureManager.getInstance().getAllowedFeatures();
        this.mod_name = JourneymapClient.MOD_NAME;
        this.jm_version = Journeymap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = class_155.method_16673().comp_4025();
        return this;
    }

    public static String getLightLevel() {
        class_2338 blockpos = class_310.method_1551().field_1724.method_24515();
        class_638 world = class_310.method_1551().field_1687;
        class_2818 chunk = world.method_8500(blockpos);
        int light = chunk.method_12200().method_22336().method_22363(blockpos, 0);
        int lightSky = world.method_8314(class_1944.field_9284, blockpos);
        int lightBlock = world.method_8314(class_1944.field_9282, blockpos);
        return String.format("Light: %s (%s sky, %s block)", light, lightSky, lightBlock);
    }

    public static String getRegion() {
        class_2338 blockpos = class_310.method_1551().field_1724.method_24515();
        class_2818 chunk = class_310.method_1551().field_1687.method_8500(blockpos);
        RegionCoord regionCoord = RegionCoord.fromChunkPos(null, MapType.none(), chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        return "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
    }

    public static String getRealGameTime() {
        String format = JourneymapClient.getInstance().getActiveMiniMapProperties().infoSlotTimeFormat.get();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        class_310 minecraft = class_310.method_1551();
        long time = minecraft.field_1687.method_8532();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        double ticks = (double)time - Math.floor((double)time / 16.666666666666668) * 16.666666666666668;
        long seconds = (long)Math.floor(ticks / 0.2777777777777778);
        try {
            String timeString = String.format(Locale.ENGLISH, "%02d:%02d:%02d", Math.max(0L, hour), Math.max(0L, minute), Math.max(0L, seconds));
            String formattedTime = LocalTime.parse(timeString).format(dtf);
            return formattedTime + " " + WorldData.getContextTime(time % 24000L);
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Unable to calculate time for GameTimeReal time:{}, hour:{}, minute:{}, seconds:{}, ticks:{}", (Object)time, (Object)hour, (Object)minute, (Object)ticks, (Object)seconds, (Object)e);
            return "00e:00e:00e";
        }
    }

    public static String getGameTime() {
        if (class_310.method_1551().field_1687 != null) {
            long worldTime = class_310.method_1551().field_1687.method_8532() % 24000L;
            long allSecs = worldTime / 20L;
            String format = JourneymapClient.getInstance().getActiveMiniMapProperties().infoSlotTimeFormat.get().replace(":ss", "").replace(" a", "");
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
            String timeString = String.format(Locale.ENGLISH, "%02d:%02d", Math.max(0L, (long)Math.floor((double)allSecs / 60.0)), Math.max(0L, (long)Math.ceil(allSecs % 60L)));
            String formattedTime = LocalTime.parse(timeString).format(dtf);
            return formattedTime + " " + WorldData.getContextTime(worldTime);
        }
        return "";
    }

    public static String getMovementSpeed() {
        class_746 player = class_310.method_1551().field_1724;
        class_243 playerPos = player.method_73189();
        double travelX = playerPos.field_1352 - player.field_6038;
        double travelZ = playerPos.field_1350 - player.field_5989;
        double currentSpeed = class_3532.method_15355((float)((float)(travelX * travelX + travelZ * travelZ))) / 0.05f;
        double currentVertSpeed = (playerPos.field_1351 - player.field_5971) / (double)0.05f;
        return Constants.getString("jm.common.info_slot.movement_speed.game", String.format("%.2f", currentSpeed));
    }

    public static String getMoonPhase() {
        LevelRendererAccessor renderer = (LevelRendererAccessor)class_310.method_1551().field_1769;
        int phase = renderer.getLevelRenderState().field_63087.field_63096.method_75261();
        long worldTime = class_310.method_1551().field_1687.method_8532() % 24000L;
        if (WorldData.isDay(worldTime)) {
            phase = 10;
        }
        return MoonPhase.fromPhase(phase);
    }

    public static String getSystemTime() {
        SimpleDateFormat timeFormat = new SimpleDateFormat(JourneymapClient.getInstance().getActiveMiniMapProperties().systemTimeRealFormat.get());
        return timeFormat.format(new Date());
    }

    private static String getContextTime(long worldTime) {
        if (worldTime < 12000L) {
            return TimeValue.DAYTIME.getText();
        }
        if (worldTime < 13800L) {
            return TimeValue.SUNSET.getText();
        }
        if (worldTime < 22200L) {
            return TimeValue.NIGHT.getText();
        }
        return TimeValue.SUNRISE.getText();
    }

    public static boolean isDay(long worldTime) {
        return worldTime % 24000L < 13800L;
    }

    public static boolean isNight(long worldTime) {
        return worldTime % 24000L >= 13800L;
    }

    public long getTTL() {
        return 1000L;
    }

    public static class WrappedProvider
    implements DimensionProvider {
        class_5321<class_1937> dimension;

        public WrappedProvider(class_5321<class_1937> dimension) {
            this.dimension = dimension;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dimension);
        }

        @Override
        public class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        @Override
        public String getName() {
            Object dim = DimensionHelper.getDimName(this.dimension).replace("_", " ");
            if (((String)dim).length() > 25) {
                String pre = ((String)dim).substring(0, 9);
                String suffix = ((String)dim).substring(((String)dim).length() - 5, ((String)dim).length() - 1);
                dim = pre + " ... " + suffix;
            }
            return WordUtils.capitalize((String)dim);
        }
    }

    public static interface DimensionProvider {
        public String getDimensionId();

        public class_5321<class_1937> getDimension();

        public String getName();
    }

    static class DummyProvider
    implements DimensionProvider {
        final class_5321<class_1937> dim;

        DummyProvider(class_5321<class_1937> dim) {
            this.dim = dim;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dim);
        }

        @Override
        public class_5321<class_1937> getDimension() {
            return null;
        }

        @Override
        public String getName() {
            return "Dimension " + DimensionHelper.getDimName(this.dim);
        }
    }

    static enum MoonPhase {
        DAY_TIME(10, "jm.theme.labelsource.moonphase.day"),
        FULL_MOON(0, "jm.theme.labelsource.moonphase.full_moon"),
        WANING_GIBBOUS(1, "jm.theme.labelsource.moonphase.waning_gibbous"),
        THIRD_QUARTER(2, "jm.theme.labelsource.moonphase.third_quarter"),
        WANING_CRESCENT(3, "jm.theme.labelsource.moonphase.waning_crescent"),
        NEW_MOON(4, "jm.theme.labelsource.moonphase.new_moon"),
        WAXING_CRESCENT(5, "jm.theme.labelsource.moonphase.waxing_crescent"),
        FIRST_QUARTER(6, "jm.theme.labelsource.moonphase.first_quarter"),
        WAXING_GIBBOUS(7, "jm.theme.labelsource.moonphase.waxing_gibbous");

        final int phase;
        final String key;
        static final Map<Integer, String> PHASE_MAP;

        private MoonPhase(int phase, String key) {
            this.phase = phase;
            this.key = key;
        }

        public static String fromPhase(int phase) {
            String phaseName = Constants.getString(PHASE_MAP.get(phase));
            String moonPhase = Constants.getString("jm.theme.labelsource.moonphase.pre");
            return moonPhase + phaseName;
        }

        static {
            PHASE_MAP = Stream.of(MoonPhase.values()).collect(Collectors.toMap(e -> e.phase, e -> e.key));
        }
    }

    static enum TimeValue {
        DAYTIME("jm.theme.labelsource.gametime.day"),
        SUNRISE("jm.theme.labelsource.gametime.sunrise"),
        SUNSET("jm.theme.labelsource.gametime.sunset"),
        NIGHT("jm.theme.labelsource.gametime.night");

        final String key;

        private TimeValue(String key) {
            this.key = key;
        }

        public String getText() {
            return Constants.getString(this.key);
        }
    }
}

