/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.io.Files;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.log.LogFormatter;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.class_3518;

public class LegacyWaypointFileMigrator {
    public static List<ClientWaypointImpl> loadWaypoints(File waypointDir) {
        ArrayList<ClientWaypointImpl> waypoints = new ArrayList<ClientWaypointImpl>();
        File[] files = waypointDir.listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null) {
            return waypoints;
        }
        Journeymap.getLogger().info("{} Legacy waypoints found that need to be migrated and backed up.", (Object)files.length);
        for (File waypointFile : files) {
            ClientWaypointImpl wp = LegacyWaypointFileMigrator.load(waypointDir, waypointFile);
            if (wp == null) continue;
            waypoints.add(wp);
        }
        return waypoints;
    }

    private static ClientWaypointImpl load(File waypointDir, File waypointFile) {
        String waypointString = null;
        try {
            waypointString = Files.asCharSource((File)waypointFile, (Charset)StandardCharsets.UTF_8).read();
            JsonObject waypointJson = class_3518.method_15285((String)waypointString);
            WaypointImpl wp = (WaypointImpl)WaypointCodecs.WAYPOINT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)waypointJson).result().get();
            File backupDir = new File(waypointDir, "backup");
            Journeymap.getLogger().info("\"{}\" successfully migrated, backing up to {}\\\\{}", (Object)wp.getName(), (Object)backupDir.getAbsolutePath(), (Object)waypointFile.getName());
            LegacyWaypointFileMigrator.backupWaypoint(backupDir, waypointFile);
            LegacyWaypointFileMigrator.remove(waypointFile);
            return (ClientWaypointImpl)wp;
        }
        catch (Throwable e) {
            Journeymap.getLogger().error("Can't load waypoint file {} with contents: {} because: ", (Object)waypointFile, (Object)waypointString, (Object)e);
            return null;
        }
    }

    private static void remove(File waypointFile) {
        try {
            waypointFile.delete();
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Can't delete waypoint file {}: ", (Object)waypointFile, (Object)e);
            waypointFile.deleteOnExit();
        }
    }

    private static void backupWaypoint(File backupDir, File waypointFile) {
        try {
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            File file = new File(backupDir, waypointFile.getName());
            Files.copy((File)waypointFile, (File)file);
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't backup waypoint file %s: %s", waypointFile, LogFormatter.toString(e)));
        }
    }
}

