/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum WaypointOrigin {
    SERVER("server"),
    COMMAND("command"),
    EXTERNAL("external"),
    EXTERNAL_FORCE("external-force"),
    TEMP("temp");

    final String value;
    private static final Map<String, WaypointOrigin> values;
    private static final Map<String, WaypointOrigin> valueMap;

    private WaypointOrigin(String value) {
        this.value = value;
    }

    public static WaypointOrigin from(String string) {
        return values.get(string);
    }

    public static WaypointOrigin fromValue(String string) {
        return valueMap.get(string);
    }

    public String getValue() {
        return this.value;
    }

    public static Set<String> getValues() {
        return values.keySet();
    }

    static {
        values = new HashMap<String, WaypointOrigin>();
        for (WaypointOrigin o : WaypointOrigin.values()) {
            values.put(o.name(), o);
        }
        valueMap = new HashMap<String, WaypointOrigin>();
        for (WaypointOrigin o : WaypointOrigin.values()) {
            valueMap.put(o.getValue(), o);
        }
    }
}

