/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynresources;

import com.google.common.collect.Collections2;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicRegistryMap<K, V>
implements Map<K, V> {
    private static final Object NULL_OVERRIDE = new Object();
    private final Set<K> originalKeys;
    private final Function<K, V> fallbackGetter;
    private final ConcurrentHashMap<K, Object> overrides;
    private final EntrySet entrySet;

    public DynamicRegistryMap(Set<K> originalKeys, Function<K, V> fallbackGetter) {
        this.originalKeys = originalKeys;
        this.fallbackGetter = fallbackGetter;
        this.overrides = new ConcurrentHashMap();
        this.entrySet = new EntrySet();
    }

    @Override
    public int size() {
        return this.originalKeys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.originalKeys.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        if (o == null) {
            return false;
        }
        Object override = this.overrides.get(o);
        if (override == NULL_OVERRIDE) {
            return false;
        }
        return override != null || this.originalKeys.contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        if (o == null || o == NULL_OVERRIDE) {
            return false;
        }
        return this.overrides.containsValue(o);
    }

    @Override
    public V get(Object o) {
        Object value = this.overrides.get(o);
        if (value == NULL_OVERRIDE) {
            return null;
        }
        if (value != null) {
            return (V)value;
        }
        return this.fallbackGetter.apply(o);
    }

    @Override
    @Nullable
    public V put(K k, V v) {
        if (v == null) {
            return this.remove(k);
        }
        this.overrides.put(k, v);
        return null;
    }

    @Override
    public V remove(Object o) {
        this.overrides.put(o, NULL_OVERRIDE);
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.originalKeys);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return Collections2.transform(this.originalKeys, this::get);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator iterator = DynamicRegistryMap.this.originalKeys.iterator();
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new ModelEntry(iterator.next());
                }
            };
        }

        @Override
        public int size() {
            return DynamicRegistryMap.this.size();
        }
    }

    private class ModelEntry
    implements Map.Entry<K, V> {
        private final K key;

        private ModelEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return DynamicRegistryMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return DynamicRegistryMap.this.put(this.key, value);
        }
    }
}

