/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Op;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.ExposedBlob;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.PreparedStatementApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.RowApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.H2Dialect;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J)\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/BlobColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/ExposedBlob;", "", "useObjectIdentifier", "<init>", "(Z)V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/ExposedBlob;", "nonNullValueToString", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/ExposedBlob;)Ljava/lang/String;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;", "rs", "", "index", "readObject", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/RowApi;I)Ljava/lang/Object;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/PreparedStatementApi;", "stmt", "", "setParameter", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/PreparedStatementApi;ILjava/lang/Object;)V", "Z", "getUseObjectIdentifier", "()Z", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/v1/core/BlobColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1449:1\n1#2:1450\n*E\n"})
public final class BlobColumnType
extends ColumnType<ExposedBlob> {
    private final boolean useObjectIdentifier;

    public BlobColumnType(boolean useObjectIdentifier) {
        super(false, 1, null);
        this.useObjectIdentifier = useObjectIdentifier;
    }

    public /* synthetic */ BlobColumnType(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getUseObjectIdentifier() {
        return this.useObjectIdentifier;
    }

    @Override
    @NotNull
    public String sqlType() {
        String string;
        if (this.useObjectIdentifier && DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect) {
            string = "oid";
        } else {
            if (this.useObjectIdentifier) {
                throw new IllegalStateException("Storing BLOBs using OID columns is only supported by PostgreSQL".toString());
            }
            string = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().blobType();
        }
        return string;
    }

    @Override
    @NotNull
    public ExposedBlob valueFromDB(@NotNull Object value) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof ExposedBlob) {
            exposedBlob = (ExposedBlob)value;
        } else if (object instanceof InputStream) {
            exposedBlob = new ExposedBlob((InputStream)value);
        } else if (object instanceof byte[]) {
            exposedBlob = new ExposedBlob((byte[])value);
        } else if (object instanceof Blob) {
            InputStream inputStream = ((Blob)value).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getBinaryStream(...)");
            exposedBlob = new ExposedBlob(inputStream);
        } else if (object instanceof ByteBuffer) {
            byte[] byArray = ((ByteBuffer)value).array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            exposedBlob = new ExposedBlob(byArray);
        } else {
            throw new IllegalStateException(("Unexpected value of type Blob: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return exposedBlob;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull ExposedBlob value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Object object = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if (object == null || (object = ((H2Dialect)object).getOriginalDataTypeProvider()) == null) {
            object = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider();
        }
        return ((DataTypeProvider)object).hexToDb(value.hexString());
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect && this.useObjectIdentifier) {
            Object object2 = rs.getObject(index, Blob.class);
            if (object2 != null && (object2 = object2.getBinaryStream()) != null) {
                Object p0 = object2;
                boolean bl = false;
                object = new ExposedBlob((InputStream)p0);
            } else {
                object = null;
            }
        } else {
            object = rs.getObject(index);
        }
        return object;
    }

    @Override
    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value) {
        Object toSetValue;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Object object = value instanceof ExposedBlob ? (ExposedBlob)value : null;
        if (object == null || (object = ((ExposedBlob)object).getInputStream()) == null) {
            object = value;
        }
        if ((toSetValue = object) instanceof InputStream) {
            stmt.setInputStream(index, (InputStream)toSetValue, this.useObjectIdentifier);
        } else if (toSetValue == null || toSetValue instanceof Op.NULL) {
            stmt.setNull(index, this);
        } else {
            super.setParameter(stmt, index, toSetValue);
        }
    }

    public BlobColumnType() {
        this(false, 1, null);
    }
}

