/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.ColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/core/DoubleColumnType;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/ColumnType;", "", "<init>", "()V", "", "sqlType", "()Ljava/lang/String;", "", "value", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Double;", "nonNullValueAsDefaultString", "(D)Ljava/lang/String;", "exposed-core"})
public final class DoubleColumnType
extends ColumnType<Double> {
    public DoubleColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().doubleType();
    }

    @Override
    @NotNull
    public Double valueFromDB(@NotNull Object value) {
        double d;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Double) {
            d = ((Number)value).doubleValue();
        } else if (object instanceof Float) {
            d = Double.parseDouble(String.valueOf(((Number)value).floatValue()));
        } else if (object instanceof Number) {
            d = ((Number)value).doubleValue();
        } else if (object instanceof String) {
            d = Double.parseDouble((String)value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Double: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return d;
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(double value) {
        String it = String.valueOf(value);
        boolean bl = false;
        return DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect && StringsKt.endsWith$default((String)it, (String)".0", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)it, (String)".0", (String)"", (boolean)false, (int)4, null) : it;
    }
}

