/*
 * Decompiled with CFR 0.152.
 */
package me.jfenn.coordshud.jetbrains.exposed.v1.jdbc;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.CompositeSqlLogger;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.IColumnType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SQLLogKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.SqlLogger;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.Transaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.GlobalStatementInterceptor;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.Statement;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.StatementContext;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.StatementInterceptor;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.StatementResult;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.StatementType;
import me.jfenn.coordshud.jetbrains.exposed.v1.core.statements.api.ResultApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.exceptions.LongQueryException;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.Database;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.BlockingExecutable;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.BlockingExecutableKt;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.api.ExposedConnection;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.api.JdbcPreparedStatementApi;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.statements.jdbc.JdbcResult;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.transactions.JdbcTransactionInterface;
import me.jfenn.coordshud.jetbrains.exposed.v1.jdbc.transactions.JdbcTransactionInterfaceKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 \u0082\u00012\u00020\u00012\u00020\u0002:\u0002\u0082\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JG\u0010\u001d\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0013\u001a\u00020\u00122 \b\u0002\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00170\u00162\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJg\u0010\u001d\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u001f*\u00020\u00192\b\b\u0001\u0010\u0013\u001a\u00020\u00122 \b\u0002\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00170\u00162\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0006\u0012\u0004\u0018\u00018\u00000 \u00a2\u0006\u0004\b\u001d\u0010#J'\u0010\u001d\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u001f2\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030$\u00a2\u0006\u0004\b\u001d\u0010%J\u001b\u0010(\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120&\u00a2\u0006\u0004\b(\u0010)JR\u0010\u001d\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010\u001f\"\u0004\b\u0001\u0010*2\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030$2#\u0010.\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000,\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010+\u00a2\u0006\u0002\b-\u00a2\u0006\u0004\b\u001d\u0010/JL\u00102\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010*2\u0010\u00101\u001a\f\u0012\u0004\u0012\u000200\u0012\u0002\b\u00030$2#\u0010.\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002000,\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00028\u00000+\u00a2\u0006\u0002\b-\u00a2\u0006\u0004\b2\u0010/J!\u00102\u001a\u00020!2\u0010\u00101\u001a\f\u0012\u0004\u0012\u000200\u0012\u0002\b\u00030$H\u0000\u00a2\u0006\u0004\b3\u00104J\r\u00105\u001a\u00020\u0006\u00a2\u0006\u0004\b5\u0010\bJ!\u0010:\u001a\u0002092\u0012\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020706\"\u000207\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010>\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b<\u0010=J\u0010\u0010?\u001a\u00020\u0006H\u0096\u0001\u00a2\u0006\u0004\b?\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010@R\u0017\u0010B\u001a\u00020A8\u0006\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010ER*\u0010H\u001a\u00020F2\u0006\u0010G\u001a\u00020F8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\"\u0010N\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010=\"\u0004\bQ\u0010RR\"\u0010S\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bS\u0010O\u001a\u0004\bT\u0010=\"\u0004\bU\u0010RR$\u0010W\u001a\u0004\u0018\u00010V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R(\u0010]\u001a\b\u0012\u0002\b\u0003\u0018\u00010,8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b]\u0010^\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\"\u0010c\u001a\u00020\f8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010d\u001a\u0004\be\u0010f\"\u0004\bg\u0010hR \u0010j\u001a\b\u0012\u0004\u0012\u00020V0i8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bj\u0010k\u001a\u0004\bl\u0010mR\"\u0010n\u001a\u00020F8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\bn\u0010I\u001a\u0004\bo\u0010K\"\u0004\bp\u0010MR*\u0010s\u001a\u0012\u0012\u0004\u0012\u00020\n0qj\b\u0012\u0004\u0012\u00020\n`r8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bs\u0010t\u001a\u0004\bu\u0010vR\u0018\u0010z\u001a\u0006\u0012\u0002\b\u00030w8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bx\u0010yR\u0016\u0010}\u001a\u0004\u0018\u00010\u00008\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b{\u0010|R\u0014\u0010\u007f\u001a\u00020\f8\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b~\u0010fR\u0016\u0010\u0081\u0001\u001a\u00020F8\u0016X\u0096\u0005\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u0010K\u00a8\u0006\u0083\u0001"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/Transaction;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterface;", "transactionImpl", "<init>", "(Lorg/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterface;)V", "", "commit", "()V", "rollback", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/StatementInterceptor;", "interceptor", "", "registerInterceptor", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/StatementInterceptor;)Z", "unregisterInterceptor", "", "delta", "", "stmt", "describeStatement", "(JLjava/lang/String;)Ljava/lang/String;", "", "Lkotlin/Pair;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/IColumnType;", "", "args", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/StatementType;", "explicitStatementType", "exec", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/v1/core/statements/StatementType;)Lkotlin/Unit;", "T", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "transform", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/v1/core/statements/StatementType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;", "(Lorg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;)Ljava/lang/Object;", "", "stmts", "execInBatch", "(Ljava/util/List;)V", "R", "Lkotlin/Function2;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/Statement;", "Lkotlin/ExtensionFunctionType;", "body", "(Lorg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/api/ResultApi;", "query", "execQuery", "execQuery$exposed_jdbc", "(Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;)Ljava/sql/ResultSet;", "closeExecutedStatements", "", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/SqlLogger;", "logger", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/CompositeSqlLogger;", "addLogger", "([Lorg/jetbrains/exposed/v1/core/SqlLogger;)Lorg/jetbrains/exposed/v1/core/CompositeSqlLogger;", "getRetryInterval$exposed_jdbc", "()J", "getRetryInterval", "close", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterface;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "db", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/Database;", "getDb", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "", "value", "maxAttempts", "I", "getMaxAttempts", "()I", "setMaxAttempts", "(I)V", "minRetryDelay", "J", "getMinRetryDelay", "setMinRetryDelay", "(J)V", "maxRetryDelay", "getMaxRetryDelay", "setMaxRetryDelay", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;", "currentStatement", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;", "getCurrentStatement", "()Lorg/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;", "setCurrentStatement", "(Lorg/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;)V", "explainStatement", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/Statement;", "getExplainStatement$exposed_jdbc", "()Lorg/jetbrains/exposed/v1/core/statements/Statement;", "setExplainStatement$exposed_jdbc", "(Lorg/jetbrains/exposed/v1/core/statements/Statement;)V", "blockStatementExecution", "Z", "getBlockStatementExecution$exposed_jdbc", "()Z", "setBlockStatementExecution$exposed_jdbc", "(Z)V", "", "executedStatements", "Ljava/util/List;", "getExecutedStatements$exposed_jdbc", "()Ljava/util/List;", "openResultSetsCount", "getOpenResultSetsCount$exposed_jdbc", "setOpenResultSetsCount$exposed_jdbc", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "interceptors", "Ljava/util/ArrayList;", "getInterceptors$exposed_jdbc", "()Ljava/util/ArrayList;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "connection", "getOuterTransaction", "()Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "outerTransaction", "getReadOnly", "readOnly", "getTransactionIsolation", "transactionIsolation", "Companion", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcTransaction.kt\norg/jetbrains/exposed/v1/jdbc/JdbcTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,305:1\n1#2:306\n1869#3,2:307\n1869#3,2:309\n1869#3,2:311\n1869#3,2:313\n1869#3,2:315\n1869#3,2:317\n1869#3,2:319\n1869#3,2:321\n1869#3,2:330\n1563#3:332\n1634#3,3:333\n1869#3,2:336\n384#4,7:323\n*S KotlinDebug\n*F\n+ 1 JdbcTransaction.kt\norg/jetbrains/exposed/v1/jdbc/JdbcTransaction\n*L\n74#1:307,2\n78#1:309,2\n84#1:311,2\n85#1:313,2\n90#1:315,2\n91#1:317,2\n93#1:319,2\n94#1:321,2\n273#1:330,2\n215#1:332\n215#1:333,3\n299#1:336,2\n222#1:323,7\n*E\n"})
public class JdbcTransaction
extends Transaction
implements JdbcTransactionInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdbcTransactionInterface transactionImpl;
    @NotNull
    private final Database db;
    private int maxAttempts;
    private long minRetryDelay;
    private long maxRetryDelay;
    @Nullable
    private JdbcPreparedStatementApi currentStatement;
    @Nullable
    private Statement<?> explainStatement;
    private boolean blockStatementExecution;
    @NotNull
    private final List<JdbcPreparedStatementApi> executedStatements;
    private int openResultSetsCount;
    @NotNull
    private final ArrayList<StatementInterceptor> interceptors;
    @NotNull
    private static final ArrayList<GlobalStatementInterceptor> globalInterceptors = new ArrayList();

    public JdbcTransaction(@NotNull JdbcTransactionInterface transactionImpl) {
        Intrinsics.checkNotNullParameter((Object)transactionImpl, (String)"transactionImpl");
        this.transactionImpl = transactionImpl;
        this.db = this.transactionImpl.getDb();
        this.maxAttempts = JdbcTransactionInterfaceKt.getTransactionManager(this.db).getDefaultMaxAttempts();
        this.minRetryDelay = JdbcTransactionInterfaceKt.getTransactionManager(this.db).getDefaultMinRetryDelay();
        this.maxRetryDelay = JdbcTransactionInterfaceKt.getTransactionManager(this.db).getDefaultMaxRetryDelay();
        this.executedStatements = new ArrayList();
        this.interceptors = new ArrayList();
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{this.db.getConfig().getSqlLogger()};
        this.addLogger(sqlLoggerArray);
    }

    @Override
    @NotNull
    public final Database getDb() {
        return this.db;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final void setMaxAttempts(int value) {
        if (!(value > 0)) {
            boolean bl = false;
            String string = "maxAttempts must be set to perform at least 1 attempt.";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxAttempts = value;
    }

    public final long getMinRetryDelay() {
        return this.minRetryDelay;
    }

    public final void setMinRetryDelay(long l) {
        this.minRetryDelay = l;
    }

    public final long getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public final void setMaxRetryDelay(long l) {
        this.maxRetryDelay = l;
    }

    @Nullable
    public final JdbcPreparedStatementApi getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(@Nullable JdbcPreparedStatementApi jdbcPreparedStatementApi) {
        this.currentStatement = jdbcPreparedStatementApi;
    }

    @Nullable
    public final Statement<?> getExplainStatement$exposed_jdbc() {
        return this.explainStatement;
    }

    public final void setExplainStatement$exposed_jdbc(@Nullable Statement<?> statement) {
        this.explainStatement = statement;
    }

    public final boolean getBlockStatementExecution$exposed_jdbc() {
        return this.blockStatementExecution;
    }

    public final void setBlockStatementExecution$exposed_jdbc(boolean bl) {
        this.blockStatementExecution = bl;
    }

    @NotNull
    public final List<JdbcPreparedStatementApi> getExecutedStatements$exposed_jdbc() {
        return this.executedStatements;
    }

    public final int getOpenResultSetsCount$exposed_jdbc() {
        return this.openResultSetsCount;
    }

    public final void setOpenResultSetsCount$exposed_jdbc(int n) {
        this.openResultSetsCount = n;
    }

    @NotNull
    public final ArrayList<StatementInterceptor> getInterceptors$exposed_jdbc() {
        return this.interceptors;
    }

    @Override
    public void commit() {
        StatementInterceptor it;
        HashMap dataToStore = new HashMap();
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit(this);
        }
        this.transactionImpl.commit();
        this.getUserdata().clear();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit(this);
        }
        this.getUserdata().putAll(dataToStore);
    }

    @Override
    public void rollback() {
        StatementInterceptor it;
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback(this);
        }
        this.transactionImpl.rollback();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback(this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback(this);
        }
        this.getUserdata().clear();
    }

    public final boolean registerInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.add(interceptor);
    }

    public final boolean unregisterInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.remove(interceptor);
    }

    private final String describeStatement(long delta, String stmt) {
        return "" + '[' + delta + "ms] " + StringsKt.take((String)stmt, (int)1024) + "\n\n";
    }

    @Nullable
    public final Unit exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args, @Nullable StatementType explicitStatementType) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return (Unit)this.exec(stmt, args, explicitStatementType, JdbcTransaction::exec$lambda$9);
    }

    public static /* synthetic */ Unit exec$default(JdbcTransaction jdbcTransaction, String string, Iterable iterable, StatementType statementType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return jdbcTransaction.exec(string, iterable, statementType);
    }

    @Nullable
    public final <T> T exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args, @Nullable StatementType explicitStatementType, @NotNull Function1<? super ResultSet, ? extends T> transform) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        if (((CharSequence)stmt).length() == 0) {
            return null;
        }
        StatementType statementType = explicitStatementType;
        if (statementType == null) {
            Object v1;
            block4: {
                Iterable iterable = (Iterable)StatementType.getEntries();
                for (Object t : iterable) {
                    StatementType it = (StatementType)((Object)t);
                    boolean bl = false;
                    if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)stmt)).toString(), (String)it.name(), (boolean)true)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((statementType = (StatementType)v1) == null) {
                statementType = StatementType.OTHER;
            }
        }
        StatementType type = statementType;
        List list = CollectionsKt.emptyList();
        return this.exec(new BlockingExecutable<T, Statement<? extends T>>(type, transform, stmt, args, list){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            final /* synthetic */ String $stmt;
            final /* synthetic */ Iterable<Pair<IColumnType<?>, Object>> $args;
            {
                this.$type = $type;
                this.$transform = $transform;
                this.$stmt = $stmt;
                this.$args = $args;
                super($type, $super_call_param$1);
            }

            public Statement<T> getStatement() {
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public T executeInternal(JdbcPreparedStatementApi $this$executeInternal, JdbcTransaction transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                switch (exec.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v0 = $this$executeInternal.executeQuery();
                        break;
                    }
                    case 5: {
                        $this$firstOrNull$iv = $this$executeInternal.executeMultiple();
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (StatementResult)element$iv;
                            $i$a$-firstOrNull-JdbcTransaction$exec$2$executeInternal$result$result$1 = false;
                            if (!(it instanceof StatementResult.Object)) continue;
                            v1 = element$iv;
                            ** GOTO lbl17
                        }
                        v1 = null;
lbl17:
                        // 2 sources

                        result = v1;
                        v2 = result instanceof StatementResult.Object != false ? (StatementResult.Object)result : null;
                        if (v2 != null) {
                            v0 = v2.getResultSet();
                            break;
                        }
                        v0 = null;
                        break;
                    }
                    default: {
                        $this$executeInternal.executeUpdate();
                        v0 = result = (ResultApi)$this$executeInternal.getResultSet();
                    }
                }
                if ((v3 /* !! */  = result instanceof JdbcResult != false ? (JdbcResult)result : null) != null && (v3 /* !! */  = v3 /* !! */ .getResult()) != null) {
                    var4_13 = v3 /* !! */ ;
                    var5_3 = this.$transform;
                    var6_5 = null;
                    try {
                        it = (ResultSet)var4_13;
                        $i$a$-use-JdbcTransaction$exec$2$executeInternal$1 = false;
                        var7_6 = var5_3.invoke((Object)it);
                        v4 = var7_6;
                    }
                    catch (Throwable var8_9) {
                        var6_5 = var8_9;
                        throw var8_9;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)var4_13, (Throwable)var6_5);
                    }
                } else {
                    v4 = null;
                }
                return (T)v4;
            }

            public String prepareSQL(Transaction transaction, boolean prepared2) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                return this.$stmt;
            }

            /*
             * WARNING - void declaration
             */
            public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
                void $this$mapTo$iv$iv;
                Iterable<Pair<IColumnType<?>, Object>> $this$map$iv = this.$args;
                boolean $i$f$map = false;
                Iterable<Pair<IColumnType<?>, Object>> iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    IColumnType iColumnType;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IColumnType columnType = (IColumnType)pair.component1();
                    Object value = pair.component2();
                    IColumnType $this$arguments_u24lambda_u243_u24lambda_u242 = iColumnType = columnType;
                    boolean bl2 = false;
                    $this$arguments_u24lambda_u243_u24lambda_u242.setNullable(true);
                    collection.add(TuplesKt.to((Object)iColumnType, (Object)value));
                }
                return CollectionsKt.listOf((Object)((List)destination$iv$iv));
            }

            public JdbcPreparedStatementApi prepared(JdbcTransaction transaction, String sql) {
                return BlockingExecutable.DefaultImpls.prepared(this, transaction, sql);
            }

            public boolean isAlwaysBatch() {
                return BlockingExecutable.DefaultImpls.isAlwaysBatch(this);
            }

            public T execute(JdbcTransaction transaction) {
                return BlockingExecutable.DefaultImpls.execute(this, transaction);
            }
        });
    }

    public static /* synthetic */ Object exec$default(JdbcTransaction jdbcTransaction, String string, Iterable iterable, StatementType statementType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return jdbcTransaction.exec(string, iterable, statementType, function1);
    }

    @Nullable
    public final <T> T exec(@NotNull BlockingExecutable<? extends T, ?> stmt) {
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        return (T)this.exec(stmt, JdbcTransaction::exec$lambda$11);
    }

    public final void execInBatch(@NotNull List<String> stmts) {
        Intrinsics.checkNotNullParameter(stmts, (String)"stmts");
        this.getConnection().executeInBatch(stmts);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T, R> R exec(@NotNull BlockingExecutable<? extends T, ?> stmt, @NotNull Function2<? super Statement<? extends T>, ? super T, ? extends R> body) {
        Object object;
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        int n = this.getStatementCount();
        this.setStatementCount(n + 1);
        long start = System.nanoTime();
        Pair<? extends T, List<StatementContext>> answer = BlockingExecutableKt.executeIn(stmt, this);
        long it2 = System.nanoTime() - start;
        boolean bl = false;
        long delta = TimeUnit.NANOSECONDS.toMillis(it2);
        Lazy lazySQL = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JdbcTransaction.exec$lambda$14(answer, this));
        this.setDuration(this.getDuration() + delta);
        if (this.getDebug()) {
            Object object2;
            void $this$getOrPut$iv;
            this.getStatements().append(this.describeStatement(delta, (String)lazySQL.getValue()));
            Map it2 = this.getStatementStats();
            Object key$iv = lazySQL.getValue();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Pair answer$iv = TuplesKt.to((Object)0, (Object)0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Pair pair = (Pair)object2;
            boolean bl3 = false;
            int count = ((Number)pair.component1()).intValue();
            long time = ((Number)pair.component2()).longValue();
            ((Map)this.getStatementStats()).put(lazySQL.getValue(), TuplesKt.to((Object)(count + 1), (Object)(time + delta)));
        }
        Long l = this.getWarnLongQueriesDuration();
        if (delta > (l != null ? l : Long.MAX_VALUE)) {
            SQLLogKt.getExposedLogger().warn("Long query: " + this.describeStatement(delta, (String)lazySQL.getValue()), (Throwable)new LongQueryException());
        }
        Object object3 = answer.getFirst();
        if (object3 != null) {
            Object it3 = object3;
            boolean bl4 = false;
            object = body.invoke(stmt.getStatement(), it3);
        } else {
            object = null;
        }
        return (R)object;
    }

    @Nullable
    public final <R> R execQuery(@NotNull BlockingExecutable<? extends ResultApi, ?> query, @NotNull Function2<? super Statement<? extends ResultApi>, ? super ResultSet, ? extends R> body) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.exec(query, (arg_0, arg_1) -> JdbcTransaction.execQuery$lambda$18(body, arg_0, arg_1));
    }

    @NotNull
    public final ResultSet execQuery$exposed_jdbc(@NotNull BlockingExecutable<? extends ResultApi, ?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        ResultSet resultSet = (ResultSet)this.execQuery(query, JdbcTransaction::execQuery$lambda$19);
        if (resultSet == null) {
            throw new IllegalStateException("A ResultSet was expected, but none was retrieved from the database".toString());
        }
        return resultSet;
    }

    public final void closeExecutedStatements() {
        Iterable $this$forEach$iv = this.executedStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdbcPreparedStatementApi it = (JdbcPreparedStatementApi)element$iv;
            boolean bl = false;
            it.closeIfPossible();
        }
        this.openResultSetsCount = 0;
        this.executedStatements.clear();
    }

    @Override
    @NotNull
    public final CompositeSqlLogger addLogger(SqlLogger ... logger) {
        CompositeSqlLogger compositeSqlLogger;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        CompositeSqlLogger $this$addLogger_u24lambda_u2421 = compositeSqlLogger = super.addLogger(Arrays.copyOf(logger, logger.length));
        boolean bl = false;
        this.registerInterceptor($this$addLogger_u24lambda_u2421);
        return compositeSqlLogger;
    }

    public final long getRetryInterval$exposed_jdbc() {
        return this.maxAttempts > 0 ? Math.max((this.maxRetryDelay - this.minRetryDelay) / (long)(this.maxAttempts + 1), 1L) : 0L;
    }

    @Override
    public boolean getReadOnly() {
        return this.transactionImpl.getReadOnly();
    }

    @Override
    @Nullable
    public JdbcTransaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionImpl.getTransactionIsolation();
    }

    @Override
    @NotNull
    public ExposedConnection<?> getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    private static final Unit exec$lambda$9(ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Object exec$lambda$11(Statement $this$exec, Object it) {
        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final String exec$lambda$14(Pair $answer, JdbcTransaction this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)$answer.getSecond();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StatementContext statementContext = (StatementContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.sql(this$0));
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    private static final Object execQuery$lambda$18(Function2 $body, Statement $this$exec, ResultApi it) {
        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $body.invoke((Object)$this$exec, (Object)((JdbcResult)it).getResult());
    }

    private static final ResultSet execQuery$lambda$19(Statement $this$execQuery, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$this$execQuery, (String)"$this$execQuery");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    static {
        ServiceLoader<GlobalStatementInterceptor> serviceLoader = ServiceLoader.load(GlobalStatementInterceptor.class, GlobalStatementInterceptor.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            globalInterceptors.add(it);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R'\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lme/jfenn/coordshud/jetbrains/exposed/v1/jdbc/JdbcTransaction$Companion;", "", "<init>", "()V", "Ljava/util/ArrayList;", "Lme/jfenn/coordshud/jetbrains/exposed/v1/core/statements/GlobalStatementInterceptor;", "Lkotlin/collections/ArrayList;", "globalInterceptors", "Ljava/util/ArrayList;", "getGlobalInterceptors", "()Ljava/util/ArrayList;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<GlobalStatementInterceptor> getGlobalInterceptors() {
            return globalInterceptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

