/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.biome.RoseQuartzUtils;
import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5542;
import net.minecraft.class_5721;
import net.minecraft.class_5732;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5863;

public class LargeRoseQuartzFeature
extends class_3031<class_5732> {
    public LargeRoseQuartzFeature(Codec<class_5732> p_159960_) {
        super(p_159960_);
    }

    public boolean method_13151(class_5821<class_5732> p_159967_) {
        class_5281 worldgenlevel = p_159967_.method_33652();
        class_2338 blockpos = p_159967_.method_33655();
        class_5732 largedripstoneconfiguration = (class_5732)p_159967_.method_33656();
        class_5819 random = p_159967_.method_33654();
        if (!RoseQuartzUtils.isEmptyOrWater((class_1936)worldgenlevel, blockpos)) {
            return false;
        }
        Optional optional = class_5721.method_32982((class_3746)worldgenlevel, (class_2338)blockpos, (int)largedripstoneconfiguration.field_28228, RoseQuartzUtils::isEmptyOrWater, RoseQuartzUtils::isRoseQuartzBaseOrLava);
        if (optional.isPresent() && optional.get() instanceof class_5721.class_5723) {
            class_5721.class_5723 column$range = (class_5721.class_5723)optional.get();
            if (column$range.method_32992() < 4) {
                return false;
            }
            int i = (int)((float)column$range.method_32992() * largedripstoneconfiguration.field_28231);
            int j = class_3532.method_15340((int)i, (int)largedripstoneconfiguration.field_28229.method_35009(), (int)largedripstoneconfiguration.field_28229.method_35011());
            int k = class_3532.method_32751((class_5819)random, (int)largedripstoneconfiguration.field_28229.method_35009(), (int)j);
            LargeRoseQuartz largedripstonefeature$largedripstone = LargeRoseQuartzFeature.makeRoseQuartz(blockpos.method_33096(column$range.method_32990() - 1), false, random, k, largedripstoneconfiguration.field_28232, largedripstoneconfiguration.field_28230);
            LargeRoseQuartz largedripstonefeature$largedripstone1 = LargeRoseQuartzFeature.makeRoseQuartz(blockpos.method_33096(column$range.method_32991() + 1), true, random, k, largedripstoneconfiguration.field_28233, largedripstoneconfiguration.field_28230);
            WindOffsetter largedripstonefeature$windoffsetter = largedripstonefeature$largedripstone.isSuitableForWind(largedripstoneconfiguration) && largedripstonefeature$largedripstone1.isSuitableForWind(largedripstoneconfiguration) ? new WindOffsetter(blockpos.method_10264(), random, largedripstoneconfiguration.field_28234) : WindOffsetter.noWind();
            boolean flag = largedripstonefeature$largedripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            boolean flag1 = largedripstonefeature$largedripstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            if (flag) {
                largedripstonefeature$largedripstone.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            if (flag1) {
                largedripstonefeature$largedripstone1.placeBlocks(worldgenlevel, random, largedripstonefeature$windoffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeRoseQuartz makeRoseQuartz(class_2338 p_159969_, boolean p_159970_, class_5819 p_159971_, int p_159972_, class_5863 p_159973_, class_5863 p_159974_) {
        return new LargeRoseQuartz(p_159969_, p_159970_, p_159972_, p_159973_.method_33920(p_159971_), p_159974_.method_33920(p_159971_));
    }

    static final class LargeRoseQuartz {
        private class_2338 root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeRoseQuartz(class_2338 p_159981_, boolean p_159982_, int p_159983_, double p_159984_, double p_159985_) {
            this.root = p_159981_;
            this.pointingUp = p_159982_;
            this.radius = p_159983_;
            this.bluntness = p_159984_;
            this.scale = p_159985_;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.method_10264() : this.root.method_10264() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.method_10264() : this.root.method_10264() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(class_5281 p_159990_, WindOffsetter p_159991_) {
            while (this.radius > 1) {
                class_2338.class_2339 blockpos$mutableblockpos = this.root.method_25503();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (p_159990_.method_8320((class_2338)blockpos$mutableblockpos).method_27852(class_2246.field_10164)) {
                        return false;
                    }
                    if (RoseQuartzUtils.isCircleMostlyEmbeddedInStone(p_159990_, p_159991_.offset((class_2338)blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.method_10098(this.pointingUp ? class_2350.field_11033 : class_2350.field_11036);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float p_159988_) {
            return (int)RoseQuartzUtils.getRoseQuartzHeight(p_159988_, this.radius, this.scale, this.bluntness);
        }

        /*
         * Enabled aggressive block sorting
         */
        void placeBlocks(class_5281 p_159993_, class_5819 p_159994_, WindOffsetter p_159995_) {
            int i = -this.radius;
            block5: while (i <= this.radius) {
                int j = -this.radius;
                while (true) {
                    block13: {
                        boolean flag;
                        class_2338.class_2339 blockpos$mutableblockpos;
                        int k;
                        block14: {
                            block12: {
                                if (j > this.radius) break block12;
                                float f = class_3532.method_15355((float)(i * i + j * j));
                                if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) break block13;
                                if ((double)p_159994_.method_43057() < 0.2) {
                                    k = (int)((float)k * class_3532.method_32750((class_5819)p_159994_, (float)0.8f, (float)1.0f));
                                }
                                blockpos$mutableblockpos = this.root.method_10069(i, 0, j).method_25503();
                                flag = false;
                                break block14;
                            }
                            ++i;
                            continue block5;
                        }
                        for (int l = 0; l < k; ++l) {
                            block17: {
                                int n;
                                class_2350[] class_2350Array;
                                class_2338 blockpos;
                                block16: {
                                    block15: {
                                        blockpos = p_159995_.offset((class_2338)blockpos$mutableblockpos);
                                        if (!RoseQuartzUtils.isEmptyOrWaterOrLava((class_1936)p_159993_, blockpos) && !p_159993_.method_8320(blockpos).method_26164(class_3481.field_26986) && !(p_159993_.method_8320(blockpos).method_26204() instanceof class_5542)) break block15;
                                        flag = true;
                                        class_2248 block = BOPBlocks.ROSE_QUARTZ_BLOCK;
                                        p_159993_.method_8652(blockpos, block.method_9564(), 2);
                                        class_2350Array = class_2350.values();
                                        n = class_2350Array.length;
                                        break block16;
                                    }
                                    if (flag && p_159993_.method_8320(blockpos).method_27852(class_2246.field_10515)) {
                                        break;
                                    }
                                    break block17;
                                }
                                for (int i2 = 0; i2 < n; ++i2) {
                                    class_2350 direction = class_2350Array[i2];
                                    if (p_159994_.method_43048(2) != 0) continue;
                                    class_2680 state = (class_2680)(switch (p_159994_.method_43048(6)) {
                                        case 3 -> BOPBlocks.ROSE_QUARTZ_CLUSTER.method_9564();
                                        default -> BOPBlocks.LARGE_ROSE_QUARTZ_BUD.method_9564();
                                        case 1 -> BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD.method_9564();
                                        case 0 -> BOPBlocks.SMALL_ROSE_QUARTZ_BUD.method_9564();
                                    }).method_11657((class_2769)class_5542.field_27087, (Comparable)direction);
                                    if (!p_159993_.method_22347(blockpos.method_10093(direction)) || !state.method_26184((class_4538)p_159993_, blockpos.method_10093(direction))) continue;
                                    p_159993_.method_8652(blockpos.method_10093(direction), state, 2);
                                }
                            }
                            blockpos$mutableblockpos.method_10098(this.pointingUp ? class_2350.field_11036 : class_2350.field_11033);
                        }
                    }
                    ++j;
                }
                break;
            }
            return;
        }

        boolean isSuitableForWind(class_5732 p_159997_) {
            return this.radius >= p_159997_.field_28235 && this.bluntness >= (double)p_159997_.field_28236;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final class_243 windSpeed;

        WindOffsetter(int p_160004_, class_5819 p_160005_, class_5863 p_160006_) {
            this.originY = p_160004_;
            float f = p_160006_.method_33920(p_160005_);
            float f1 = class_3532.method_32750((class_5819)p_160005_, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new class_243((double)(class_3532.method_15362((double)f1) * f), 0.0, (double)(class_3532.method_15374((double)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        class_2338 offset(class_2338 p_160009_) {
            if (this.windSpeed == null) {
                return p_160009_;
            }
            int i = this.originY - p_160009_.method_10264();
            class_243 vec3 = this.windSpeed.method_1021((double)i);
            return p_160009_.method_10069(class_3532.method_15357((double)vec3.field_1352), 0, class_3532.method_15357((double)vec3.field_1350));
        }
    }
}

